package org.krproject.ocean.skeletons.octopus.online.event;

import java.util.Date;

import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineRequest;
import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineResponse;
import org.krproject.ocean.skeletons.octopus.online.inbound.AbstractHandler;
import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 上游渠道交易处理完成事件.
 * @author Tiger
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class HandleCompletedEvent extends ApplicationEvent {
	
	public HandleCompletedEvent(Object source, 
			String instanceId,
			OctopusSkeletonOnlineRequest<?> request, 
			Date requestTime,
			AbstractHandler<?, ?> handler,
			OctopusSkeletonOnlineResponse response, 
			Date responseTime) {
		super(source);
		this.instanceId = instanceId;
		this.request = request;
		this.requestTime = requestTime;
		this.handler = handler;
		this.response = response;
		this.responseTime = responseTime;
	}

	// 实例编号
	private String instanceId;	

	// 上游渠道交易请求
	private OctopusSkeletonOnlineRequest<?> request;	
	
	// 上游渠道交易请求时间
	private Date requestTime;
	
	// 上游渠道交易处理器
	private AbstractHandler<?, ?> handler;
	
	// 上游渠道交易响应
	private OctopusSkeletonOnlineResponse response;
	
	// 上游渠道交易响应时间
	private Date responseTime;
}
