package org.krproject.ocean.skeletons.octopus.param;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.krproject.ocean.vitamins.param.document.Param;
import org.krproject.ocean.vitamins.param.document.ParamField;

import lombok.Data;

/**
 * 上游渠道参数.
 * 
 * @author Tiger
 */
@Data
@Param(name = "上游渠道参数", desc = "对于上游对接渠道的定义与控制")
@SuppressWarnings("serial")
public class InboundChannelParam implements Serializable {

	@ParamField(name = "渠道代码", desc = "渠道代码", key = true)
	private String code;
	
	@ParamField(name = "渠道名称", desc = "渠道名称")
	private String name;
	
	@ParamField(name = "渠道描述", desc = "渠道描述")
	private String desc;

	@ParamField(name = "是否启用交易控制", desc = "是否启用交易控制", defaultValue = "false")
	private Boolean transControlEnabled = false;
	
	@ParamField(name = "交易控制允许的交易列表", desc = "交易控制允许的交易列表")
	private List<String> transControlPermittedRequests = new ArrayList<String>();
	
	@ParamField(name = "是否启用降级", desc = "是否启用降级", defaultValue = "false")
	private Boolean fallbackEnabled = false;
	
	@ParamField(name = "降级方案", desc = "降级方案")
	private String fallbackScenario = "";
}
