package org.krproject.ocean.vitamins.batch.api;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;

import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * Batch请求抽象类.
 * 
 * @param <T> 响应
 * 
 * @author zhongyang
 *
 */
@Data
@SuppressWarnings("serial")
public abstract class BatchRequest<T extends BatchResponse> implements Serializable {
	
	@JsonIgnore
	@SuppressWarnings("unchecked")
	public Class<T> getResponseClass() {
		Class<T> tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}
	
	public T createResponse() {
		T response = null;
		try {
			response = this.getResponseClass().newInstance();
			response.setRespCode(BatchRespCodeEnum.SUCCESS.getRespCode());
			response.setRespDesc(BatchRespCodeEnum.SUCCESS.toString());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return response;
	}
	
}
