package org.krproject.ocean.vitamins.domain.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;


/**
 * H2服务配置.
 * 
 * @author Tiger
 */
@Data
@ConfigurationProperties(prefix = "krproject.ocean.domain.h2")
public class DomainH2ServerProperties {

	/**
	 * H2的tcp服务是否启用，默认为否.
	 */
	private Boolean tcpEnabled = false;
	
	/**
	 * H2的tcp服务端口，默认为9092.
	 */
	private String tcpPort = "9092";
	

	/**
	 * H2的web服务是否启用，默认为否.
	 */
	private Boolean webEnabled = false;
	
	/**
	 * H2的web服务端口，默认为8082. 
	 */
	private String webPort = "8082";
	
}
