package org.krproject.ocean.vitamins.domain.document;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 字段文档注解.
 * @author liao_qping
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface DomainColumn {

	/**
	 * 字段名称.
	 * @return 字段名称
	 */
	String name();
	
	/**
	 * 字段描述.
	 * @return 字段描述
	 */
	String desc() default "";

}
