package org.krproject.ocean.vitamins.domain.document;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 分区文档注解.
 * @author liao_qping
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({})
public @interface DomainPartition {
	
	/**
	 * 分区字段.
	 * @return 分区字段.
	 */
	String[] columns();
	
	/**
	 * 分区描述.
	 * @return 分区描述
	 */
	String desc() default "";
	
	/**
	 * 分区单位.
	 * @return 分区单位
	 */
	PartitionUnit unit() default PartitionUnit.MONTH;
	
	/**
	 * 分区类型.
	 * @return 分区类型 
	 */
	PartitionType type() default PartitionType.RANGE;
	
	/**
	 * 分区保留个数.
	 * @return 分区保留个数.
	 */
	int backward() default -1;
	
	/**
	 * 分区预留个数.
	 * @return 分区预留个数.
	 */
	int forward() default -1;
	
	
	/**
	 * 分区单位.
	 * @author liao_qping
	 *
	 */
	enum PartitionUnit {
		
		DAY,
		
		MONTH,
		
		YEAR;
	}
	
	
	/**
	 * 分区类型.
	 * @author liao_qping
	 *
	 */
	enum PartitionType {

		/**
		 * 范围分区.
		 */
		RANGE,
		
		/**
		 * 列表分区.
		 */
		LIST,
		
		/**
		 * 散列分区.
		 */
		HASH,
		
		/**
		 * 范围列表分区.
		 */
		RANGE_LIST,
		
		/**
		 * 范围hash分区.
		 */
		RANGE_HASH;

	}

}
