package org.krproject.ocean.vitamins.domain.document;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 表文档注解.
 * @author liao_qping
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface DomainTable {

	/**
	 * 表名称.
	 * @return 表名称
	 */
	String name();
	
	/**
	 * 表描述.
	 * @return 表描述
	 */
	String desc() default "";

	/**
	 * 表分区.
	 * @return 表分区
	 */
	DomainPartition partition() default @DomainPartition(columns = {});

}
