package org.krproject.ocean.vitamins.online.api.document;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 联机接口响应文档注解.
 * 
 * @author Tiger
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface ApiResponse {

	/**
	 * 响应名称.
	 * @return 表名称
	 */
	String name();
	
	/**
	 * 响应描述.
	 * @return 表描述
	 */
	String desc() default "";
}
