package org.krproject.ocean.vitamins.online.api.document;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 联机接口响应字段文档注解.
 * 
 * @author Tiger
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ApiResponseField {

	/**
	 * 字段名称.
	 * @return 字段名称
	 */
	String name();
	
	/**
	 * 字段描述.
	 * @return 字段描述
	 */
	String desc() default "";
	
	/**
	 * 字段长度.
	 * @return 字段长度
	 */
	int length();

	/**
	 * 是否可空.
	 * @return 是否可空，默认不能为空
	 */
	boolean nullable() default false;

}
