/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.online.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class OnlinePageRequest
implements Pageable {
    private int page;
    private int size;
    @JsonProperty(value="sort")
    private List<PageOrder> pageOrders;

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public List<PageOrder> getPageOrders() {
        return this.pageOrders;
    }

    public void setPageOrders(List<PageOrder> pageOrders) {
        this.pageOrders = pageOrders;
    }

    public OnlinePageRequest() {
        this.pageOrders = new ArrayList<PageOrder>();
    }

    public OnlinePageRequest(int page, int size) {
        this.page = page;
        this.size = size;
        this.pageOrders = new ArrayList<PageOrder>();
    }

    public OnlinePageRequest(Pageable pageable) {
        this.page = pageable.getPageNumber();
        this.size = pageable.getPageSize();
        if (pageable.getSort() != null && pageable.getSort().iterator() != null) {
            Iterator iterator = pageable.getSort().iterator();
            ArrayList<PageOrder> pageOrders = new ArrayList<PageOrder>();
            while (iterator.hasNext()) {
                Sort.Order order = (Sort.Order)iterator.next();
                PageOrder pageOrder = new PageOrder();
                pageOrder.setDirection(order.getDirection());
                pageOrder.setProperty(order.getProperty());
                pageOrders.add(pageOrder);
            }
            this.pageOrders = pageOrders;
        } else {
            this.pageOrders = new ArrayList<PageOrder>();
        }
    }

    public OnlinePageRequest(int page, int size, List<PageOrder> pageOrders) {
        this.page = page;
        this.size = size;
        this.pageOrders = pageOrders;
    }

    @JsonIgnore
    public boolean isPaged() {
        return super.isPaged();
    }

    @JsonIgnore
    public boolean isUnpaged() {
        return super.isUnpaged();
    }

    @JsonIgnore
    public int getPageNumber() {
        return this.page;
    }

    @JsonIgnore
    public int getPageSize() {
        return this.size;
    }

    @JsonIgnore
    public long getOffset() {
        return this.page * this.size;
    }

    @JsonIgnore
    public Sort getSort() {
        Sort sort = null;
        if (this.pageOrders != null && !this.pageOrders.isEmpty()) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (PageOrder pageOrder : this.pageOrders) {
                Sort.Order order = new Sort.Order(pageOrder.getDirection(), pageOrder.getProperty());
                orders.add(order);
            }
            sort = Sort.by(orders);
        } else {
            sort = Sort.unsorted();
        }
        return sort;
    }

    public Pageable withPage(int pageNumber) {
        return new OnlinePageRequest(pageNumber, this.getPageSize(), this.pageOrders);
    }

    public Pageable next() {
        return new OnlinePageRequest(this.getPageNumber() + 1, this.getPageSize(), this.pageOrders);
    }

    public Pageable previous() {
        return this.getPageNumber() == 0 ? this : new OnlinePageRequest(this.getPageNumber() - 1, this.getPageSize(), this.pageOrders);
    }

    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public Pageable first() {
        return new OnlinePageRequest(0, this.getPageSize(), this.pageOrders);
    }

    public boolean hasPrevious() {
        return this.page > 0;
    }

    public static class PageOrder
    implements Serializable {
        private Sort.Direction direction;
        private String property;

        public Sort.Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Sort.Direction direction) {
            this.direction = direction;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }
    }
}

