/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.vitamins.online.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.krproject.ocean.vitamins.online.api.OnlinePageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class OnlinePageResponse<T>
implements Serializable,
Page<T> {
    private long total;
    private OnlinePageRequest pageable;
    private List<T> content;

    public OnlinePageResponse() {
    }

    public OnlinePageResponse(List<T> content) {
        this(content, null, content.size());
    }

    public OnlinePageResponse(List<T> content, OnlinePageRequest pageable) {
        this(content, pageable, content.size());
    }

    public OnlinePageResponse(List<T> content, OnlinePageRequest pageable, long total) {
        this.content = content;
        this.pageable = pageable;
        this.total = total;
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    @JsonIgnore
    public int getNumber() {
        return this.pageable == null ? 0 : this.pageable.getPageNumber();
    }

    @JsonIgnore
    public int getNumberOfElements() {
        return this.content.size();
    }

    @JsonIgnore
    public int getSize() {
        return this.pageable == null ? 0 : this.pageable.getPageSize();
    }

    @JsonIgnore
    public Sort getSort() {
        return this.pageable == null ? null : this.pageable.getSort();
    }

    @JsonIgnore
    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @JsonIgnore
    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    @JsonIgnore
    public boolean hasPrevious() {
        return this.getNumber() > 0;
    }

    @JsonIgnore
    public boolean isFirst() {
        return !this.hasPrevious();
    }

    @JsonIgnore
    public boolean isLast() {
        return !this.hasNext();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public Pageable nextPageable() {
        return this.hasNext() ? this.pageable.next() : null;
    }

    public Pageable previousPageable() {
        if (this.hasPrevious()) {
            return this.pageable.previousOrFirst();
        }
        return null;
    }

    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @JsonIgnore
    public int getTotalPages() {
        return this.getSize() == 0 ? 1 : (int)Math.ceil(this.total / (long)this.getSize());
    }

    @JsonIgnore
    public long getTotalElements() {
        return this.total;
    }

    protected <U> List<U> getConvertedContent(Function<? super T, ? extends U> converter) {
        Assert.notNull(converter, (String)"Function must not be null!");
        return this.stream().map(converter::apply).collect(Collectors.toList());
    }

    public <S> Page<S> map(Function<? super T, ? extends S> paramConverter) {
        return new OnlinePageResponse<S>(this.getConvertedContent(paramConverter), this.pageable);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public OnlinePageRequest getPageable() {
        return this.pageable;
    }

    public void setPageable(OnlinePageRequest pageable) {
        this.pageable = pageable;
    }

    public void setContent(List<T> content) {
        this.content = content;
    }
}

