package org.krproject.schedule.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

/**
 * Schedule配置.
 *
 * @author Tiger
 *
 */
@Configuration
@EnableScheduling
@EnableJpaAuditing
@EntityScan({"org.krproject.schedule.domain"})
@EnableJpaRepositories({"org.krproject.schedule.domain"})
@EnableConfigurationProperties(ScheduleProperties.class)
public class ScheduleConfig implements SchedulingConfigurer {
	
	@Autowired
	private ScheduleProperties scheduleProperties;
	
	@Override
	public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
		scheduledTaskRegistrar.setTaskScheduler(krprojectTaskScheduler());
	}
	
	@Bean
	public ThreadPoolTaskScheduler krprojectTaskScheduler() {
		ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
		taskScheduler.setThreadNamePrefix("krproject-schedule-task-");
		taskScheduler.setPoolSize(this.scheduleProperties.getTaskPoolSize()); //线程池大小
		taskScheduler.setWaitForTasksToCompleteOnShutdown(this.scheduleProperties.getWaitForShutDown()); //是否等待执行线程结束
		taskScheduler.setAwaitTerminationSeconds(this.scheduleProperties.getWaitSeconds()); //等待时长
		return taskScheduler;
	}

}
