package org.krproject.schedule.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;


/**
 * Schedule属性配置对象.
 * 
 * @author Tiger
 */
@Data
@ConfigurationProperties(prefix = "krproject.schedule")
public class ScheduleProperties {
	
	/**
	 * 定时任务执行线程池大小，默认为5.
	 */
	private Integer taskPoolSize = 5;
	
	/**
	 * 定时任务执行是否等待关闭，默认为true.
	 */
	private Boolean waitForShutDown = true;
	
	/**
	 * 定时任务执行关闭等待时常，默认为60.
	 */
	private Integer waitSeconds = 60;


}
