package org.krproject.schedule.domain;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import lombok.Data;

/**
 * 定时任务定义表.
 * 
 * @author Tiger
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "SCHEDULE_TASK_DEFINE", 
indexes = {
		@Index(name = "IDX_SCHEDULE_TASK_DEFINE_1", columnList = "TASK_CLASS_NAME", unique = false)
		}
)
@SuppressWarnings("serial")
public class ScheduleTaskDefine implements Serializable {
	
	@Id
	@Column(name = "TASK_NAME", nullable = false, length = 40)
	private String taskName;
	
	@Column(name = "TASK_DESC", nullable = true, length = 200)
	private String taskDesc;
	
	@Column(name = "TASK_CLASS_NAME", nullable = true, length = 100)
	private String taskClassName;

	@Column(name = "TASK_CRON", nullable = true, length = 20)
	private String taskCron;
	
	@Column(name = "ENABLED", nullable = true)
	private Boolean enabled;
	
	@CreatedDate
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CREATE_TIME", nullable = true)
	private Date createTime;
	
	@LastModifiedDate
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "LAST_UPDATE_TIME", nullable = true)
	private Date lastUpdateTime;

	@Version
	@Column(name = "JPA_VERSION", nullable = false)
	private Integer jpaVersion;
}
