package org.krproject.schedule.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.krproject.schedule.domain.enums.TaskStatusDef;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import lombok.Data;

/**
 * 定时任务执行日志表.
 * 
 * @author Tiger
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "SCHEDULE_TASK_JOURNAL", 
indexes = {
		@Index(name = "IDX_SCHEDULE_TASK_JOURNAL_1", columnList = "TASK_NAME", unique = false),
		@Index(name = "IDX_SCHEDULE_TASK_JOURNAL_2", columnList = "TASK_CLASS_NAME", unique = false)
		}
)
@SuppressWarnings("serial")
public class ScheduleTaskJournal implements Serializable {
	
	@Id
	@GeneratedValue(generator = "generator")
	@GenericGenerator(name = "generator", strategy = "org.hibernate.id.enhanced.SequenceStyleGenerator", 
		parameters = {
			@Parameter(name = "sequence_name", value = "SEQ_SCHEDULE_TASK_JOURNAL")
		}
	)
	@Column(name = "JOURNAL_ID", nullable = false, precision = 12, scale = 0)
	private BigDecimal journalId;
	
	@Column(name = "TASK_NAME", nullable = true, length = 40)
	private String taskName;

	@Column(name = "TASK_DESC", nullable = true, length = 200)
	private String taskDesc;

	@Column(name = "TASK_CLASS_NAME", nullable = true, length = 100)
	private String taskClassName;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "START_TIME", nullable = true)
	private Date startTime;
	
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "END_TIME", nullable = true)
	private Date endTime;
	
	@Enumerated(EnumType.STRING)
	@Column(name = "TASK_STATUS", nullable = true, length = 1)
	private TaskStatusDef taskStatus;
	
	//Task可以自定义放一些信息进来
	@Column(name = "TASK_CONTENT", nullable = true, length = 500)
	private String taskContent;
	
	@CreatedDate
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CREATE_TIME", nullable = true)
	private Date createTime;
	
	@LastModifiedDate
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "LAST_UPDATE_TIME", nullable = true)
	private Date lastUpdateTime;

	@Version
	@Column(name = "JPA_VERSION", nullable = false)
	private Integer jpaVersion;
}
