package org.krproject.schedule.domain;

import java.math.BigDecimal;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;

/**
 * 定时任务执行日志仓库.
 * 
 * @author Tiger
 */
public interface ScheduleTaskJournalRepository extends JpaRepository<ScheduleTaskJournal, BigDecimal> {
	
	Page<ScheduleTaskJournal> findByTaskName(String taskName, Pageable pageable);
	
	Page<ScheduleTaskJournal> findByTaskClassName(String taskClassName, Pageable pageable);
	
}
