package org.krproject.schedule.service;

import java.util.Date;

import org.krproject.schedule.domain.ScheduleTaskDefine;
import org.krproject.schedule.domain.ScheduleTaskJournal;
import org.krproject.schedule.domain.ScheduleTaskJournalRepository;
import org.krproject.schedule.domain.enums.TaskStatusDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * 定时任务抽象类.
 * 主要封装了任务日志表相关记录.
 * 
 * @author Tiger
 */
public abstract class AbstractScheduleTask {

	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	@Autowired
	private ScheduleTaskJournalRepository scheduleTaskJournalRepository;

	public abstract String getDesc();
	
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public abstract boolean doRun(ScheduleTaskDefine std, ScheduleTaskJournal stj);

	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public ScheduleTaskJournal preRun(ScheduleTaskDefine std) {
		this.logger.debug("before doRun...");
		ScheduleTaskJournal osj = new ScheduleTaskJournal();
		osj.setTaskName(std.getTaskName());
		osj.setTaskDesc(std.getTaskDesc());
		osj.setTaskClassName(std.getTaskClassName());
		osj.setTaskStatus(TaskStatusDef.I);
		osj.setStartTime(new Date());
		
		osj = this.scheduleTaskJournalRepository.save(osj);
		return osj;
	}
	
	@Transactional(propagation = Propagation.REQUIRES_NEW)
	public void postRun(ScheduleTaskJournal stj, boolean result) {
		this.logger.debug("after doRun..., {}", result);
		stj.setEndTime(new Date());
		stj.setTaskStatus(result ? TaskStatusDef.S : TaskStatusDef.F);
		stj = this.scheduleTaskJournalRepository.save(stj);
	}

}
