package org.krproject.schedule.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import org.krproject.schedule.domain.ScheduleTaskDefine;
import org.krproject.schedule.domain.ScheduleTaskJournal;
import org.krproject.schedule.exception.ScheduleException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;


/**
 * 定时任务服务接口.
 * 
 * @author Tiger
 */
public interface ScheduleService {

	//调度操作
	void start();
	void stop();
	
	//调度任务操作
	Map<String, ScheduledTask> taskMap();
	ScheduledTask taskGet(String taskName);
	ScheduledTask taskSchedule(String taskName) throws ScheduleException;
	void taskCancel(String taskName) throws ScheduleException;
	
	//调度任务类操作
	List<AbstractScheduleTask> taskClassList();
	AbstractScheduleTask taskClassGet(String taskClassName);
	
	//调度任务定义操作
	Page<ScheduleTaskDefine> taskDefineList(Pageable pageable);
	Page<ScheduleTaskDefine> taskDefineListByTaskClassName(String taskClassName, Pageable pageable);
	ScheduleTaskDefine taskDefineGet(String taskName);
	ScheduleTaskDefine taskDefineAdd(ScheduleTaskDefine std);
	ScheduleTaskDefine taskDefineUpdate(String taskName, ScheduleTaskDefine std);
	void taskDefineRemove(String taskName);
	ScheduleTaskDefine taskDefineEnable(String taskName);
	ScheduleTaskDefine taskDefineDisable(String taskName);
	
	//调度任务日志操作
	Page<ScheduleTaskJournal> taskJournalList(Pageable pageable);
	Page<ScheduleTaskJournal> taskJournalListByTaskName(String taskName, Pageable pageable);
	Page<ScheduleTaskJournal> taskJournalListByTaskClassName(String taskClassName, Pageable pageable);
	ScheduleTaskJournal taskJournalGet(BigDecimal journalId);
}
