package org.krproject.schedule.service;

import java.util.concurrent.ScheduledFuture;

import org.krproject.schedule.domain.ScheduleTaskDefine;
import org.krproject.schedule.domain.ScheduleTaskJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 定时任务执行模型定义.
 * 
 * @author Tiger
 */
@Data
@NoArgsConstructor
public class ScheduledTask implements Runnable {
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	private ScheduleTaskDefine std;
	private AbstractScheduleTask ast;
	private ScheduledFuture<?> sf;
	
	public ScheduledTask(ScheduleTaskDefine std, AbstractScheduleTask ast) {
		this.std = std;
		this.ast = ast;
	}

	@Override
	public void run() {
		
		ScheduleTaskJournal stj = this.ast.preRun(this.std);
		
		Boolean result = this.ast.doRun(this.std, stj);
		
		this.ast.postRun(stj, result);
	}
	
	public boolean cancel(boolean mayInterruptIfRunning) {
		if (this.sf != null) {
			return this.sf.cancel(mayInterruptIfRunning);
		}
		return false;
	}

}
