/*
 * Decompiled with CFR 0.152.
 */
package org.kryptokrona.sdk.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kryptokrona.sdk.crypto.Base58Kt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lorg/kryptokrona/sdk/crypto/Base58;", "", "()V", "decode", "", "input", "", "decodeToBigInteger", "Ljava/math/BigInteger;", "divmod", "", "number", "firstDigit", "", "base", "divisor", "encode", "kryptokrona-crypto"})
@SourceDebugExtension(value={"SMAP\nBase58.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base58.kt\norg/kryptokrona/sdk/crypto/Base58\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class Base58 {
    @NotNull
    public static final Base58 INSTANCE = new Base58();

    private Base58() {
    }

    @NotNull
    public final String encode(@NotNull byte[] input) {
        int zeros;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] input2 = input;
        if (input2.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input2.length && input2[zeros] == 0; ++zeros) {
        }
        byte[] byArray = Arrays.copyOf(input2, input2.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(input, input.size)");
        input2 = byArray;
        char[] encoded = new char[input2.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input2.length) {
            encoded[--outputStart] = Base58Kt.access$getALPHABET$p()[this.divmod(input2, inputStart, 256, 58)];
            if (input2[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == Base58Kt.access$getENCODED_ZERO$p()) {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = Base58Kt.access$getENCODED_ZERO$p();
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    @NotNull
    public final byte[] decode(@NotNull String input) {
        int zeros;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (((CharSequence)input).length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            int digit = c < '\u0080' ? Base58Kt.access$getINDEXES$p()[c] : -1;
            if (!(digit >= 0)) {
                boolean bl = false;
                Locale locale = Locale.US;
                String string = "Invalid character in Base58: 0x%04x";
                Object[] objectArray = new Object[]{(int)c};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
                String string3 = string2;
                throw new IllegalArgumentException(string3.toString());
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[input.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = this.divmod(input58, inputStart, 58, 256);
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        byte[] byArray = decoded;
        int n2 = outputStart - zeros;
        int n3 = decoded.length;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)n3);
    }

    @NotNull
    public final BigInteger decodeToBigInteger(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return new BigInteger(1, this.decode(input));
    }

    public final byte divmod(@NotNull byte[] number, int firstDigit, int base, int divisor) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        int remainder = 0;
        int n = number.length;
        for (int i = firstDigit; i < n; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    static {
        Arrays.fill(Base58Kt.access$getINDEXES$p(), -1);
        int n = Base58Kt.access$getALPHABET$p().length;
        for (int i = 0; i < n; ++i) {
            Base58Kt.access$getINDEXES$p()[Base58Kt.access$getALPHABET$p()[i]] = i;
        }
    }
}

