/*
 * Decompiled with CFR 0.152.
 */
package org.kryptokrona.sdk.crypto.util;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kryptokrona.sdk.crypto.util.HexUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"BYTE_MASK", "", "HEX_CHARS", "", "NIBBLE_MASK", "NIBBLE_SIZE_BITS", "RADIX", "convertBytesToHex", "bytes", "", "convertHexToBytes", "hex", "fromHex", "string", "toHex", "kryptokrona-crypto"})
@SourceDebugExtension(value={"SMAP\nHexUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexUtil.kt\norg/kryptokrona/sdk/crypto/util/HexUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1#2:120\n1864#3,3:121\n*S KotlinDebug\n*F\n+ 1 HexUtil.kt\norg/kryptokrona/sdk/crypto/util/HexUtilKt\n*L\n97#1:121,3\n*E\n"})
public final class HexUtilKt {
    @NotNull
    private static final String HEX_CHARS = "0123456789abcdef";
    private static final int BYTE_MASK = 255;
    private static final int NIBBLE_MASK = 15;
    private static final int NIBBLE_SIZE_BITS = 4;
    private static final int RADIX = 16;

    @NotNull
    public static final String toHex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        char[] cArray = HEX_CHARS.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] hexChars = cArray;
        StringBuilder result = new StringBuilder(bytes.length * 2);
        for (byte by : bytes) {
            int unsignedByte = by & 0xFF;
            result.append(hexChars[unsignedByte >> 4]);
            result.append(hexChars[unsignedByte & 0xF]);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public static final byte[] fromHex(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!(string.length() % 2 == 0)) {
            boolean $i$a$-require-HexUtilKt$fromHex$32 = false;
            String $i$a$-require-HexUtilKt$fromHex$32 = "Input must have an even number of characters";
            throw new IllegalArgumentException($i$a$-require-HexUtilKt$fromHex$32.toString());
        }
        char[] cArray = HEX_CHARS.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] hexChars = cArray;
        byte[] result = new byte[string.length() / 2];
        int n = string.length() + -1;
        int i = 0;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (i <= n2) {
            while (true) {
                int firstIndex = ArraysKt.indexOf((char[])hexChars, (char)Character.toLowerCase(string.charAt(i)));
                int secondIndex = ArraysKt.indexOf((char[])hexChars, (char)Character.toLowerCase(string.charAt(i + 1)));
                if (!(firstIndex != -1 && secondIndex != -1)) {
                    boolean bl = false;
                    String string2 = "Input contains invalid characters";
                    throw new IllegalArgumentException(string2.toString());
                }
                int byteValue = firstIndex << 4 | secondIndex;
                result[i / 2] = (byte)(byteValue & 0xFF);
                if (i == n2) break;
                i += 2;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] convertHexToBytes(@NotNull String hex) {
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        if (!(hex.length() % 2 == 0)) {
            boolean $i$a$-require-HexUtilKt$convertHexToBytes$22 = false;
            String $i$a$-require-HexUtilKt$convertHexToBytes$22 = "Input string must have an even number of characters.";
            throw new IllegalArgumentException($i$a$-require-HexUtilKt$convertHexToBytes$22.toString());
        }
        byte[] bytes = new byte[hex.length() / 2];
        int size = 2;
        Iterable $this$forEachIndexed$iv = StringsKt.chunked((CharSequence)hex, (int)size);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void byteVal;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int i = n;
            boolean bl = false;
            Integer n2 = StringsKt.toIntOrNull((String)byteVal, (int)16);
            if (n2 == null) {
                throw new IllegalArgumentException("Invalid character(s): " + (String)byteVal + ".");
            }
            int byteValue = n2;
            bytes[i] = (byte)(byteValue & 0xFF);
        }
        return bytes;
    }

    @NotNull
    public static final String convertBytesToHex(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, (Function1)convertBytesToHex.1.INSTANCE, (int)30, null);
    }
}

