/*
 * Decompiled with CFR 0.152.
 */
package org.kryptokrona.sdk.crypto;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kryptokrona.sdk.crypto.Base58;
import org.kryptokrona.sdk.crypto.Crypto;
import org.kryptokrona.sdk.crypto.Hash;
import org.kryptokrona.sdk.crypto.Keccak;
import org.kryptokrona.sdk.crypto.model.KeyImage;
import org.kryptokrona.sdk.crypto.model.WalletKeyPairs;
import org.kryptokrona.sdk.crypto.util.HexUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\u001a\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t\u001a.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a\u001a&\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016\u001a&\u0010 \u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0016\u001a\u0006\u0010!\u001a\u00020\"\u001a&\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"BITS_PER_BYTE", "", "BYTE_ARRAY_LENGTH", "CHECKSUM_SIZE", "CHUNK_5_LENGTH", "CHUNK_6_LENGTH", "CHUNK_8_LENGTH", "KEY_SIZE", "XKR_PREFIX", "", "crypto", "Lorg/kryptokrona/sdk/crypto/Crypto;", "hash", "Lorg/kryptokrona/sdk/crypto/Hash;", "keccak", "Lorg/kryptokrona/sdk/crypto/Keccak;", "generateAddress", "publicSpendKey", "publicViewKey", "generateKeyImage", "Lorg/kryptokrona/sdk/crypto/model/KeyImage;", "transactionPublicKey", "", "privateViewKey", "privateSpendKey", "outputIndex", "", "generateKeyImageFromOutput", "derivation", "index", "myPrivateSpendKey", "myPublicSpend", "generateKeyImagePrimitive", "generateKeyPairs", "Lorg/kryptokrona/sdk/crypto/model/WalletKeyPairs;", "generatePBKDF2DerivedKey", "password", "", "salt", "keyLength", "iterations", "kryptokrona-crypto"})
public final class KeyKt {
    private static final int BYTE_ARRAY_LENGTH = 32;
    private static final int BITS_PER_BYTE = 8;
    @NotNull
    private static final String XKR_PREFIX = "96d68801";
    private static final int CHECKSUM_SIZE = 4;
    private static final int KEY_SIZE = 32;
    private static final int CHUNK_8_LENGTH = 11;
    private static final int CHUNK_6_LENGTH = 9;
    private static final int CHUNK_5_LENGTH = 7;
    @NotNull
    private static final Crypto crypto = new Crypto();
    @NotNull
    private static final Keccak keccak = new Keccak();
    @NotNull
    private static final Hash hash = new Hash();

    @NotNull
    public static final KeyImage generateKeyImage(@NotNull byte[] transactionPublicKey, @NotNull byte[] privateViewKey, @NotNull byte[] publicSpendKey, @NotNull byte[] privateSpendKey, long outputIndex) {
        Intrinsics.checkNotNullParameter((Object)transactionPublicKey, (String)"transactionPublicKey");
        Intrinsics.checkNotNullParameter((Object)privateViewKey, (String)"privateViewKey");
        Intrinsics.checkNotNullParameter((Object)publicSpendKey, (String)"publicSpendKey");
        Intrinsics.checkNotNullParameter((Object)privateSpendKey, (String)"privateSpendKey");
        byte[] derivation = new byte[32];
        crypto.generateKeyDerivation(transactionPublicKey, privateViewKey, derivation);
        return KeyKt.generateKeyImagePrimitive(publicSpendKey, privateSpendKey, outputIndex, derivation);
    }

    @NotNull
    public static final KeyImage generateKeyImageFromOutput(@NotNull byte[] derivation, long index, @NotNull byte[] myPrivateSpendKey, @NotNull byte[] myPublicSpend) {
        Intrinsics.checkNotNullParameter((Object)derivation, (String)"derivation");
        Intrinsics.checkNotNullParameter((Object)myPrivateSpendKey, (String)"myPrivateSpendKey");
        Intrinsics.checkNotNullParameter((Object)myPublicSpend, (String)"myPublicSpend");
        byte[] publicSpendKey = new byte[32];
        byte[] derivedKey = new byte[32];
        crypto.derivePublicKey(derivation, index, myPublicSpend, publicSpendKey);
        crypto.deriveSecretKey(derivation, index, myPrivateSpendKey, derivedKey);
        byte[] image = new byte[32];
        crypto.generateKeyImage(publicSpendKey, myPrivateSpendKey, image);
        return new KeyImage(HexUtilKt.toHex(image), HexUtilKt.toHex(derivedKey));
    }

    @NotNull
    public static final KeyImage generateKeyImagePrimitive(@NotNull byte[] publicSpendKey, @NotNull byte[] privateSpendKey, long outputIndex, @NotNull byte[] derivation) {
        Intrinsics.checkNotNullParameter((Object)publicSpendKey, (String)"publicSpendKey");
        Intrinsics.checkNotNullParameter((Object)privateSpendKey, (String)"privateSpendKey");
        Intrinsics.checkNotNullParameter((Object)derivation, (String)"derivation");
        crypto.derivePublicKey(derivation, outputIndex, publicSpendKey, publicSpendKey);
        crypto.deriveSecretKey(derivation, outputIndex, privateSpendKey, privateSpendKey);
        byte[] image = new byte[32];
        crypto.generateKeyImage(publicSpendKey, privateSpendKey, image);
        return new KeyImage(HexUtilKt.toHex(image), HexUtilKt.toHex(privateSpendKey));
    }

    @NotNull
    public static final byte[] generatePBKDF2DerivedKey(@NotNull char[] password, @NotNull byte[] salt, int keyLength, int iterations) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterations, keyLength * 8);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        byte[] byArray = keyFactory.generateSecret(keySpec).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyFactory.generateSecret(keySpec).encoded");
        return byArray;
    }

    @NotNull
    public static final WalletKeyPairs generateKeyPairs() {
        byte[] publicSpendKey = new byte[32];
        byte[] privateSpendKey = new byte[32];
        byte[] seed = new byte[32];
        SecureRandom secureRandom = SecureRandom.getInstance("NativePRNGNonBlocking");
        Intrinsics.checkNotNullExpressionValue((Object)secureRandom, (String)"getInstance(\"NativePRNGNonBlocking\")");
        SecureRandom sr = secureRandom;
        sr.nextBytes(seed);
        crypto.generateKeys(publicSpendKey, privateSpendKey);
        byte[] output = new byte[32];
        keccak.computeHashValue(privateSpendKey, 32, output, 32);
        byte[] publicViewKey = new byte[32];
        byte[] privateViewKey = new byte[32];
        crypto.generateDeterministicViewKeys(publicViewKey, privateViewKey, output);
        return new WalletKeyPairs(HexUtilKt.toHex(publicSpendKey), HexUtilKt.toHex(privateSpendKey), HexUtilKt.toHex(publicViewKey), HexUtilKt.toHex(privateViewKey));
    }

    @NotNull
    public static final String generateAddress(@NotNull String publicSpendKey, @NotNull String publicViewKey) {
        int chunkSize;
        Intrinsics.checkNotNullParameter((Object)publicSpendKey, (String)"publicSpendKey");
        Intrinsics.checkNotNullParameter((Object)publicViewKey, (String)"publicViewKey");
        List bytes = new ArrayList();
        byte[] prefixBytes = HexUtilKt.convertHexToBytes(XKR_PREFIX);
        bytes.addAll(ArraysKt.toList((byte[])prefixBytes));
        String string = publicSpendKey;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        bytes.addAll(ArraysKt.toList((byte[])byArray));
        string = publicViewKey;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        bytes.addAll(ArraysKt.toList((byte[])byArray2));
        byte[] output = new byte[bytes.size()];
        hash.cnFastHash(CollectionsKt.toByteArray((Collection)bytes), bytes.size(), output);
        List checksum = ArraysKt.take((byte[])output, (int)4);
        bytes.addAll(CollectionsKt.toList((Iterable)checksum));
        StringBuilder base58 = new StringBuilder();
        byte[] byteArray = CollectionsKt.toByteArray((Collection)bytes);
        for (int currentIndex = 0; currentIndex < byteArray.length; currentIndex += chunkSize) {
            chunkSize = currentIndex + 8 <= byteArray.length ? 8 : byteArray.length - currentIndex;
            byte[] byArray3 = byteArray;
            int n = currentIndex + chunkSize;
            byte[] chunk = ArraysKt.copyOfRange((byte[])byArray3, (int)currentIndex, (int)n);
            String encodedChunk = Base58.INSTANCE.encode(chunk);
            int expectedLength = switch (chunkSize) {
                case 8 -> 11;
                case 6 -> 9;
                case 5 -> 7;
                default -> throw new IllegalStateException(("Invalid chunk length: " + chunkSize).toString());
            };
            int missing = expectedLength - encodedChunk.length();
            if (missing > 0) {
                base58.append(StringsKt.repeat((CharSequence)"1", (int)missing));
            }
            base58.append(encodedChunk);
        }
        String string2 = base58.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"base58.toString()");
        return string2;
    }
}

