/*
 * Decompiled with CFR 0.152.
 */
package org.kryptokrona.sdk.crypto;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kryptokrona.sdk.crypto.KeyKt;
import org.kryptokrona.sdk.crypto.WalletFileEncryption;
import org.kryptokrona.sdk.crypto.model.Wallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kryptokrona/sdk/crypto/WalletFileEncryption;", "", "wallet", "Lorg/kryptokrona/sdk/crypto/model/Wallet;", "(Lorg/kryptokrona/sdk/crypto/model/Wallet;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "decryptWallet", "", "encryptedBytes", "password", "", "salt", "iv", "encryptToFile", "", "fileName", "loadEncryptedBytesFromFile", "loadWallet", "serialize", "kryptokrona-crypto"})
@SourceDebugExtension(value={"SMAP\nWalletFileEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WalletFileEncryption.kt\norg/kryptokrona/sdk/crypto/WalletFileEncryption\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,204:1\n96#2:205\n113#3:206\n*S KotlinDebug\n*F\n+ 1 WalletFileEncryption.kt\norg/kryptokrona/sdk/crypto/WalletFileEncryption\n*L\n142#1:205\n201#1:206\n*E\n"})
public final class WalletFileEncryption {
    @Nullable
    private final Wallet wallet;
    private final Logger logger;

    public WalletFileEncryption(@Nullable Wallet wallet) {
        this.wallet = wallet;
        this.logger = LoggerFactory.getLogger((String)"WalletEncryption");
    }

    public /* synthetic */ WalletFileEncryption(Wallet wallet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            wallet = null;
        }
        this(wallet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encryptToFile(@NotNull String fileName, @NotNull String password) {
        block8: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            char[] cArray = password.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            char[] passwordBytes = cArray;
            byte[] salt = new byte[16];
            new SecureRandom().nextBytes(salt);
            SecretKeySpec keySpec = new SecretKeySpec(KeyKt.generatePBKDF2DerivedKey(passwordBytes, salt, 32, 10000), "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            byte[] iv = new byte[cipher.getBlockSize()];
            new SecureRandom().nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)keySpec, ivParams);
            Wallet wallet = this.wallet;
            if (wallet != null) {
                Wallet walletFile = wallet;
                boolean bl = false;
                byte[] walletBytes = this.serialize(walletFile);
                byte[] encryptedWallet = cipher.doFinal(walletBytes);
                byte[] encryptedBytes = new byte[salt.length + iv.length + encryptedWallet.length];
                System.arraycopy(salt, 0, encryptedBytes, 0, salt.length);
                System.arraycopy(iv, 0, encryptedBytes, salt.length, iv.length);
                System.arraycopy(encryptedWallet, 0, encryptedBytes, salt.length + iv.length, encryptedWallet.length);
                String homeDir = System.getProperty("user.home");
                File file = new File(homeDir, fileName);
                Closeable closeable = new FileOutputStream(file);
                Throwable throwable = null;
                try {
                    FileOutputStream outputStream = (FileOutputStream)closeable;
                    boolean bl2 = false;
                    outputStream.write(encryptedBytes);
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block8;
            this.logger.error("Cannot encrypt to file when wallet file object is null!");
        }
    }

    @NotNull
    public final Wallet loadWallet(@NotNull String fileName, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.logger.debug("Loading wallet from file...");
        byte[] encryptedBytes = this.loadEncryptedBytesFromFile(fileName);
        if (!(encryptedBytes.length >= 16)) {
            boolean $i$a$-require-WalletFileEncryption$loadWallet$22 = false;
            String $i$a$-require-WalletFileEncryption$loadWallet$22 = "Encrypted file is too small to contain an IV and ciphertext";
            throw new IllegalArgumentException($i$a$-require-WalletFileEncryption$loadWallet$22.toString());
        }
        byte[] salt = ArraysKt.sliceArray((byte[])encryptedBytes, (IntRange)RangesKt.until((int)0, (int)16));
        byte[] iv = ArraysKt.sliceArray((byte[])encryptedBytes, (IntRange)RangesKt.until((int)16, (int)32));
        byte[] ciphertext = ArraysKt.sliceArray((byte[])encryptedBytes, (IntRange)RangesKt.until((int)32, (int)encryptedBytes.length));
        byte[] decryptedBytes = this.decryptWallet(ciphertext, password, salt, iv);
        String decryptedString = StringsKt.decodeToString((byte[])decryptedBytes);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (Wallet)this_$iv.decodeFromString((DeserializationStrategy)Wallet.Companion.serializer(), decryptedString);
    }

    private final byte[] loadEncryptedBytesFromFile(String fileName) {
        this.logger.debug("Loading encrypted bytes from file...");
        String homeDir = System.getProperty("user.home");
        File file = new File(homeDir, fileName);
        return FilesKt.readBytes((File)file);
    }

    private final byte[] decryptWallet(byte[] encryptedBytes, String password, byte[] salt, byte[] iv) {
        this.logger.debug("Decrypting wallet...");
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] passwordBytes = cArray;
        SecretKeySpec keySpec = new SecretKeySpec(KeyKt.generatePBKDF2DerivedKey(passwordBytes, salt, 32, 10000), "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec ivParams = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, ivParams);
        byte[] byArray = cipher.doFinal(encryptedBytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(encryptedBytes)");
        return byArray;
    }

    private final byte[] serialize(Wallet wallet) {
        Json json2 = JsonKt.Json$default(null, (Function1)serialize.json.1.INSTANCE, (int)1, null);
        StringFormat $this$encodeToString$iv = (StringFormat)json2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)Wallet.Companion.serializer(), (Object)wallet);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    public WalletFileEncryption() {
        this(null, 1, null);
    }
}

