/*
 * Decompiled with CFR 0.152.
 */
package org.kryptokrona.sdk.crypto.loader;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/kryptokrona/sdk/crypto/loader/Ed25519LibraryLoader;", "", "()V", "getLibraryPath", "", "isRunningInsideUnitTest", "", "kryptokrona-crypto"})
@SourceDebugExtension(value={"SMAP\nEd25519LibraryLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ed25519LibraryLoader.kt\norg/kryptokrona/sdk/crypto/loader/Ed25519LibraryLoader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,98:1\n12744#2,2:99\n*S KotlinDebug\n*F\n+ 1 Ed25519LibraryLoader.kt\norg/kryptokrona/sdk/crypto/loader/Ed25519LibraryLoader\n*L\n95#1:99,2\n*E\n"})
public class Ed25519LibraryLoader {
    public Ed25519LibraryLoader() {
        System.load(this.getLibraryPath());
    }

    private final String getLibraryPath() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String osName = string3;
        String libraryName = StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null) ? "ed25519.dll" : (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) ? "libed25519.dylib" : "libed25519.so");
        String libraryFolder = this.isRunningInsideUnitTest() ? "../kryptokrona-crypto/build/libs" : "kryptokrona-crypto/build/libs";
        String userDir = System.getProperty("user.dir");
        File libraryPath = new File(userDir, libraryFolder + "/" + libraryName);
        if (!libraryPath.exists()) {
            throw new FileNotFoundException("Failed to find the ed25519 shared library: " + libraryName);
        }
        String string4 = libraryPath.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"libraryPath.absolutePath");
        return string4;
    }

    private final boolean isRunningInsideUnitTest() {
        boolean bl;
        block1: {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTrace, (String)"stackTrace");
            StackTraceElement[] $this$any$iv = stackTrace;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                StackTraceElement element$iv;
                StackTraceElement it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                if (!StringsKt.startsWith$default((String)string, (String)"org.junit.", (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

