// Copyright (c) 2022-2023, The Kryptokrona Developers
//
// Written by Marcus Cvjeticanin
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright notice, this list
//    of conditions and the following disclaimer in the documentation and/or other
//    materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its contributors may be
//    used to endorse or promote products derived from this software without specific
//    prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
// THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package org.kryptokrona.sdk.util.config

/**
 * Constants holds all the constants used in the SDK.
 *
 * @author Marcus Cvjeticanin
 * @since 0.1.0
 */
object Constants {

    /**
     * What version of the file format are we on (to make it easier to
     * upgrade the wallet format in the future)
     */
    const val WALLET_FILE_FORMAT_VERSION = 0

    /**
     * The number of iterations of PBKDF2 to perform on the wallet
     * password.
     */
    const val PBKDF2_ITERATIONS = 500000

    /**
     * We use this to check that the file is a wallet file, this bit does
     * not get encrypted, and we can check if it exists before decrypting.
     * If it isn't, it's not a wallet file.
     */
    /*val IS_A_WALLET_IDENTIFIER: List<Int> = ArrayList<Any?>(
        java.util.List.of(
            0x49, 0x66, 0x20, 0x49, 0x20, 0x70, 0x75, 0x6c, 0x6c, 0x20, 0x74,
            0x68, 0x61, 0x74, 0x20, 0x6f, 0x66, 0x66, 0x2c, 0x20, 0x77, 0x69,
            0x6c, 0x6c, 0x20, 0x79, 0x6f, 0x75, 0x20, 0x64, 0x69, 0x65, 0x3f,
            0x0a, 0x49, 0x74, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62,
            0x65, 0x20, 0x65, 0x78, 0x74, 0x72, 0x65, 0x6d, 0x65, 0x6c, 0x79,
            0x20, 0x70, 0x61, 0x69, 0x6e, 0x66, 0x75, 0x6c, 0x2e
        )
    )*/

    /**
     * We use this to check if the file has been correctly decoded, i.e.
     * is the password correct. This gets encrypted into the file, and
     * then when unencrypted the file should start with this - if it
     * doesn't, the password is wrong
     */
   /* val IS_CORRECT_PASSWORD_IDENTIFIER: ArrayList<Any?> = listOf(
            0x59, 0x6f, 0x75, 0x27, 0x72, 0x65, 0x20, 0x61, 0x20, 0x62, 0x69,
            0x67, 0x20, 0x67, 0x75, 0x79, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x20,
            0x79, 0x6f, 0x75, 0x2e
    )*/

    /**
     * How large should the lastKnownBlockHashes container be
     */
    const val LAST_KNOWN_BLOCK_HASHES_SIZE = 50

    /**
     * Save a block hash checkpoint every BLOCK_HASH_CHECKPOINTS_INTERVAL
     * blocks
     */
    const val BLOCK_HASH_CHECKPOINTS_INTERVAL = 5000

    /**
     * When we get the global indexes, we pass in a range of blocks, to obscure
     * which transactions we are interested in - the ones that belong to us.
     * To do this, we get the global indexes for all transactions in a range.
     * For example, if we want the global indexes for a transaction in block
     * 17, we get all the indexes from block 10 to block 20.
     *
     *
     * This value determines how many blocks to take from.
     */
    const val GLOBAL_INDEXES_OBSCURITY = 10

    /**
     * Used to determine whether an unlock time is a height, or a timestamp
     */
    const val MAX_BLOCK_NUMBER: Long = 500000000

    /**
     * Valid output amounts to be mixable
     */
    /*public final static List<Long> PRETTY_AMOUNTS = new ArrayList<>(asList(
		1, 2, 3, 4, 5, 6, 7, 8, 9,
		10, 20, 30, 40, 50, 60, 70, 80, 90,
		100, 200, 300, 400, 500, 600, 700, 800, 900,
		1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000,
		10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000,
		100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000,
		1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000,
		10000000, 20000000, 30000000, 40000000, 50000000, 60000000, 70000000,
		80000000, 90000000,
		100000000, 200000000, 300000000, 400000000, 500000000, 600000000, 700000000,
		800000000, 900000000,
		1000000000, 2000000000, 3000000000L, 4000000000L, 5000000000L, 6000000000L,
		7000000000L, 8000000000L, 9000000000L,
		10000000000L, 20000000000L, 30000000000L, 40000000000L, 50000000000L, 60000000000L,
		70000000000L, 80000000000L, 90000000000L,
		100000000000L, 200000000000L, 300000000000L, 400000000000L, 500000000000L,
		600000000000L, 700000000000L, 800000000000L, 900000000000L,
		1000000000000L, 2000000000000L, 3000000000000L, 4000000000000L, 5000000000000L,
		6000000000000L, 7000000000000L, 8000000000000L, 9000000000000L,
		10000000000000L, 20000000000000L, 30000000000000L, 40000000000000L, 50000000000000L,
		60000000000000L, 70000000000000L, 80000000000000L, 90000000000000L,
		100000000000000L, 200000000000000L, 300000000000000L, 400000000000000L,
		500000000000000L, 600000000000000L, 700000000000000L, 800000000000000L,
		900000000000000L,
		1000000000000000L, 2000000000000000L, 3000000000000000L, 4000000000000000L,
		5000000000000000L, 6000000000000000L, 7000000000000000L, 8000000000000000L,
		9000000000000000L,
		10000000000000000L, 20000000000000000L, 30000000000000000L, 40000000000000000L,
		50000000000000000L, 60000000000000000L, 70000000000000000L, 80000000000000000L,
		90000000000000000L,
		100000000000000000L, 200000000000000000L, 300000000000000000L, 400000000000000000L,
		500000000000000000L, 600000000000000000L, 700000000000000000L, 800000000000000000L,
		900000000000000000L,
		1000000000000000000L, 2000000000000000000L, 3000000000000000000L, 4000000000000000000L,
		5000000000000000000L, 6000000000000000000L, 7000000000000000000L, 8000000000000000000L,
		9000000000000000000L
	));*/

    /**
     * Valid output amounts to be mixable
     */
    /*public final static List<Long> PRETTY_AMOUNTS = new ArrayList<>(asList(
		1, 2, 3, 4, 5, 6, 7, 8, 9,
		10, 20, 30, 40, 50, 60, 70, 80, 90,
		100, 200, 300, 400, 500, 600, 700, 800, 900,
		1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000,
		10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000,
		100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000,
		1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000,
		10000000, 20000000, 30000000, 40000000, 50000000, 60000000, 70000000,
		80000000, 90000000,
		100000000, 200000000, 300000000, 400000000, 500000000, 600000000, 700000000,
		800000000, 900000000,
		1000000000, 2000000000, 3000000000L, 4000000000L, 5000000000L, 6000000000L,
		7000000000L, 8000000000L, 9000000000L,
		10000000000L, 20000000000L, 30000000000L, 40000000000L, 50000000000L, 60000000000L,
		70000000000L, 80000000000L, 90000000000L,
		100000000000L, 200000000000L, 300000000000L, 400000000000L, 500000000000L,
		600000000000L, 700000000000L, 800000000000L, 900000000000L,
		1000000000000L, 2000000000000L, 3000000000000L, 4000000000000L, 5000000000000L,
		6000000000000L, 7000000000000L, 8000000000000L, 9000000000000L,
		10000000000000L, 20000000000000L, 30000000000000L, 40000000000000L, 50000000000000L,
		60000000000000L, 70000000000000L, 80000000000000L, 90000000000000L,
		100000000000000L, 200000000000000L, 300000000000000L, 400000000000000L,
		500000000000000L, 600000000000000L, 700000000000000L, 800000000000000L,
		900000000000000L,
		1000000000000000L, 2000000000000000L, 3000000000000000L, 4000000000000000L,
		5000000000000000L, 6000000000000000L, 7000000000000000L, 8000000000000000L,
		9000000000000000L,
		10000000000000000L, 20000000000000000L, 30000000000000000L, 40000000000000000L,
		50000000000000000L, 60000000000000000L, 70000000000000000L, 80000000000000000L,
		90000000000000000L,
		100000000000000000L, 200000000000000000L, 300000000000000000L, 400000000000000000L,
		500000000000000000L, 600000000000000000L, 700000000000000000L, 800000000000000000L,
		900000000000000000L,
		1000000000000000000L, 2000000000000000000L, 3000000000000000000L, 4000000000000000000L,
		5000000000000000000L, 6000000000000000000L, 7000000000000000000L, 8000000000000000000L,
		9000000000000000000L
	));*/
    /**
     * Part of the how fast blocks can grow formula
     */
    const val MAX_BLOCK_SIZE_GROWTH_SPEED_NUMERATOR = 100 * 1024

    /**
     * Part of the how fast blocks can grow
     */
    const val MAX_BLOCK_SIZE_GROWTH_SPEED_DENOMINATOR = 365 * 24 * 60 * 60

    /**
     * Initial block size
     */
    const val MAX_BLOCK_SIZE_INITIAL = 100000

    /**
     * Reserved space for miner transaction in block
     */
    const val CRYPTONOTE_COINBASE_BLOB_RESERVED_SIZE = 600

    /**
     * Minimum number of inputs a fusion transaction must have
     */
    const val FUSION_TX_MIN_INPUT_COUNT = 12

    /**
     * Max size in bytes a fusion transaction can be
     */
    const val MAX_FUSION_TX_SIZE = 30000

    /**
     * Required ratio of inputs to outputs in fusion transactions
     */
    const val FUSION_TX_MIN_IN_OUT_COUNT_RATIO = 4

    /**
     * Max amount to create a single output of
     */
    const val MAX_OUTPUT_SIZE_CLIENT = 100000000000L
}
