/*
 * Decompiled with CFR 0.152.
 */
package org.kryptokrona.sdk.wallet.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kryptokrona.sdk.crypto.Crypto;
import org.kryptokrona.sdk.crypto.KeyKt;
import org.kryptokrona.sdk.crypto.WalletFileEncryption;
import org.kryptokrona.sdk.crypto.exception.GenerateKeyDerivationException;
import org.kryptokrona.sdk.crypto.model.KeyImage;
import org.kryptokrona.sdk.crypto.model.TransactionInput;
import org.kryptokrona.sdk.crypto.model.Wallet;
import org.kryptokrona.sdk.crypto.model.WalletKeyPairs;
import org.kryptokrona.sdk.crypto.util.HexUtilKt;
import org.kryptokrona.sdk.node.client.BlockClient;
import org.kryptokrona.sdk.node.client.WalletClient;
import org.kryptokrona.sdk.node.model.request.block.BlockDetailsByHeightRequest;
import org.kryptokrona.sdk.node.model.request.wallet.WalletSyncDataRequest;
import org.kryptokrona.sdk.node.model.response.blockdetail.BlockDetailResponse;
import org.kryptokrona.sdk.node.model.response.node.InfoResponse;
import org.kryptokrona.sdk.node.model.response.walletsyncdata.Block;
import org.kryptokrona.sdk.node.model.response.walletsyncdata.Transaction;
import org.kryptokrona.sdk.node.model.response.walletsyncdata.TransactionOutput;
import org.kryptokrona.sdk.node.model.response.walletsyncdata.WalletSyncData;
import org.kryptokrona.sdk.node.service.NodeService;
import org.kryptokrona.sdk.util.model.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0006\u0010&\u001a\u00020\rJ\b\u0010'\u001a\u0004\u0018\u00010\u0013J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190\bJ\u001b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\b\u0010.\u001a\u0004\u0018\u00010\u001dJ\u0016\u0010/\u001a\u00020\"2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\tJ\b\u00102\u001a\u00020\rH\u0002J\u0016\u00103\u001a\u00020\"2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\tJ\u000e\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u0017J\u0011\u00106\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020\"R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"Lorg/kryptokrona/sdk/wallet/service/WalletService;", "", "node", "Lorg/kryptokrona/sdk/util/model/node/Node;", "(Lorg/kryptokrona/sdk/util/model/node/Node;)V", "blockClient", "Lorg/kryptokrona/sdk/node/client/BlockClient;", "checkpoints", "", "", "crypto", "Lorg/kryptokrona/sdk/crypto/Crypto;", "isSyncCanceled", "", "isWalletLoaded", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "nodeInfo", "Lorg/kryptokrona/sdk/node/model/response/node/InfoResponse;", "nodeService", "Lorg/kryptokrona/sdk/node/service/NodeService;", "startHeight", "", "storedBlocks", "Lorg/kryptokrona/sdk/node/model/response/walletsyncdata/Block;", "syncJob", "Lkotlinx/coroutines/Job;", "wallet", "Lorg/kryptokrona/sdk/crypto/model/Wallet;", "walletClient", "Lorg/kryptokrona/sdk/node/client/WalletClient;", "walletHeight", "checkTransactionOutputs", "", "transaction", "Lorg/kryptokrona/sdk/node/model/response/walletsyncdata/Transaction;", "blockHeight", "getIsWalletLoaded", "getNodeInfo", "getStoredBlocks", "getSyncData", "Lorg/kryptokrona/sdk/node/model/response/walletsyncdata/WalletSyncData;", "walletSyncDataRequest", "Lorg/kryptokrona/sdk/node/model/request/wallet/WalletSyncDataRequest;", "(Lorg/kryptokrona/sdk/node/model/request/wallet/WalletSyncDataRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getWallet", "loadWalletFromFile", "fileName", "password", "processBlocks", "saveWalletToFile", "setStartHeight", "height", "startSync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopSync", "kryptokrona-wallet"})
@SourceDebugExtension(value={"SMAP\nWalletService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WalletService.kt\norg/kryptokrona/sdk/wallet/service/WalletService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,403:1\n1#2:404\n1864#3,3:405\n*S KotlinDebug\n*F\n+ 1 WalletService.kt\norg/kryptokrona/sdk/wallet/service/WalletService\n*L\n310#1:405,3\n*E\n"})
public final class WalletService {
    private final Logger logger;
    @NotNull
    private final Crypto crypto;
    @NotNull
    private final WalletClient walletClient;
    @NotNull
    private final BlockClient blockClient;
    @NotNull
    private final NodeService nodeService;
    @NotNull
    private Job syncJob;
    @Nullable
    private InfoResponse nodeInfo;
    private long startHeight;
    private long walletHeight;
    @NotNull
    private List<String> checkpoints;
    @NotNull
    private List<Block> storedBlocks;
    @Nullable
    private Wallet wallet;
    private boolean isWalletLoaded;
    private boolean isSyncCanceled;

    public WalletService(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.logger = LoggerFactory.getLogger((String)"WalletService");
        this.crypto = new Crypto();
        this.walletClient = new WalletClient(node);
        this.blockClient = new BlockClient(node);
        this.nodeService = new NodeService(node);
        this.syncJob = (Job)JobKt.Job$default(null, (int)1, null);
        this.checkpoints = new ArrayList();
        this.storedBlocks = new ArrayList();
    }

    @Nullable
    public final InfoResponse getNodeInfo() {
        return this.nodeInfo;
    }

    @NotNull
    public final List<Block> getStoredBlocks() {
        return this.storedBlocks;
    }

    @Nullable
    public final Wallet getWallet() {
        return this.wallet;
    }

    public final boolean getIsWalletLoaded() {
        return this.isWalletLoaded;
    }

    public final void setStartHeight(long height) {
        this.startHeight = height;
    }

    @Nullable
    public final Object startSync(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WalletService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        WalletService.access$getLogger$p(this.this$0).info("Starting sync process...");
                        WalletService.access$setWalletHeight$p(this.this$0, WalletService.access$getStartHeight$p(this.this$0));
                        this.L$0 = $this$coroutineScope;
                        this.label = 1;
                        v0 = WalletService.access$getBlockClient$p(this.this$0).getBlockDetailsByHeight(new BlockDetailsByHeightRequest(WalletService.access$getStartHeight$p(this.this$0)), (Continuation)this);
                        if (v0 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        if ((v1 /* !! */  = (blockDetails = (BlockDetailResponse)v0)) != null && (v1 /* !! */  = v1 /* !! */ .getBlock()) != null && (v1 /* !! */  = v1 /* !! */ .getHash()) != null) {
                            var6_5 /* !! */  = v1 /* !! */ ;
                            var7_6 /* !! */  = this.this$0;
                            it = var6_5 /* !! */ ;
                            $i$a$-let-WalletService$startSync$2$1 = false;
                            ((Collection)WalletService.access$getCheckpoints$p((WalletService)var7_6 /* !! */ )).add(it);
                        }
                        lastCheckPoint = new Ref.ObjectRef();
                        lastCheckPoint.element = CollectionsKt.listOf((Object)CollectionsKt.last((List)WalletService.access$getCheckpoints$p(this.this$0)));
                        requestData = new WalletSyncDataRequest((List)lastCheckPoint.element, 0L, 0L, 0L, false, 30, null);
                        this.L$0 = $this$coroutineScope;
                        this.L$1 = lastCheckPoint;
                        this.label = 2;
                        v2 = WalletService.access$getSyncData(this.this$0, requestData, (Continuation)this);
                        if (v2 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl42
                    }
                    case 2: {
                        lastCheckPoint = (Ref.ObjectRef)this.L$1;
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl42:
                        // 2 sources

                        var7_6 /* !! */  = walletSyncData = (WalletSyncData)v2;
                        it = this.this$0;
                        wsd = var7_6 /* !! */ ;
                        $i$a$-let-WalletService$startSync$2$2 = false;
                        if (wsd != null) {
                            ((Collection)WalletService.access$getCheckpoints$p(it)).add(((Block)CollectionsKt.last((List)wsd.getItems())).getBlockHash());
                            WalletService.access$setWalletHeight$p(it, WalletService.access$getWalletHeight$p(it) + (long)wsd.getItems().size());
                        }
                        WalletService.access$setSyncJob$p(this.this$0, BuildersKt.launch$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (Ref.ObjectRef<List<String>>)lastCheckPoint, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ WalletService this$0;
                            final /* synthetic */ Ref.ObjectRef<List<String>> $lastCheckPoint;
                            {
                                this.this$0 = $receiver;
                                this.$lastCheckPoint = $lastCheckPoint;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$lastCheckPoint, null){
                                            Object L$1;
                                            int label;
                                            private /* synthetic */ Object L$0;
                                            final /* synthetic */ WalletService this$0;
                                            final /* synthetic */ Ref.ObjectRef<List<String>> $lastCheckPoint;
                                            {
                                                this.this$0 = $receiver;
                                                this.$lastCheckPoint = $lastCheckPoint;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                                block11: {
                                                    var20_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    block0 : switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)var1_1);
                                                            $this$launch = (CoroutineScope)this.L$0;
lbl6:
                                                            // 3 sources

                                                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                                                WalletService.access$getLogger$p(this.this$0).debug("Syncing blocks...");
                                                                v0 = WalletService.access$getNodeInfo$p(this.this$0);
                                                                if (v0 == null) break block0;
                                                                var3_4 = v0.getHeight();
                                                                var5_5 = this.this$0;
                                                                var6_6 = this.$lastCheckPoint;
                                                                it = var3_4;
                                                                $i$a$-let-WalletService$startSync$2$3$1$1 = false;
                                                                if (WalletService.access$getWalletHeight$p(var5_5) >= it) break block11;
                                                                var6_6.element = CollectionsKt.listOf((Object)CollectionsKt.last((List)WalletService.access$getCheckpoints$p(var5_5)));
                                                                data = new WalletSyncDataRequest((List)var6_6.element, 0L, 0L, 0L, false, 30, null);
                                                                this.L$0 = $this$launch;
                                                                this.L$1 = var5_5;
                                                                this.label = 1;
                                                                v1 = WalletService.access$getSyncData(var5_5, data, (Continuation)this);
                                                                if (v1 == var20_2) {
                                                                    return var20_2;
                                                                }
                                                                ** GOTO lbl32
                                                            }
                                                            break;
                                                        }
                                                        case 1: {
                                                            $i$a$-let-WalletService$startSync$2$3$1$1 = false;
                                                            var5_5 = (WalletService)this.L$1;
                                                            $this$launch = (CoroutineScope)this.L$0;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            v1 = $result;
lbl32:
                                                            // 2 sources

                                                            if ((syncData = (WalletSyncData)v1) != null) {
                                                                $i$a$-let-WalletService$startSync$2$3$1$1$1 = false;
                                                                if (((Collection)sd.getItems()).isEmpty() == false) {
                                                                    ((Collection)WalletService.access$getCheckpoints$p(var5_5)).add(((Block)CollectionsKt.last((List)sd.getItems())).getBlockHash());
                                                                    WalletService.access$setCheckpoints$p(var5_5, CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)WalletService.access$getCheckpoints$p(var5_5))));
                                                                    WalletService.access$setWalletHeight$p(var5_5, WalletService.access$getWalletHeight$p(var5_5) + (long)sd.getItems().size());
                                                                    $this$forEach$iv = sd.getItems();
                                                                    $i$f$forEach = false;
                                                                    for (T element$iv : $this$forEach$iv) {
                                                                        block = (Block)element$iv;
                                                                        $i$a$-forEach-WalletService$startSync$2$3$1$1$1$1 = false;
                                                                        WalletService.access$getStoredBlocks$p(var5_5).add(block);
                                                                    }
                                                                    WalletService.access$getLogger$p(var5_5).info("Fetched " + sd.getItems().size() + " block(s)");
                                                                }
                                                            }
                                                            if (WalletService.access$processBlocks(var5_5)) {
                                                                WalletService.access$getLogger$p(var5_5).info("Sync process canceled...");
                                                                return Unit.INSTANCE;
                                                            }
                                                            WalletService.access$getLogger$p(var5_5).info("Wallet height: " + WalletService.access$getWalletHeight$p(var5_5));
                                                            break;
                                                        }
                                                    }
                                                }
                                                this.L$0 = $this$launch;
                                                this.L$1 = null;
                                                this.label = 2;
                                                v2 = DelayKt.delay((long)500L, (Continuation)((Continuation)this));
                                                if (v2 != var20_2) ** GOTO lbl6
                                                return var20_2;
                                                {
                                                    case 2: {
                                                        $this$launch = (CoroutineScope)this.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v2 = $result;
                                                        ** GOTO lbl6
                                                    }
                                                }
                                                return Unit.INSTANCE;
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value;
                                                return (Continuation)var3_3;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)2, null);
                                        BuildersKt.launch$default((CoroutineScope)$this$launch, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            Object L$1;
                                            int label;
                                            private /* synthetic */ Object L$0;
                                            final /* synthetic */ WalletService this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)var1_1);
                                                        $this$launch = (CoroutineScope)this.L$0;
lbl6:
                                                        // 3 sources

                                                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                                            var3_4 = this.this$0;
                                                            this.L$0 = $this$launch;
                                                            this.L$1 = var3_4;
                                                            this.label = 1;
                                                            v0 = WalletService.access$getNodeService$p(this.this$0).getNodeInfo((Continuation)this);
                                                            if (v0 == var4_2) {
                                                                return var4_2;
                                                            }
                                                            ** GOTO lbl21
                                                        }
                                                        break;
                                                    }
                                                    case 1: {
                                                        var3_4 = (WalletService)this.L$1;
                                                        $this$launch = (CoroutineScope)this.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v0 = $result;
lbl21:
                                                        // 2 sources

                                                        WalletService.access$setNodeInfo$p(var3_4, (InfoResponse)v0);
                                                        v1 = WalletService.access$getNodeInfo$p(this.this$0);
                                                        WalletService.access$getLogger$p(this.this$0).info("Node height: " + (v1 != null ? Boxing.boxLong((long)v1.getHeight()) : null));
                                                        this.L$0 = $this$launch;
                                                        this.L$1 = null;
                                                        this.label = 2;
                                                        v2 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                                                        if (v2 != var4_2) ** GOTO lbl6
                                                        return var4_2;
                                                    }
                                                    case 2: {
                                                        $this$launch = (CoroutineScope)this.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v2 = $result;
                                                        ** GOTO lbl6
                                                    }
                                                }
                                                return Unit.INSTANCE;
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                var3_3.L$0 = value;
                                                return (Continuation)var3_3;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)2, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null));
                        $this$forEach$iv = WalletService.access$getSyncJob$p(this.this$0).getChildren();
                        $i$f$forEach = false;
                        var9_10 = $this$forEach$iv.iterator();
lbl56:
                        // 3 sources

                        while (var9_10.hasNext()) {
                            element$iv = var9_10.next();
                            it = (Job)element$iv;
                            $i$a$-forEach-WalletService$startSync$2$4 = false;
                            this.L$0 = var9_10;
                            this.L$1 = null;
                            this.label = 3;
                            v3 = it.join((Continuation)this);
                            if (v3 != var13_2) continue;
                            return var13_2;
                        }
                        break;
                    }
                    case 3: {
                        $i$f$forEach = false;
                        $i$a$-forEach-WalletService$startSync$2$4 = false;
                        var9_10 = (Iterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl56
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void stopSync() {
        this.isSyncCanceled = true;
        JobKt.cancelChildren$default((Job)this.syncJob, null, (int)1, null);
        Job.DefaultImpls.cancel$default((Job)this.syncJob, null, (int)1, null);
        this.logger.info("Stopping sync process...");
    }

    private final Object getSyncData(WalletSyncDataRequest walletSyncDataRequest, Continuation<? super WalletSyncData> $completion) {
        this.logger.debug("Getting wallet sync data...");
        return this.walletClient.getWalletSyncData(walletSyncDataRequest, $completion);
    }

    private final boolean processBlocks() {
        this.logger.info("Processing blocks...");
        List blocksToRemove = new ArrayList();
        for (Block block : this.storedBlocks) {
            if (this.isSyncCanceled) break;
            for (Transaction transaction : block.getTransactions()) {
                if (this.isSyncCanceled) {
                    this.isSyncCanceled = true;
                    break;
                }
                this.checkTransactionOutputs(transaction, block.getBlockHeight());
            }
            if (this.isSyncCanceled) continue;
            this.walletHeight = block.getBlockHeight();
            blocksToRemove.add(block);
        }
        if (this.isSyncCanceled) {
            return true;
        }
        this.storedBlocks.removeAll(blocksToRemove);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTransactionOutputs(Transaction transaction, long blockHeight) {
        boolean bl;
        boolean bl2 = bl = this.wallet != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Wallet wallet = this.wallet;
        String publicSpendKey = wallet != null ? wallet.getPublicSpendKey() : null;
        Wallet wallet2 = this.wallet;
        String privateViewKey = wallet2 != null ? wallet2.getPrivateViewKey() : null;
        String string = publicSpendKey;
        Intrinsics.checkNotNull((Object)string);
        byte[] pubSpend = HexUtilKt.convertHexToBytes((String)string);
        String string2 = privateViewKey;
        Intrinsics.checkNotNull((Object)string2);
        byte[] privView = HexUtilKt.convertHexToBytes((String)string2);
        byte[] txPubKey = HexUtilKt.convertHexToBytes((String)transaction.getTxPublicKey());
        List inputs = new ArrayList();
        byte[] derivation = new byte[32];
        int success = this.crypto.generateKeyDerivation(txPubKey, privView, derivation);
        Integer n = success;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it != 0 ? n : null;
        if (n2 == null) {
            throw new GenerateKeyDerivationException("Keys are invalid.");
        }
        n2.intValue();
        Iterable $this$forEachIndexed$iv = transaction.getOutputs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void output;
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TransactionOutput transactionOutput = (TransactionOutput)item$iv;
            int index = n3;
            boolean bl4 = false;
            String key = output.getKey();
            byte[] derivedKey = HexUtilKt.convertHexToBytes((String)key);
            byte[] base = new byte[32];
            this.crypto.underivePublicKey(derivation, (long)index, derivedKey, base);
            if (!Arrays.equals(pubSpend, derivedKey)) continue;
            KeyImage keyImage = KeyKt.getKeyImageFromOutput((byte[])derivation, (long)index, (byte[])pubSpend);
            TransactionInput txInput = new TransactionInput(output.getAmount(), blockHeight, keyImage, transaction.getTxPublicKey(), key, keyImage.getPrivateSpendKey(), transaction.getHash(), (long)index, 0L, transaction.getUnlockTime(), 0L);
            this.logger.info("Transaction found with hash: " + txInput.getTxHash());
            inputs.add(txInput);
        }
        Wallet wallet3 = this.wallet;
        if (wallet3 != null) {
            Object object = this.wallet;
            if (object == null || (object = object.getUnspentInputs()) == null || (object = CollectionsKt.plus((Collection)((Collection)object), (Iterable)inputs)) == null) {
                object = inputs;
            }
            wallet3.setUnspentInputs((List)object);
        }
    }

    public final void saveWalletToFile(@NotNull String fileName, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.logger.debug("Saving wallet to file...");
        WalletKeyPairs walletKeyPairs = KeyKt.generateKeyPairs();
        String address = KeyKt.generateAddress((String)walletKeyPairs.getPublicSpendKey(), (String)walletKeyPairs.getPublicViewKey());
        String string = walletKeyPairs.getPublicSpendKey();
        String string2 = walletKeyPairs.getPrivateSpendKey();
        String string3 = walletKeyPairs.getPublicViewKey();
        String string4 = walletKeyPairs.getPrivateViewKey();
        long l = this.startHeight;
        Wallet wallet = this.wallet = new Wallet(null, null, null, null, string, string2, string3, string4, 0L, l, address, true, 271, null);
        Intrinsics.checkNotNull((Object)wallet);
        WalletFileEncryption walletFileEncryption = new WalletFileEncryption(wallet);
        walletFileEncryption.encryptToFile(fileName, password);
    }

    public final void loadWalletFromFile(@NotNull String fileName, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.logger.debug("Loading wallet from file...");
        WalletFileEncryption walletFileEncryption = new WalletFileEncryption(null, 1, null);
        this.wallet = walletFileEncryption.loadWallet(fileName, password);
        this.isWalletLoaded = true;
    }

    public static final /* synthetic */ Logger access$getLogger$p(WalletService $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setWalletHeight$p(WalletService $this, long l) {
        $this.walletHeight = l;
    }

    public static final /* synthetic */ long access$getStartHeight$p(WalletService $this) {
        return $this.startHeight;
    }

    public static final /* synthetic */ BlockClient access$getBlockClient$p(WalletService $this) {
        return $this.blockClient;
    }

    public static final /* synthetic */ List access$getCheckpoints$p(WalletService $this) {
        return $this.checkpoints;
    }

    public static final /* synthetic */ Object access$getSyncData(WalletService $this, WalletSyncDataRequest walletSyncDataRequest, Continuation $completion) {
        return $this.getSyncData(walletSyncDataRequest, (Continuation<? super WalletSyncData>)$completion);
    }

    public static final /* synthetic */ void access$setSyncJob$p(WalletService $this, Job job) {
        $this.syncJob = job;
    }

    public static final /* synthetic */ InfoResponse access$getNodeInfo$p(WalletService $this) {
        return $this.nodeInfo;
    }

    public static final /* synthetic */ List access$getStoredBlocks$p(WalletService $this) {
        return $this.storedBlocks;
    }

    public static final /* synthetic */ void access$setCheckpoints$p(WalletService $this, List list) {
        $this.checkpoints = list;
    }

    public static final /* synthetic */ long access$getWalletHeight$p(WalletService $this) {
        return $this.walletHeight;
    }

    public static final /* synthetic */ boolean access$processBlocks(WalletService $this) {
        return $this.processBlocks();
    }

    public static final /* synthetic */ void access$setNodeInfo$p(WalletService $this, InfoResponse infoResponse) {
        $this.nodeInfo = infoResponse;
    }

    public static final /* synthetic */ NodeService access$getNodeService$p(WalletService $this) {
        return $this.nodeService;
    }

    public static final /* synthetic */ Job access$getSyncJob$p(WalletService $this) {
        return $this.syncJob;
    }
}

