/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode.fop0205;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.logger.NullLogger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.DirectPropertyListBuilder;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.messaging.MessageHandler;
import org.krysalis.barcode.BarcodeDimension;
import org.krysalis.barcode.BarcodeException;
import org.krysalis.barcode.BarcodeGenerator;
import org.krysalis.barcode.BarcodeUtil;
import org.krysalis.barcode.fop0205.BarcodeArea;
import org.krysalis.barcode.fop0205.BarcodeObj;
import org.krysalis.barcode.tools.ConfigurationUtil;
import org.krysalis.barcode.tools.UnitConv;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class BarcodeElement
extends BarcodeObj {
    private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    FontState fs;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public BarcodeElement(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, "barcode", systemId, line, column);
        this.init();
    }

    protected void init() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            this.doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new CascadingRuntimeException("Error creating DOM", (Throwable)pce);
        }
        this.doc.appendChild(this.doc.createElementNS("http://www.krysalis.org/barcode/ns", "barcode"));
        this.element = this.doc.getDocumentElement();
        this.buildTopLevel(this.doc, this.element);
    }

    public void buildTopLevel(Document doc, Element svgRoot) {
        if (this.properties instanceof DirectPropertyListBuilder.AttrPropertyList) {
            Attributes attr = ((DirectPropertyListBuilder.AttrPropertyList)this.properties).getAttributes();
            int count = 0;
            while (count < attr.getLength()) {
                String rf = attr.getValue(count);
                String qname = attr.getQName(count);
                if (qname.indexOf(":") == -1) {
                    this.element.setAttribute(qname, rf);
                } else {
                    String pref = qname.substring(0, qname.indexOf(":"));
                    XMLObj.ns.put("xlink", "http://www.w3.org/1999/xlink");
                    if (pref.equals("xmlns")) {
                        XMLObj.ns.put(qname.substring(qname.indexOf(":") + 1), rf);
                        this.element.setAttributeNS(XMLNS_NAMESPACE_URI, qname, rf);
                    } else {
                        this.element.setAttributeNS((String)XMLObj.ns.get(pref), qname, rf);
                    }
                }
                ++count;
            }
        }
    }

    protected BarcodeArea createArea(FontState fontState, float width, float height) {
        return new BarcodeArea(fontState, width, height);
    }

    public int layout(Area area) throws FOPException {
        if (!(area instanceof ForeignObjectArea)) {
            throw new FOPException("Barcode not in fo:instream-foreign-object");
        }
        if (this.marker == -1000) {
            this.fs = area.getFontState();
            this.marker = 0;
        }
        Element barcodeRoot = this.element;
        ForeignObjectArea foa = (ForeignObjectArea)area;
        Element e = this.doc.getDocumentElement();
        e.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns", "http://www.krysalis.org/barcode/ns");
        Configuration cfg = ConfigurationUtil.buildConfiguration((Node)this.doc);
        try {
            String msg = cfg.getAttribute("msg");
            String renderMode = cfg.getAttribute("render-mode", "native");
            BarcodeGenerator bargen = BarcodeUtil.getInstance().createBarcodeGenerator(cfg, (Logger)new NullLogger());
            BarcodeDimension bardim = bargen.calcDimensions(msg);
            float w = (float)UnitConv.mm2pt((double)bardim.getWidthPlusQuiet()) * 1000.0f;
            float h = (float)UnitConv.mm2pt((double)bardim.getHeightPlusQuiet()) * 1000.0f;
            BarcodeArea barcodeArea = this.createArea(this.fs, w, h);
            barcodeArea.setBarcode(bargen, msg, renderMode);
            barcodeArea.start();
            barcodeArea.end();
            foa.setObject((Area)barcodeArea);
            foa.setIntrinsicWidth(barcodeArea.getWidth());
            foa.setIntrinsicHeight(barcodeArea.getHeight());
            return 1;
        }
        catch (ConfigurationException ce) {
            MessageHandler.errorln((String)("Error in barcode XML: " + ce.getMessage()));
            throw new FOPException("Error in barcode XML", (Throwable)ce);
        }
        catch (BarcodeException be) {
            MessageHandler.errorln((String)("Error generating barcode: " + be.getMessage()));
            throw new FOPException("Error generating barcode", (Throwable)be);
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new BarcodeElement(parent, propertyList, systemId, line, column);
        }
    }
}

