/*
 * Decompiled with CFR 0.152.
 */
package org.kson.ast;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.CompileTarget;
import org.kson.ast.AstNode;
import org.kson.ast.Documented;
import org.kson.ast.KsonValueNode;
import org.kson.ast.KsonValueNodeImpl;
import org.kson.ast.ListElementNode;
import org.kson.ast.ListElementNodeImpl;
import org.kson.ast.ObjectNode;
import org.kson.parser.Location;
import org.kson.tools.FormattingStyle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/kson/ast/ListNode;", "Lorg/kson/ast/KsonValueNodeImpl;", "elements", "", "Lorg/kson/ast/ListElementNode;", "location", "Lorg/kson/parser/Location;", "<init>", "(Ljava/util/List;Lorg/kson/parser/Location;)V", "getElements", "()Ljava/util/List;", "toSourceInternal", "", "indent", "Lorg/kson/ast/AstNode$Indent;", "nextNode", "Lorg/kson/ast/AstNode;", "compileTarget", "Lorg/kson/CompileTarget;", "formatDelimitedList", "listDelimiters", "Lorg/kson/ast/ListNode$ListDelimiters;", "formatCompactList", "formatUndelimitedList", "ListDelimiters", "kson"})
public final class ListNode
extends KsonValueNodeImpl {
    @NotNull
    private final List<ListElementNode> elements;

    public ListNode(@NotNull List<? extends ListElementNode> elements, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location);
        this.elements = elements;
    }

    @NotNull
    public final List<ListElementNode> getElements() {
        return this.elements;
    }

    @Override
    @NotNull
    protected String toSourceInternal(@NotNull AstNode.Indent indent, @Nullable AstNode nextNode, @NotNull CompileTarget compileTarget) {
        Object object;
        block15: {
            ListDelimiters listDelimiter;
            CompileTarget compileTarget2;
            block14: {
                ListDelimiters listDelimiters;
                Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
                compileTarget2 = compileTarget;
                if (compileTarget2 instanceof CompileTarget.Kson) {
                    listDelimiters = ListDelimiters.AngleBrackets.INSTANCE;
                } else if (compileTarget2 instanceof CompileTarget.Yaml || compileTarget2 instanceof CompileTarget.Json) {
                    listDelimiters = ListDelimiters.SquareBrackets.INSTANCE;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                listDelimiter = listDelimiters;
                if (this.elements.isEmpty()) {
                    return indent.firstLineIndent() + listDelimiter.getOpen() + listDelimiter.getClose();
                }
                compileTarget2 = compileTarget;
                if (!(compileTarget2 instanceof CompileTarget.Kson)) break block14;
                switch (WhenMappings.$EnumSwitchMapping$0[((CompileTarget.Kson)compileTarget).getFormatConfig().getFormattingStyle().ordinal()]) {
                    case 1: {
                        String outputList = this.formatUndelimitedList(indent, nextNode, compileTarget);
                        object = nextNode instanceof ListElementNode ? outputList + "\n" + indent.bodyLinesIndent() + "=" : outputList;
                        break block15;
                    }
                    case 2: {
                        object = this.formatDelimitedList(indent, nextNode, compileTarget, listDelimiter);
                        break block15;
                    }
                    case 3: {
                        object = this.formatCompactList(indent, nextNode, compileTarget, ListDelimiters.SquareBrackets.INSTANCE);
                        break block15;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (compileTarget2 instanceof CompileTarget.Yaml) {
                object = this.formatUndelimitedList(indent, nextNode, compileTarget);
            } else if (compileTarget2 instanceof CompileTarget.Json) {
                object = this.formatDelimitedList(indent, nextNode, compileTarget, listDelimiter);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final String formatDelimitedList(AstNode.Indent indent, AstNode nextNode, CompileTarget compileTarget, ListDelimiters listDelimiters) {
        String string;
        CompileTarget compileTarget2 = compileTarget;
        if (compileTarget2 instanceof CompileTarget.Kson) {
            string = "\n";
        } else if (compileTarget2 instanceof CompileTarget.Json) {
            string = ",\n";
        } else {
            throw new UnsupportedOperationException("We never format YAML objects as delimited");
        }
        String seperator = string;
        String bracketPadding = "\n";
        return indent.firstLineIndent() + listDelimiters.getOpen() + bracketPadding + CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)this.elements), (CharSequence)seperator, null, null, (int)0, null, arg_0 -> ListNode.formatDelimitedList$lambda$0(this, nextNode, indent, compileTarget, arg_0), (int)30, null) + bracketPadding + indent.bodyLinesIndent() + listDelimiters.getClose();
    }

    private final String formatCompactList(AstNode.Indent indent, AstNode nextNode, CompileTarget compileTarget, ListDelimiters listDelimiters) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)this.elements), (CharSequence)"", (CharSequence)String.valueOf(listDelimiters.getOpen()), (CharSequence)String.valueOf(listDelimiters.getClose()), (int)0, null, arg_0 -> ListNode.formatCompactList$lambda$1(this, nextNode, indent, compileTarget, arg_0), (int)24, null);
    }

    private final String formatUndelimitedList(AstNode.Indent indent, AstNode nextNode, CompileTarget compileTarget) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)this.elements), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ListNode.formatUndelimitedList$lambda$2(this, nextNode, indent, compileTarget, arg_0), (int)30, null);
    }

    private static final CharSequence formatDelimitedList$lambda$0(ListNode this$0, AstNode $nextNode, AstNode.Indent $indent, CompileTarget $compileTarget, IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        ListElementNode element = (ListElementNode)indexedValue.component2();
        ListElementNode listElementNode = (ListElementNode)CollectionsKt.getOrNull(this$0.elements, (int)(index + 1));
        AstNode nodeAfterThisChild = listElementNode != null ? (AstNode)listElementNode : $nextNode;
        return element.toSourceWithNext($indent.next(false), nodeAfterThisChild, $compileTarget);
    }

    private static final CharSequence formatCompactList$lambda$1(ListNode this$0, AstNode $nextNode, AstNode.Indent $indent, CompileTarget $compileTarget, IndexedValue indexedValue) {
        AstNode nodeAfterThisChild;
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        ListElementNode element = (ListElementNode)indexedValue.component2();
        ListElementNode listElementNode = (ListElementNode)CollectionsKt.getOrNull(this$0.elements, (int)(index + 1));
        AstNode astNode = nodeAfterThisChild = listElementNode != null ? (AstNode)listElementNode : $nextNode;
        String elementString = (element instanceof Documented && !((Collection)((Documented)((Object)element)).getComments()).isEmpty() ? "\n" : "") + element.toSourceWithNext($indent.clone(true), nodeAfterThisChild, $compileTarget);
        boolean isNotLastElement = index < this$0.elements.size() - 1;
        ListElementNodeImpl listElementNodeImpl = element instanceof ListElementNodeImpl ? (ListElementNodeImpl)element : null;
        KsonValueNode currentValue = listElementNodeImpl != null ? listElementNodeImpl.getValue() : null;
        boolean currentIsObject = currentValue instanceof ObjectNode;
        ListElementNodeImpl listElementNodeImpl2 = nodeAfterThisChild instanceof ListElementNodeImpl ? (ListElementNodeImpl)nodeAfterThisChild : null;
        boolean nextIsObject = (listElementNodeImpl2 != null ? listElementNodeImpl2.getValue() : null) instanceof ObjectNode;
        return isNotLastElement && currentIsObject && nextIsObject ? (CharSequence)("{" + elementString + "}") : (isNotLastElement && element instanceof ListElementNodeImpl && !(((ListElementNodeImpl)element).getValue() instanceof ListNode) ? (CharSequence)(elementString + " ") : (CharSequence)elementString);
    }

    private static final CharSequence formatUndelimitedList$lambda$2(ListNode this$0, AstNode $nextNode, AstNode.Indent $indent, CompileTarget $compileTarget, IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        ListElementNode element = (ListElementNode)indexedValue.component2();
        ListElementNode listElementNode = (ListElementNode)CollectionsKt.getOrNull(this$0.elements, (int)(index + 1));
        AstNode nodeAfterThisChild = listElementNode != null ? (AstNode)listElementNode : $nextNode;
        return element.toSourceWithNext($indent, nodeAfterThisChild, $compileTarget);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lorg/kson/ast/ListNode$ListDelimiters;", "", "open", "", "close", "<init>", "(CC)V", "getOpen", "()C", "getClose", "AngleBrackets", "SquareBrackets", "Lorg/kson/ast/ListNode$ListDelimiters$AngleBrackets;", "Lorg/kson/ast/ListNode$ListDelimiters$SquareBrackets;", "kson"})
    private static abstract class ListDelimiters {
        private final char open;
        private final char close;

        private ListDelimiters(char open, char close) {
            this.open = open;
            this.close = close;
        }

        public final char getOpen() {
            return this.open;
        }

        public final char getClose() {
            return this.close;
        }

        public /* synthetic */ ListDelimiters(char open, char close, DefaultConstructorMarker $constructor_marker) {
            this(open, close);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/kson/ast/ListNode$ListDelimiters$AngleBrackets;", "Lorg/kson/ast/ListNode$ListDelimiters;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kson"})
        public static final class AngleBrackets
        extends ListDelimiters {
            @NotNull
            public static final AngleBrackets INSTANCE = new AngleBrackets();

            private AngleBrackets() {
                super('<', '>', null);
            }

            @NotNull
            public String toString() {
                return "AngleBrackets";
            }

            public int hashCode() {
                return 1675842463;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AngleBrackets)) {
                    return false;
                }
                AngleBrackets cfr_ignored_0 = (AngleBrackets)other;
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/kson/ast/ListNode$ListDelimiters$SquareBrackets;", "Lorg/kson/ast/ListNode$ListDelimiters;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "kson"})
        public static final class SquareBrackets
        extends ListDelimiters {
            @NotNull
            public static final SquareBrackets INSTANCE = new SquareBrackets();

            private SquareBrackets() {
                super('[', ']', null);
            }

            @NotNull
            public String toString() {
                return "SquareBrackets";
            }

            public int hashCode() {
                return 2111521863;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SquareBrackets)) {
                    return false;
                }
                SquareBrackets cfr_ignored_0 = (SquareBrackets)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormattingStyle.values().length];
            try {
                nArray[FormattingStyle.PLAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormattingStyle.DELIMITED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormattingStyle.COMPACT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

