/*
 * Decompiled with CFR 0.152.
 */
package org.kson.ast;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.CompileTarget;
import org.kson.ast.AstNode;
import org.kson.ast.EscapingKt;
import org.kson.ast.StringNodeImpl;
import org.kson.parser.Location;
import org.kson.parser.behavior.StringQuote;
import org.kson.parser.behavior.StringUnquoted;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/kson/ast/QuotedStringNode;", "Lorg/kson/ast/StringNodeImpl;", "ksonEscapedStringContent", "", "stringQuote", "Lorg/kson/parser/behavior/StringQuote;", "location", "Lorg/kson/parser/Location;", "<init>", "(Ljava/lang/String;Lorg/kson/parser/behavior/StringQuote;Lorg/kson/parser/Location;)V", "unquotedString", "getUnquotedString", "()Ljava/lang/String;", "unquotedString$delegate", "Lkotlin/Lazy;", "stringContent", "getStringContent", "stringContent$delegate", "toSourceInternal", "indent", "Lorg/kson/ast/AstNode$Indent;", "nextNode", "Lorg/kson/ast/AstNode;", "compileTarget", "Lorg/kson/CompileTarget;", "kson"})
public class QuotedStringNode
extends StringNodeImpl {
    @NotNull
    private final String ksonEscapedStringContent;
    @NotNull
    private final StringQuote stringQuote;
    @NotNull
    private final Lazy unquotedString$delegate;
    @NotNull
    private final Lazy stringContent$delegate;

    public QuotedStringNode(@NotNull String ksonEscapedStringContent, @NotNull StringQuote stringQuote, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)ksonEscapedStringContent, (String)"ksonEscapedStringContent");
        Intrinsics.checkNotNullParameter((Object)stringQuote, (String)"stringQuote");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location);
        this.ksonEscapedStringContent = ksonEscapedStringContent;
        this.stringQuote = stringQuote;
        this.unquotedString$delegate = LazyKt.lazy(() -> QuotedStringNode.unquotedString_delegate$lambda$0(this));
        this.stringContent$delegate = LazyKt.lazy(() -> QuotedStringNode.stringContent_delegate$lambda$1(this));
    }

    private final String getUnquotedString() {
        Lazy lazy = this.unquotedString$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public String getStringContent() {
        Lazy lazy = this.stringContent$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    protected String toSourceInternal(@NotNull AstNode.Indent indent, @Nullable AstNode nextNode, @NotNull CompileTarget compileTarget) {
        String string;
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
        CompileTarget compileTarget2 = compileTarget;
        if (compileTarget2 instanceof CompileTarget.Kson) {
            Object object;
            boolean isSimple = StringUnquoted.INSTANCE.isUnquotable(this.getUnquotedString());
            String string2 = indent.firstLineIndent();
            if (isSimple) {
                object = this.getUnquotedString();
            } else {
                int singleQuoteCount = StringQuote.SingleQuote.INSTANCE.countDelimiterOccurrences(this.getUnquotedString());
                int doubleQuoteCount = StringQuote.DoubleQuote.INSTANCE.countDelimiterOccurrences(this.getUnquotedString());
                StringQuote chosenDelimiter = doubleQuoteCount < singleQuoteCount ? (StringQuote)StringQuote.DoubleQuote.INSTANCE : (StringQuote)StringQuote.SingleQuote.INSTANCE;
                String escapedContent = chosenDelimiter.escapeQuotes(this.getUnquotedString());
                object = chosenDelimiter + escapedContent + chosenDelimiter;
            }
            string = string2 + (String)object;
        } else if (compileTarget2 instanceof CompileTarget.Yaml) {
            string = indent.firstLineIndent() + "\"" + StringQuote.DoubleQuote.INSTANCE.escapeQuotes(this.getUnquotedString()) + "\"";
        } else if (compileTarget2 instanceof CompileTarget.Json) {
            string = indent.firstLineIndent() + "\"" + EscapingKt.escapeRawWhitespace(StringQuote.DoubleQuote.INSTANCE.escapeQuotes(this.getUnquotedString())) + "\"";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String unquotedString_delegate$lambda$0(QuotedStringNode this$0) {
        return this$0.stringQuote.unescapeQuotes(this$0.ksonEscapedStringContent);
    }

    private static final String stringContent_delegate$lambda$1(QuotedStringNode this$0) {
        return this$0.getUnquotedString();
    }
}

