/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.Lexeme;
import org.kson.parser.LexerKt;
import org.kson.parser.Location;
import org.kson.parser.SourceScanner;
import org.kson.parser.Token;
import org.kson.parser.TokenType;
import org.kson.parser.TokenizedSource;
import org.kson.parser.behavior.StringUnquoted;
import org.kson.parser.behavior.embedblock.EmbedBlockIndent;
import org.kson.parser.behavior.embedblock.EmbedDelim;
import org.kson.stdlibx.collections.ImmutableList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0017\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\rj\b\u0012\u0004\u0012\u00020\u0003`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/kson/parser/Lexer;", "", "source", "", "gapFree", "", "<init>", "(Ljava/lang/String;Z)V", "sourceScanner", "Lorg/kson/parser/SourceScanner;", "tokens", "Lorg/kson/parser/TokenizedSource;", "currentCommentLines", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "tokenize", "Lorg/kson/stdlibx/collections/ImmutableList;", "Lorg/kson/parser/Token;", "scan", "", "comment", "extractCommentToken", "isWhitespace", "char", "", "(Ljava/lang/Character;)Z", "isInlineWhitespace", "unquotedString", "quotedString", "delimiter", "embeddedBlock", "delimChar", "number", "addLiteralToken", "Lorg/kson/parser/Location;", "tokenType", "Lorg/kson/parser/TokenType;", "addToken", "type", "lexeme", "Lorg/kson/parser/Lexeme;", "value", "commentMetadataForCurrentToken", "Lorg/kson/parser/Lexer$CommentMetadata;", "currentTokenType", "Companion", "CommentMetadata", "kson"})
public final class Lexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SourceScanner sourceScanner;
    @NotNull
    private final TokenizedSource tokens;
    @NotNull
    private ArrayList<String> currentCommentLines;
    @NotNull
    private static final Set<TokenType> ignoredTokens;

    public Lexer(@NotNull String source, boolean gapFree) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.sourceScanner = new SourceScanner(source);
        this.tokens = new TokenizedSource(gapFree ? SetsKt.emptySet() : ignoredTokens);
        this.currentCommentLines = new ArrayList();
    }

    public /* synthetic */ Lexer(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    @NotNull
    public final ImmutableList<Token> tokenize() {
        while (!this.sourceScanner.eof()) {
            this.scan();
        }
        this.addToken(TokenType.EOF, new Lexeme("", this.sourceScanner.currentLocation()), "");
        return this.tokens.toList();
    }

    private final void scan() {
        Object object;
        char c = this.sourceScanner.advance();
        if (this.isWhitespace(Character.valueOf(c))) {
            while (this.isWhitespace(this.sourceScanner.peek()) && !this.sourceScanner.eof()) {
                this.sourceScanner.advance();
            }
            this.addLiteralToken(TokenType.WHITESPACE);
            return;
        }
        if (c == '-' && (this.isWhitespace(this.sourceScanner.peek()) || this.sourceScanner.eof())) {
            this.addLiteralToken(TokenType.LIST_DASH);
            return;
        }
        char c2 = c;
        if (c2 == '#') {
            String commentText = this.comment();
            object = this.currentCommentLines.add(commentText);
        } else if (c2 == '{') {
            object = this.addLiteralToken(TokenType.CURLY_BRACE_L);
        } else if (c2 == '}') {
            object = this.addLiteralToken(TokenType.CURLY_BRACE_R);
        } else if (c2 == '[') {
            object = this.addLiteralToken(TokenType.SQUARE_BRACKET_L);
        } else if (c2 == ']') {
            object = this.addLiteralToken(TokenType.SQUARE_BRACKET_R);
        } else if (c2 == '<') {
            object = this.addLiteralToken(TokenType.ANGLE_BRACKET_L);
        } else if (c2 == '>') {
            object = this.addLiteralToken(TokenType.ANGLE_BRACKET_R);
        } else if (c2 == ':') {
            object = this.addLiteralToken(TokenType.COLON);
        } else if (c2 == '.') {
            object = this.addLiteralToken(TokenType.DOT);
        } else if (c2 == '=') {
            object = this.addLiteralToken(TokenType.END_DASH);
        } else if (c2 == ',') {
            object = this.addLiteralToken(TokenType.COMMA);
        } else if (c2 == '\"' || c2 == '\'') {
            this.addLiteralToken(TokenType.STRING_OPEN_QUOTE);
            this.quotedString(c);
            object = Unit.INSTANCE;
        } else if (c2 == EmbedDelim.Percent.INSTANCE.getChar() || c2 == EmbedDelim.Dollar.INSTANCE.getChar()) {
            this.addLiteralToken(TokenType.EMBED_OPEN_DELIM);
            this.embeddedBlock(c);
            object = Unit.INSTANCE;
        } else if (c == '-' || Character.isDigit(c)) {
            this.number();
            object = Unit.INSTANCE;
        } else if (StringUnquoted.INSTANCE.isUnquotedStartChar(Character.valueOf(c))) {
            this.unquotedString();
            object = Unit.INSTANCE;
        } else {
            object = this.addLiteralToken(TokenType.ILLEGAL_CHAR);
        }
    }

    private final String comment() {
        Token commentToken = this.extractCommentToken();
        this.tokens.add(commentToken);
        return commentToken.getValue();
    }

    private final Token extractCommentToken() {
        while (true) {
            Character c = this.sourceScanner.peek();
            char c2 = '\n';
            if (c != null && c.charValue() == c2 || this.sourceScanner.eof()) break;
            this.sourceScanner.advance();
        }
        Lexeme commentLexeme = this.sourceScanner.extractLexeme();
        return new Token(TokenType.COMMENT, commentLexeme, commentLexeme.getText(), CollectionsKt.emptyList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isWhitespace(Character c) {
        if (this.isInlineWhitespace(c)) return true;
        Character c2 = c;
        char c3 = '\n';
        if (c2 == null) return false;
        if (c2.charValue() != c3) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInlineWhitespace(Character c) {
        Character c2 = c;
        char c3 = ' ';
        if (c2 != null) {
            if (c2.charValue() == c3) return true;
        }
        Character c4 = c;
        c3 = '\r';
        if (c4 != null) {
            if (c4.charValue() == c3) return true;
        }
        Character c5 = c;
        c3 = '\t';
        if (c5 == null) return false;
        if (c5.charValue() != c3) return false;
        return true;
    }

    private final void unquotedString() {
        while (StringUnquoted.INSTANCE.isUnquotedBodyChar(this.sourceScanner.peek())) {
            this.sourceScanner.advance();
        }
        Lexeme lexeme = this.sourceScanner.extractLexeme();
        TokenType tokenType = (TokenType)LexerKt.access$getKEYWORDS$p().get(lexeme.getText());
        if (tokenType == null) {
            tokenType = TokenType.UNQUOTED_STRING;
        }
        TokenType type = tokenType;
        this.addToken(type, lexeme, lexeme.getText());
    }

    private final void quotedString(char delimiter) {
        boolean hasUntokenizedStringCharacters = false;
        while (true) {
            Object object;
            char nextStringChar;
            Character c = this.sourceScanner.peek();
            char c2 = delimiter;
            if (c != null && c.charValue() == c2) break;
            Character c3 = this.sourceScanner.peek();
            if (c3 == null) {
                break;
            }
            char c4 = nextStringChar = c3.charValue();
            boolean bl = '\u0000' <= c4 ? c4 < ' ' : false;
            if (bl && !this.isWhitespace(Character.valueOf(nextStringChar))) {
                if (hasUntokenizedStringCharacters) {
                    this.addLiteralToken(TokenType.STRING_CONTENT);
                    hasUntokenizedStringCharacters = false;
                }
                this.sourceScanner.advance();
                object = this.addLiteralToken(TokenType.STRING_ILLEGAL_CONTROL_CHARACTER);
                continue;
            }
            if (nextStringChar == '\\') {
                if (hasUntokenizedStringCharacters) {
                    this.addLiteralToken(TokenType.STRING_CONTENT);
                    hasUntokenizedStringCharacters = false;
                }
                this.sourceScanner.advance();
                Character c5 = this.sourceScanner.peek();
                c4 = 'u';
                if (c5 != null && c5.charValue() == c4) {
                    this.sourceScanner.advance();
                    for (int c6 = 1; c6 < 5; ++c6) {
                        Character c7 = this.sourceScanner.peek();
                        char c8 = delimiter;
                        if (c7 != null && c7.charValue() == c8 || this.sourceScanner.eof()) break;
                        this.sourceScanner.advance();
                    }
                    object = this.addLiteralToken(TokenType.STRING_UNICODE_ESCAPE);
                    continue;
                }
                if (!this.sourceScanner.eof()) {
                    this.sourceScanner.advance();
                }
                object = this.addLiteralToken(TokenType.STRING_ESCAPE);
                continue;
            }
            this.sourceScanner.advance();
            hasUntokenizedStringCharacters = true;
            object = Unit.INSTANCE;
        }
        if (hasUntokenizedStringCharacters) {
            this.addLiteralToken(TokenType.STRING_CONTENT);
        }
        if (this.sourceScanner.eof()) {
            return;
        }
        this.sourceScanner.advance();
        this.addLiteralToken(TokenType.STRING_CLOSE_QUOTE);
    }

    private final void embeddedBlock(char delimChar) {
        if (this.isInlineWhitespace(this.sourceScanner.peek())) {
            while (this.isInlineWhitespace(this.sourceScanner.peek())) {
                this.sourceScanner.advance();
            }
            this.addLiteralToken(TokenType.WHITESPACE);
        }
        Character c = this.sourceScanner.peek();
        char c2 = '\n';
        if (c != null && c.charValue() == c2) {
            this.sourceScanner.advance();
            this.addLiteralToken(TokenType.EMBED_PREAMBLE_NEWLINE);
        } else {
            if (this.sourceScanner.eof()) {
                return;
            }
            Function1 stillInEmbedPreamble = arg_0 -> Lexer.embeddedBlock$lambda$0(this, delimChar, arg_0);
            while (((Boolean)stillInEmbedPreamble.invoke((Object)Character.valueOf(delimChar))).booleanValue()) {
                Character c3 = this.sourceScanner.peek();
                char c4 = ':';
                if (c3 != null && c3.charValue() == c4) break;
                this.sourceScanner.advance();
            }
            Lexeme embedTagLexeme = this.sourceScanner.extractLexeme();
            this.addToken(TokenType.EMBED_TAG, embedTagLexeme, ((Object)StringsKt.trim((CharSequence)embedTagLexeme.getText())).toString());
            Character c5 = this.sourceScanner.peek();
            char c6 = ':';
            if (c5 != null && c5.charValue() == c6) {
                this.sourceScanner.advance();
                this.addLiteralToken(TokenType.EMBED_TAG_STOP);
                while (((Boolean)stillInEmbedPreamble.invoke((Object)Character.valueOf(delimChar))).booleanValue()) {
                    this.sourceScanner.advance();
                }
                Lexeme embedMetadataLexeme = this.sourceScanner.extractLexeme();
                this.addToken(TokenType.EMBED_METADATA, embedMetadataLexeme, ((Object)StringsKt.trim((CharSequence)embedMetadataLexeme.getText())).toString());
            }
            Character c7 = this.sourceScanner.peek();
            c6 = delimChar;
            if (c7 != null && c7.charValue() == c6) {
                Character c8 = this.sourceScanner.peekNext();
                c6 = delimChar;
                if (c8 != null && c8.charValue() == c6) {
                    this.sourceScanner.advance();
                    this.sourceScanner.advance();
                    this.addLiteralToken(TokenType.EMBED_CLOSE_DELIM);
                    return;
                }
            }
            Character c9 = this.sourceScanner.peek();
            c6 = '\n';
            if (c9 != null && c9.charValue() == c6) {
                this.sourceScanner.advance();
                this.addLiteralToken(TokenType.EMBED_PREAMBLE_NEWLINE);
            } else if (this.sourceScanner.eof()) {
                return;
            }
        }
        while (!this.sourceScanner.eof()) {
            Character c10 = this.sourceScanner.peek();
            char stillInEmbedPreamble = delimChar;
            if (c10 != null && c10.charValue() == stillInEmbedPreamble) {
                Character c11 = this.sourceScanner.peekNext();
                stillInEmbedPreamble = delimChar;
                if (c11 != null && c11.charValue() == stillInEmbedPreamble) break;
            }
            this.sourceScanner.advance();
        }
        Lexeme embedBlockLexeme = this.sourceScanner.extractLexeme();
        String trimmedEmbedBlockContent = new EmbedBlockIndent(embedBlockLexeme.getText()).trimMinimumIndent();
        this.addToken(TokenType.EMBED_CONTENT, embedBlockLexeme, trimmedEmbedBlockContent);
        if (this.sourceScanner.eof()) {
            return;
        }
        this.sourceScanner.advance();
        this.sourceScanner.advance();
        this.addLiteralToken(TokenType.EMBED_CLOSE_DELIM);
    }

    private final void number() {
        while (true) {
            if (!StringUnquoted.INSTANCE.isUnquotedBodyChar(this.sourceScanner.peek())) {
                Character c = this.sourceScanner.peek();
                char c2 = '+';
                if (c == null || c.charValue() != c2) {
                    Character c3 = this.sourceScanner.peek();
                    c2 = '-';
                    if (c3 == null || c3.charValue() != c2) {
                        Character c4 = this.sourceScanner.peek();
                        c2 = '.';
                        if (c4 == null || c4.charValue() != c2) break;
                    }
                }
            }
            this.sourceScanner.advance();
        }
        this.addLiteralToken(TokenType.NUMBER);
    }

    private final Location addLiteralToken(TokenType tokenType) {
        Lexeme lexeme = this.sourceScanner.extractLexeme();
        this.addToken(tokenType, lexeme, lexeme.getText());
        return lexeme.getLocation();
    }

    private final Location addToken(TokenType type, Lexeme lexeme, String value) {
        CommentMetadata commentMetadata = this.commentMetadataForCurrentToken(type);
        this.tokens.add(new Token(type, lexeme, value, commentMetadata.getComments()));
        for (Token commentLookaheadTokens : commentMetadata.getLookaheadTokens()) {
            this.tokens.add(commentLookaheadTokens);
        }
        return lexeme.getLocation();
    }

    private final CommentMetadata commentMetadataForCurrentToken(TokenType currentTokenType) {
        if (currentTokenType == TokenType.COMMENT || currentTokenType == TokenType.WHITESPACE || currentTokenType == TokenType.EMBED_PREAMBLE_NEWLINE || currentTokenType == TokenType.STRING_CONTENT || currentTokenType == TokenType.STRING_ESCAPE || currentTokenType == TokenType.STRING_UNICODE_ESCAPE || currentTokenType == TokenType.STRING_ILLEGAL_CONTROL_CHARACTER) {
            return new CommentMetadata(CollectionsKt.emptyList(), CollectionsKt.emptyList());
        }
        ArrayList<String> commentsForToken = this.currentCommentLines;
        this.currentCommentLines = new ArrayList();
        boolean acceptsTrailingComments = currentTokenType != TokenType.STRING_OPEN_QUOTE && currentTokenType != TokenType.EMBED_OPEN_DELIM;
        ArrayList<Token> trailingCommentTokens = new ArrayList<Token>();
        if (acceptsTrailingComments) {
            String trailingComment;
            String string;
            if (this.isInlineWhitespace(this.sourceScanner.peek())) {
                while (this.isInlineWhitespace(this.sourceScanner.peek())) {
                    this.sourceScanner.advance();
                }
                Lexeme whitespaceLexeme = this.sourceScanner.extractLexeme();
                trailingCommentTokens.add(new Token(TokenType.WHITESPACE, whitespaceLexeme, whitespaceLexeme.getText(), CollectionsKt.emptyList()));
            }
            Character c = this.sourceScanner.peek();
            char c2 = '#';
            if (c != null && c.charValue() == c2) {
                Token commentToken = this.extractCommentToken();
                trailingCommentTokens.add(commentToken);
                string = commentToken.getValue();
            } else {
                string = trailingComment = "";
            }
            if (!StringsKt.isBlank((CharSequence)trailingComment)) {
                commentsForToken.add(trailingComment);
            }
        }
        return new CommentMetadata((List<String>)commentsForToken, (List<Token>)trailingCommentTokens);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean embeddedBlock$lambda$0(Lexer this$0, char $delimChar, char it) {
        if (this$0.sourceScanner.eof()) return false;
        Character c = this$0.sourceScanner.peek();
        char c2 = $delimChar;
        if (c != null && c.charValue() == c2) {
            Character c3 = this$0.sourceScanner.peekNext();
            c2 = $delimChar;
            if (c3 != null) {
                if (c3.charValue() == c2) return false;
            }
        }
        Character c4 = this$0.sourceScanner.peek();
        c2 = '\n';
        if (c4 == null) return true;
        if (c4.charValue() == c2) return false;
        return true;
    }

    static {
        Object[] objectArray = new TokenType[]{TokenType.WHITESPACE, TokenType.COMMENT};
        ignoredTokens = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/kson/parser/Lexer$CommentMetadata;", "", "comments", "", "", "lookaheadTokens", "Lorg/kson/parser/Token;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getComments", "()Ljava/util/List;", "getLookaheadTokens", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kson"})
    private static final class CommentMetadata {
        @NotNull
        private final List<String> comments;
        @NotNull
        private final List<Token> lookaheadTokens;

        public CommentMetadata(@NotNull List<String> comments, @NotNull List<Token> lookaheadTokens) {
            Intrinsics.checkNotNullParameter(comments, (String)"comments");
            Intrinsics.checkNotNullParameter(lookaheadTokens, (String)"lookaheadTokens");
            this.comments = comments;
            this.lookaheadTokens = lookaheadTokens;
        }

        @NotNull
        public final List<String> getComments() {
            return this.comments;
        }

        @NotNull
        public final List<Token> getLookaheadTokens() {
            return this.lookaheadTokens;
        }

        @NotNull
        public final List<String> component1() {
            return this.comments;
        }

        @NotNull
        public final List<Token> component2() {
            return this.lookaheadTokens;
        }

        @NotNull
        public final CommentMetadata copy(@NotNull List<String> comments, @NotNull List<Token> lookaheadTokens) {
            Intrinsics.checkNotNullParameter(comments, (String)"comments");
            Intrinsics.checkNotNullParameter(lookaheadTokens, (String)"lookaheadTokens");
            return new CommentMetadata(comments, lookaheadTokens);
        }

        public static /* synthetic */ CommentMetadata copy$default(CommentMetadata commentMetadata, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = commentMetadata.comments;
            }
            if ((n & 2) != 0) {
                list2 = commentMetadata.lookaheadTokens;
            }
            return commentMetadata.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "CommentMetadata(comments=" + this.comments + ", lookaheadTokens=" + this.lookaheadTokens + ")";
        }

        public int hashCode() {
            int result = ((Object)this.comments).hashCode();
            result = result * 31 + ((Object)this.lookaheadTokens).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommentMetadata)) {
                return false;
            }
            CommentMetadata commentMetadata = (CommentMetadata)other;
            if (!Intrinsics.areEqual(this.comments, commentMetadata.comments)) {
                return false;
            }
            return Intrinsics.areEqual(this.lookaheadTokens, commentMetadata.lookaheadTokens);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/kson/parser/Lexer$Companion;", "", "<init>", "()V", "ignoredTokens", "", "Lorg/kson/parser/TokenType;", "getIgnoredTokens", "()Ljava/util/Set;", "kson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<TokenType> getIgnoredTokens() {
            return ignoredTokens;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

