/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser;

import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kson.parser.AstBuilder;
import org.kson.parser.AstMarker;
import org.kson.parser.ExcessiveNestingException;
import org.kson.parser.NumberParser;
import org.kson.parser.ParsedElementType;
import org.kson.parser.Parser;
import org.kson.parser.ParserKt;
import org.kson.parser.TokenType;
import org.kson.parser.messages.MessageType;
import org.kson.stdlibx.exceptions.FatalParseException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\b\u0003*\u0001%\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010&\u00a8\u0006'"}, d2={"Lorg/kson/parser/Parser;", "", "builder", "Lorg/kson/parser/AstBuilder;", "maxNestingLevel", "", "<init>", "(Lorg/kson/parser/AstBuilder;I)V", "parse", "", "ksonValue", "", "plainObject", "objectInternals", "parseValueForKeyword", "keywordMark", "Lorg/kson/parser/AstMarker;", "dashList", "isDelimited", "processComma", "delimitedValue", "delimitedObject", "delimitedDashList", "bracketList", "literal", "keyword", "string", "isValidStringEscape", "stringEscapeText", "", "embedPreamble", "isValidUnicodeEscape", "unicodeEscapeText", "embedBlock", "handleUnexpectedTrailingContent", "containsKsonValue", "nestingTracker", "org/kson/parser/Parser$nestingTracker$1", "Lorg/kson/parser/Parser$nestingTracker$1;", "kson"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\norg/kson/parser/Parser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,834:1\n1761#2,3:835\n1332#3,3:838\n1#4:841\n*S KotlinDebug\n*F\n+ 1 Parser.kt\norg/kson/parser/Parser\n*L\n504#1:835,3\n772#1:838,3\n*E\n"})
public final class Parser {
    @NotNull
    private final AstBuilder builder;
    private final int maxNestingLevel;
    @NotNull
    private nestingTracker.1 nestingTracker;

    public Parser(@NotNull AstBuilder builder, int maxNestingLevel) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.maxNestingLevel = maxNestingLevel;
        this.nestingTracker = new Object(this){
            private int nestingLevel;
            final /* synthetic */ Parser this$0;
            {
                this.this$0 = $receiver;
            }

            public final boolean nest(Function0<Boolean> nestingParserFunction) {
                Intrinsics.checkNotNullParameter(nestingParserFunction, (String)"nestingParserFunction");
                int n = this.nestingLevel;
                this.nestingLevel = n + 1;
                if (this.nestingLevel > Parser.access$getMaxNestingLevel$p(this.this$0)) {
                    throw new ExcessiveNestingException();
                }
                boolean parseResult = (Boolean)nestingParserFunction.invoke();
                int n2 = this.nestingLevel;
                this.nestingLevel = n2 + -1;
                return parseResult;
            }
        };
    }

    public /* synthetic */ Parser(AstBuilder astBuilder, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 128;
        }
        this(astBuilder, n);
    }

    public final void parse() {
        if (this.builder.eof()) {
            return;
        }
        AstMarker rootMarker2 = this.builder.mark();
        try {
            boolean containsKsonValue = this.ksonValue();
            this.handleUnexpectedTrailingContent(containsKsonValue);
            if (!this.builder.eof()) {
                throw new FatalParseException("Bug: this parser must consume all tokens in all cases");
            }
            rootMarker2.drop();
        }
        catch (ExcessiveNestingException nestingException) {
            rootMarker2.rollbackTo();
            AstMarker nestedExpressionMark = this.builder.mark();
            while (!this.builder.eof()) {
                this.builder.advanceLexer();
            }
            String[] stringArray = new String[]{String.valueOf(this.maxNestingLevel)};
            nestedExpressionMark.error(MessageType.MAX_NESTING_LEVEL_EXCEEDED.create(stringArray));
        }
    }

    private final boolean ksonValue() {
        return this.plainObject() || Parser.dashList$default(this, false, 1, null) || this.delimitedValue();
    }

    private final boolean plainObject() {
        return this.nestingTracker.nest((Function0<Boolean>)((Function0)() -> Parser.plainObject$lambda$0(this)));
    }

    private final boolean objectInternals() {
        return this.nestingTracker.nest((Function0<Boolean>)((Function0)() -> Parser.objectInternals$lambda$1(this)));
    }

    private final void parseValueForKeyword(AstMarker keywordMark) {
        AstMarker valueMark = this.builder.mark();
        if (!this.ksonValue()) {
            valueMark.rollbackTo();
            keywordMark.error(MessageType.OBJECT_KEY_NO_VALUE.create(new String[0]));
        } else {
            valueMark.drop();
            keywordMark.drop();
        }
    }

    private final boolean dashList(boolean isDelimited) {
        return this.nestingTracker.nest((Function0<Boolean>)((Function0)() -> Parser.dashList$lambda$2(this, isDelimited)));
    }

    static /* synthetic */ boolean dashList$default(Parser parser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return parser.dashList(bl);
    }

    private final void processComma(AstBuilder builder) {
        AstMarker commaMark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == TokenType.COMMA) {
            while (builder.getTokenType() == TokenType.COMMA) {
                builder.advanceLexer();
            }
            commaMark.error(MessageType.EMPTY_COMMAS.create(new String[0]));
        } else {
            commaMark.drop();
        }
    }

    private final boolean delimitedValue() {
        if (this.builder.getTokenType() == TokenType.CURLY_BRACE_R) {
            AstMarker badCloseBrace = this.builder.mark();
            this.builder.advanceLexer();
            badCloseBrace.error(MessageType.OBJECT_NO_OPEN.create(new String[0]));
            return true;
        }
        if (this.builder.getTokenType() == TokenType.SQUARE_BRACKET_R) {
            AstMarker badCloseBrace = this.builder.mark();
            this.builder.advanceLexer();
            badCloseBrace.error(MessageType.LIST_NO_OPEN.create(new String[0]));
            return true;
        }
        if (this.builder.getTokenType() == TokenType.ANGLE_BRACKET_R) {
            AstMarker badCloseBrace = this.builder.mark();
            this.builder.advanceLexer();
            badCloseBrace.error(MessageType.LIST_NO_OPEN.create(new String[0]));
            return true;
        }
        if (this.builder.getTokenType() == TokenType.ILLEGAL_CHAR) {
            AstMarker illegalCharMark = this.builder.mark();
            ArrayList<String> illegalChars = new ArrayList<String>();
            while (this.builder.getTokenType() == TokenType.ILLEGAL_CHAR) {
                illegalChars.add(this.builder.getTokenText());
                this.builder.advanceLexer();
            }
            String[] stringArray = new String[]{CollectionsKt.joinToString$default((Iterable)illegalChars, null, null, null, (int)0, null, null, (int)63, null)};
            illegalCharMark.error(MessageType.ILLEGAL_CHARACTERS.create(stringArray));
        }
        return this.delimitedObject() || this.delimitedDashList() || this.bracketList() || this.literal() || this.embedBlock();
    }

    private final boolean delimitedObject() {
        if (this.builder.getTokenType() != TokenType.CURLY_BRACE_L) {
            return false;
        }
        AstMarker delimitedObjectMark = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == TokenType.CURLY_BRACE_R) {
            this.builder.advanceLexer();
            delimitedObjectMark.done(ParsedElementType.OBJECT);
            return true;
        }
        this.objectInternals();
        while (this.builder.getTokenType() != TokenType.CURLY_BRACE_R && !this.builder.eof()) {
            AstMarker malformedInternals = this.builder.mark();
            while (this.builder.getTokenType() != TokenType.CURLY_BRACE_R && !this.builder.eof()) {
                this.builder.advanceLexer();
                AstMarker keywordMark = this.builder.mark();
                if (this.keyword()) {
                    keywordMark.rollbackTo();
                    break;
                }
                keywordMark.drop();
            }
            malformedInternals.error(MessageType.OBJECT_BAD_INTERNALS.create(new String[0]));
            this.objectInternals();
        }
        if (this.builder.getTokenType() == TokenType.CURLY_BRACE_R) {
            this.builder.advanceLexer();
            delimitedObjectMark.done(ParsedElementType.OBJECT);
        } else {
            delimitedObjectMark.error(MessageType.OBJECT_NO_CLOSE.create(new String[0]));
        }
        return true;
    }

    private final boolean delimitedDashList() {
        if (this.builder.getTokenType() != TokenType.ANGLE_BRACKET_L) {
            return false;
        }
        AstMarker listMark = this.builder.mark();
        this.builder.advanceLexer();
        this.dashList(true);
        if (this.builder.getTokenType() == TokenType.ANGLE_BRACKET_R) {
            this.builder.advanceLexer();
            listMark.done(ParsedElementType.DASH_DELIMITED_LIST);
        } else {
            listMark.error(MessageType.LIST_NO_CLOSE.create(new String[0]));
        }
        return true;
    }

    private final boolean bracketList() {
        return this.nestingTracker.nest((Function0<Boolean>)((Function0)() -> Parser.bracketList$lambda$3(this)));
    }

    private final boolean literal() {
        if (this.string()) {
            return true;
        }
        TokenType elementType = this.builder.getTokenType();
        if (elementType == TokenType.NUMBER) {
            AstMarker numberMark = this.builder.mark();
            String numberCandidate = this.builder.getTokenText();
            this.builder.advanceLexer();
            NumberParser.NumberParseResult numberParseResult = new NumberParser(numberCandidate).parse();
            if (numberParseResult.getError() != null) {
                numberMark.error(numberParseResult.getError());
            } else {
                numberMark.done(TokenType.NUMBER);
            }
            return true;
        }
        AstMarker terminalElementMark = this.builder.mark();
        if (elementType != null) {
            boolean bl;
            block9: {
                Object[] numberCandidate = new TokenType[]{TokenType.TRUE, TokenType.FALSE, TokenType.NULL};
                Iterable $this$any$iv = SetsKt.setOf((Object[])numberCandidate);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TokenType it = (TokenType)element$iv;
                        boolean bl2 = false;
                        if (!(it == elementType)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.builder.advanceLexer();
                terminalElementMark.done(elementType);
                return true;
            }
        }
        terminalElementMark.rollbackTo();
        return false;
    }

    private final boolean keyword() {
        AstMarker keywordMark = this.builder.mark();
        if ((this.builder.getTokenType() == TokenType.NULL || this.builder.getTokenType() == TokenType.TRUE || this.builder.getTokenType() == TokenType.FALSE) && this.builder.lookAhead(1) == TokenType.COLON) {
            String reservedWord = this.builder.getTokenText();
            this.builder.advanceLexer();
            String[] stringArray = new String[]{reservedWord};
            keywordMark.error(MessageType.OBJECT_KEYWORD_RESERVED_WORD.create(stringArray));
            this.builder.advanceLexer();
            return true;
        }
        if (this.string() && this.builder.getTokenType() == TokenType.COLON) {
            keywordMark.done(ParsedElementType.OBJECT_KEY);
            this.builder.advanceLexer();
            return true;
        }
        keywordMark.rollbackTo();
        return false;
    }

    private final boolean string() {
        if (this.builder.getTokenType() == TokenType.UNQUOTED_STRING) {
            AstMarker unquotedStringMark = this.builder.mark();
            this.builder.advanceLexer();
            unquotedStringMark.done(TokenType.UNQUOTED_STRING);
            return true;
        }
        if (this.builder.getTokenType() != TokenType.STRING_OPEN_QUOTE) {
            return false;
        }
        AstMarker stringMark = this.builder.mark();
        AstMarker possiblyUnclosedString = this.builder.mark();
        this.builder.advanceLexer();
        block6: while (this.builder.getTokenType() != TokenType.STRING_CLOSE_QUOTE && !this.builder.eof()) {
            TokenType tokenType = this.builder.getTokenType();
            switch (tokenType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[tokenType.ordinal()]) {
                case 1: {
                    this.builder.advanceLexer();
                    continue block6;
                }
                case 2: {
                    AstMarker unicodeEscapeMark = this.builder.mark();
                    String unicodeEscapeText = this.builder.getTokenText();
                    this.builder.advanceLexer();
                    if (this.isValidUnicodeEscape(unicodeEscapeText)) {
                        unicodeEscapeMark.drop();
                        continue block6;
                    }
                    String[] stringArray = new String[]{unicodeEscapeText};
                    unicodeEscapeMark.error(MessageType.STRING_BAD_UNICODE_ESCAPE.create(stringArray));
                    continue block6;
                }
                case 3: {
                    AstMarker stringEscapeMark = this.builder.mark();
                    String stringEscapeText = this.builder.getTokenText();
                    this.builder.advanceLexer();
                    if (this.isValidStringEscape(stringEscapeText)) {
                        stringEscapeMark.drop();
                        continue block6;
                    }
                    String[] stringArray = new String[]{stringEscapeText};
                    stringEscapeMark.error(MessageType.STRING_BAD_ESCAPE.create(stringArray));
                    continue block6;
                }
                case 4: {
                    AstMarker controlCharacterMark = this.builder.mark();
                    String badControlChar = this.builder.getTokenText();
                    this.builder.advanceLexer();
                    String[] stringArray = new String[]{badControlChar};
                    controlCharacterMark.error(MessageType.STRING_CONTROL_CHARACTER.create(stringArray));
                    continue block6;
                }
            }
            stringMark.rollbackTo();
            return false;
        }
        if (this.builder.eof()) {
            possiblyUnclosedString.error(MessageType.STRING_NO_CLOSE.create(new String[0]));
        } else {
            possiblyUnclosedString.drop();
            this.builder.advanceLexer();
        }
        stringMark.done(ParsedElementType.QUOTED_STRING);
        return true;
    }

    private final boolean isValidStringEscape(String stringEscapeText) {
        if (!StringsKt.startsWith$default((CharSequence)stringEscapeText, (char)'\\', (boolean)false, (int)2, null) || stringEscapeText.length() > 2) {
            throw new FatalParseException("Should only be asked to validate one-char string escapes, but was passed: " + stringEscapeText);
        }
        if (stringEscapeText.length() == 1) {
            return false;
        }
        char escapedChar = stringEscapeText.charAt(1);
        return ParserKt.access$getValidStringEscapes$p().contains(Character.valueOf(escapedChar));
    }

    /*
     * WARNING - void declaration
     */
    private final String embedPreamble() {
        Object object;
        AstMarker embedTagMark = this.builder.mark();
        if (this.builder.getTokenType() == TokenType.EMBED_TAG) {
            void var3_2;
            String embedMeta;
            String string;
            String tagText = this.builder.getTokenText();
            this.builder.advanceLexer();
            embedTagMark.done(TokenType.EMBED_TAG);
            if (this.builder.getTokenType() == TokenType.EMBED_TAG_STOP) {
                AstMarker embedTagDelim = this.builder.mark();
                this.builder.advanceLexer();
                embedTagDelim.done(TokenType.EMBED_TAG_STOP);
                AstMarker metaTagMark = this.builder.mark();
                String metaText = this.builder.getTokenText();
                this.builder.advanceLexer();
                metaTagMark.done(TokenType.EMBED_METADATA);
                string = metaText;
            } else {
                string = embedMeta = "";
            }
            object = ((CharSequence)embedMeta).length() > 0 ? tagText + ":" + embedMeta : var3_2;
        } else {
            embedTagMark.drop();
            object = "";
        }
        String embedTag = object;
        return embedTag;
    }

    private final boolean isValidUnicodeEscape(String unicodeEscapeText) {
        if (!StringsKt.startsWith$default((String)unicodeEscapeText, (String)"\\u", (boolean)false, (int)2, null)) {
            throw new FatalParseException("Should only be asked to validate unicode escapes");
        }
        String unicodeCodePoint = StringsKt.replaceFirst$default((String)unicodeEscapeText, (String)"\\u", (String)"", (boolean)false, (int)4, null);
        if (unicodeCodePoint.length() != 4) {
            return false;
        }
        int n = unicodeCodePoint.length();
        for (int i = 0; i < n; ++i) {
            char codePointChar = unicodeCodePoint.charAt(i);
            if (ParserKt.access$getValidHexChars$p().contains(Character.valueOf(codePointChar))) continue;
            return false;
        }
        return true;
    }

    private final boolean embedBlock() {
        if (this.builder.getTokenType() == TokenType.EMBED_OPEN_DELIM) {
            AstMarker embedBlockMark = this.builder.mark();
            AstMarker embedBlockStartDelimMark = this.builder.mark();
            String embedStartDelimiter = this.builder.getTokenText();
            this.builder.advanceLexer();
            embedBlockStartDelimMark.done(TokenType.EMBED_OPEN_DELIM);
            String embedPreambleText = this.embedPreamble();
            AstMarker prematureEndMark = this.builder.mark();
            if (this.builder.getTokenType() == TokenType.EMBED_CLOSE_DELIM) {
                this.builder.advanceLexer();
                String[] stringArray = new String[]{embedStartDelimiter, embedPreambleText};
                prematureEndMark.error(MessageType.EMBED_BLOCK_NO_NEWLINE.create(stringArray));
                embedBlockMark.done(ParsedElementType.EMBED_BLOCK);
                return true;
            }
            prematureEndMark.drop();
            if (this.builder.eof()) {
                String[] stringArray = new String[]{embedStartDelimiter};
                embedBlockMark.error(MessageType.EMBED_BLOCK_NO_CLOSE.create(stringArray));
                return true;
            }
            if (this.builder.getTokenType() != TokenType.EMBED_PREAMBLE_NEWLINE) {
                String[] stringArray = new String[]{embedStartDelimiter};
                embedBlockMark.error(MessageType.EMBED_BLOCK_NO_CLOSE.create(stringArray));
                return true;
            }
            this.builder.advanceLexer();
            AstMarker embedBlockContentMark = this.builder.mark();
            if (this.builder.getTokenType() == TokenType.EMBED_CONTENT) {
                this.builder.advanceLexer();
                embedBlockContentMark.done(TokenType.EMBED_CONTENT);
            } else {
                embedBlockContentMark.drop();
            }
            if (this.builder.getTokenType() == TokenType.EMBED_CLOSE_DELIM) {
                this.builder.advanceLexer();
                embedBlockMark.done(ParsedElementType.EMBED_BLOCK);
            } else if (this.builder.eof()) {
                String[] stringArray = new String[]{embedStartDelimiter};
                embedBlockMark.error(MessageType.EMBED_BLOCK_NO_CLOSE.create(stringArray));
            }
            return true;
        }
        return false;
    }

    private final void handleUnexpectedTrailingContent(boolean containsKsonValue) {
        Sequence $this$forEachIndexed$iv = SequencesKt.generateSequence(() -> Parser.handleUnexpectedTrailingContent$lambda$6(this));
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            AstBuilder cfr_ignored_0 = (AstBuilder)item$iv;
            int index = n;
            boolean bl = false;
            AstMarker unexpectedContentMark = this.builder.mark();
            if (!this.ksonValue()) {
                this.builder.advanceLexer();
            }
            if (index == 0) {
                MessageType errorMessage = containsKsonValue ? MessageType.EOF_NOT_REACHED : MessageType.ONLY_UNEXPECTED_CONTENT;
                unexpectedContentMark.error(errorMessage.create(new String[0]));
                continue;
            }
            unexpectedContentMark.drop();
        }
    }

    private static final boolean plainObject$lambda$0(Parser this$0) {
        AstMarker keywordMark;
        AstMarker propertyMark;
        AstMarker objectMark = this$0.builder.mark();
        boolean foundProperties = false;
        while (true) {
            propertyMark = this$0.builder.mark();
            keywordMark = this$0.builder.mark();
            if (!this$0.keyword()) break;
            foundProperties = true;
            this$0.parseValueForKeyword(keywordMark);
            propertyMark.done(ParsedElementType.OBJECT_PROPERTY);
        }
        keywordMark.drop();
        propertyMark.rollbackTo();
        if (this$0.builder.getTokenType() == TokenType.DOT) {
            this$0.builder.advanceLexer();
        }
        if (foundProperties) {
            objectMark.done(ParsedElementType.OBJECT);
            return true;
        }
        objectMark.rollbackTo();
        return false;
    }

    private static final boolean objectInternals$lambda$1(Parser this$0) {
        boolean foundProperties;
        block5: {
            AstMarker keywordMark;
            AstMarker propertyMark;
            foundProperties = false;
            if (this$0.builder.getTokenType() == TokenType.COMMA) {
                AstMarker leadingCommaMark = this$0.builder.mark();
                this$0.processComma(this$0.builder);
                if (this$0.builder.getTokenType() == TokenType.CURLY_BRACE_R || this$0.builder.eof()) {
                    leadingCommaMark.error(MessageType.EMPTY_COMMAS.create(new String[0]));
                    return true;
                }
                leadingCommaMark.drop();
            }
            while (true) {
                propertyMark = this$0.builder.mark();
                keywordMark = this$0.builder.mark();
                if (!this$0.keyword()) break;
                foundProperties = true;
                if (this$0.builder.getTokenType() == TokenType.CURLY_BRACE_R) {
                    keywordMark.error(MessageType.OBJECT_KEY_NO_VALUE.create(new String[0]));
                    propertyMark.done(ParsedElementType.OBJECT_PROPERTY);
                    break block5;
                }
                this$0.parseValueForKeyword(keywordMark);
                if (this$0.builder.getTokenType() == TokenType.COMMA) {
                    this$0.processComma(this$0.builder);
                }
                propertyMark.done(ParsedElementType.OBJECT_PROPERTY);
                if (this$0.builder.getTokenType() != TokenType.DOT) continue;
                AstMarker dotMark = this$0.builder.mark();
                this$0.builder.advanceLexer();
                dotMark.error(MessageType.IGNORED_OBJECT_END_DOT.create(new String[0]));
            }
            keywordMark.drop();
            propertyMark.rollbackTo();
        }
        return foundProperties;
    }

    private static final boolean dashList$lambda$2(Parser this$0, boolean $isDelimited) {
        if (this$0.builder.getTokenType() != TokenType.LIST_DASH) {
            return false;
        }
        AstMarker listMark = this$0.builder.mark();
        do {
            AstMarker listElementMark = this$0.builder.mark();
            this$0.builder.advanceLexer();
            if (this$0.ksonValue()) {
                listElementMark.done(ParsedElementType.LIST_ELEMENT);
            } else {
                listElementMark.error(MessageType.DANGLING_LIST_DASH.create(new String[0]));
            }
            if (this$0.builder.getTokenType() != TokenType.END_DASH) continue;
            AstMarker endDashMark = this$0.builder.mark();
            this$0.builder.advanceLexer();
            if (!$isDelimited) {
                endDashMark.drop();
                break;
            }
            endDashMark.error(MessageType.IGNORED_DASH_LIST_END_DASH.create(new String[0]));
        } while (this$0.builder.getTokenType() == TokenType.LIST_DASH);
        if (!$isDelimited) {
            listMark.done(ParsedElementType.DASH_LIST);
        } else {
            listMark.drop();
        }
        return true;
    }

    private static final boolean bracketList$lambda$3(Parser this$0) {
        if (this$0.builder.getTokenType() != TokenType.SQUARE_BRACKET_L) {
            return false;
        }
        AstMarker listMark = this$0.builder.mark();
        this$0.builder.advanceLexer();
        if (this$0.builder.getTokenType() == TokenType.COMMA) {
            AstMarker leadingCommaMark = this$0.builder.mark();
            this$0.processComma(this$0.builder);
            if (this$0.builder.getTokenType() == TokenType.SQUARE_BRACKET_R) {
                this$0.builder.advanceLexer();
                leadingCommaMark.error(MessageType.EMPTY_COMMAS.create(new String[0]));
                listMark.done(ParsedElementType.BRACKET_LIST);
                return true;
            }
            leadingCommaMark.drop();
        }
        while (this$0.builder.getTokenType() != TokenType.SQUARE_BRACKET_R && !this$0.builder.eof()) {
            AstMarker listElementMark = this$0.builder.mark();
            if (!this$0.ksonValue()) {
                AstMarker invalidElementMark = this$0.builder.mark();
                boolean containsInvalidElement = false;
                while (this$0.builder.getTokenType() != TokenType.SQUARE_BRACKET_R && this$0.builder.getTokenType() != TokenType.COMMA && !this$0.builder.eof()) {
                    this$0.builder.advanceLexer();
                    containsInvalidElement = true;
                }
                if (containsInvalidElement) {
                    invalidElementMark.error(MessageType.LIST_INVALID_ELEM.create(new String[0]));
                } else {
                    invalidElementMark.drop();
                }
            }
            if (this$0.builder.getTokenType() == TokenType.COMMA) {
                this$0.processComma(this$0.builder);
                listElementMark.done(ParsedElementType.LIST_ELEMENT);
                continue;
            }
            listElementMark.done(ParsedElementType.LIST_ELEMENT);
        }
        if (this$0.builder.getTokenType() == TokenType.SQUARE_BRACKET_R) {
            this$0.builder.advanceLexer();
            listMark.done(ParsedElementType.BRACKET_LIST);
        } else {
            listMark.error(MessageType.LIST_NO_CLOSE.create(new String[0]));
        }
        return true;
    }

    private static final AstBuilder handleUnexpectedTrailingContent$lambda$6(Parser this$0) {
        AstBuilder astBuilder;
        AstBuilder it = astBuilder = this$0.builder;
        boolean bl = false;
        return !it.eof() ? astBuilder : null;
    }

    public static final /* synthetic */ int access$getMaxNestingLevel$p(Parser $this) {
        return $this.maxNestingLevel;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.STRING_CONTENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.STRING_UNICODE_ESCAPE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.STRING_ESCAPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.STRING_ILLEGAL_CONTROL_CHARACTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

