/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser.behavior;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/kson/parser/behavior/StringQuote;", "", "quoteChar", "", "<init>", "(C)V", "delimiterString", "", "escapedDelimiterString", "countDelimiterOccurrences", "", "rawContent", "escapeQuotes", "unescapeQuotes", "escapedContent", "toString", "SingleQuote", "DoubleQuote", "Companion", "Lorg/kson/parser/behavior/StringQuote$DoubleQuote;", "Lorg/kson/parser/behavior/StringQuote$SingleQuote;", "kson"})
@SourceDebugExtension(value={"SMAP\nStringQuote.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringQuote.kt\norg/kson/parser/behavior/StringQuote\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,64:1\n1104#2,3:65\n*S KotlinDebug\n*F\n+ 1 StringQuote.kt\norg/kson/parser/behavior/StringQuote\n*L\n27#1:65,3\n*E\n"})
public abstract class StringQuote {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char quoteChar;
    @NotNull
    private final String delimiterString;
    @NotNull
    private final String escapedDelimiterString;

    private StringQuote(char quoteChar) {
        this.quoteChar = quoteChar;
        this.delimiterString = String.valueOf(this.quoteChar);
        this.escapedDelimiterString = "\\" + this.quoteChar;
    }

    public final int countDelimiterOccurrences(@NotNull String rawContent) {
        Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
        CharSequence $this$count$iv = rawContent;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == this.quoteChar)) continue;
            ++count$iv;
        }
        return count$iv;
    }

    @NotNull
    public final String escapeQuotes(@NotNull String rawContent) {
        Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
        return StringsKt.replace$default((String)rawContent, (String)this.delimiterString, (String)this.escapedDelimiterString, (boolean)false, (int)4, null);
    }

    @NotNull
    public final String unescapeQuotes(@NotNull String escapedContent) {
        Intrinsics.checkNotNullParameter((Object)escapedContent, (String)"escapedContent");
        return StringsKt.replace$default((String)escapedContent, (String)this.escapedDelimiterString, (String)this.delimiterString, (boolean)false, (int)4, null);
    }

    @NotNull
    public String toString() {
        return this.delimiterString;
    }

    public /* synthetic */ StringQuote(char quoteChar, DefaultConstructorMarker $constructor_marker) {
        this(quoteChar);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/kson/parser/behavior/StringQuote$Companion;", "", "<init>", "()V", "fromChar", "Lorg/kson/parser/behavior/StringQuote;", "delimString", "", "kson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringQuote fromChar(char delimString) {
            StringQuote stringQuote;
            switch (delimString) {
                case '\'': {
                    stringQuote = SingleQuote.INSTANCE;
                    break;
                }
                case '\"': {
                    stringQuote = DoubleQuote.INSTANCE;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown string delimiter: " + delimString);
                }
            }
            return stringQuote;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kson/parser/behavior/StringQuote$DoubleQuote;", "Lorg/kson/parser/behavior/StringQuote;", "<init>", "()V", "kson"})
    public static final class DoubleQuote
    extends StringQuote {
        @NotNull
        public static final DoubleQuote INSTANCE = new DoubleQuote();

        private DoubleQuote() {
            super('\"', null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/kson/parser/behavior/StringQuote$SingleQuote;", "Lorg/kson/parser/behavior/StringQuote;", "<init>", "()V", "kson"})
    public static final class SingleQuote
    extends StringQuote {
        @NotNull
        public static final SingleQuote INSTANCE = new SingleQuote();

        private SingleQuote() {
            super('\'', null);
        }
    }
}

