/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser.messages;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.messages.Message;
import org.kson.parser.messages.MessageKt;
import org.kson.parser.messages.MessageSeverity;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\bO\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002]^B\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010R\u001a\u00020S2\u0016\u0010T\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010V0U\"\u0004\u0018\u00010V\u00a2\u0006\u0002\u0010WJ\u000e\u0010X\u001a\b\u0012\u0004\u0012\u00020V0YH$J\u0010\u0010Z\u001a\u00020V2\u0006\u0010[\u001a\u00020\\H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bPj\u0002\bQ\u00a8\u0006_"}, d2={"Lorg/kson/parser/messages/MessageType;", "", "severity", "Lorg/kson/parser/messages/MessageSeverity;", "<init>", "(Ljava/lang/String;ILorg/kson/parser/messages/MessageSeverity;)V", "getSeverity", "()Lorg/kson/parser/messages/MessageSeverity;", "BLANK_SOURCE", "EMBED_BLOCK_NO_CLOSE", "EMBED_BLOCK_NO_NEWLINE", "EOF_NOT_REACHED", "ONLY_UNEXPECTED_CONTENT", "LIST_NO_CLOSE", "LIST_NO_OPEN", "LIST_INVALID_ELEM", "OBJECT_BAD_INTERNALS", "OBJECT_NO_CLOSE", "OBJECT_NO_OPEN", "OBJECT_KEY_NO_VALUE", "OBJECT_KEYWORD_RESERVED_WORD", "IGNORED_OBJECT_END_DOT", "IGNORED_DASH_LIST_END_DASH", "STRING_NO_CLOSE", "STRING_CONTROL_CHARACTER", "STRING_BAD_UNICODE_ESCAPE", "STRING_BAD_ESCAPE", "INVALID_DIGITS", "DANGLING_EXP_INDICATOR", "ILLEGAL_CHARACTERS", "ILLEGAL_MINUS_SIGN", "DANGLING_DECIMAL", "DANGLING_LIST_DASH", "EMPTY_COMMAS", "MAX_NESTING_LEVEL_EXCEEDED", "INTEGER_OVERFLOW", "SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED", "SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED", "SCHEMA_ANY_OF_VALIDATION_FAILED", "SCHEMA_SUB_SCHEMA_ERRORS", "SCHEMA_ARRAY_REQUIRED", "SCHEMA_BOOLEAN_REQUIRED", "SCHEMA_CONTAINS_VALIDATION_FAILED", "SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED", "SCHEMA_EMPTY_SCHEMA", "SCHEMA_ENUM_VALUE_NOT_ALLOWED", "SCHEMA_FALSE_SCHEMA_ERROR", "SCHEMA_INTEGER_REQUIRED", "SCHEMA_NOT_VALIDATION_FAILED", "SCHEMA_NUMBER_REQUIRED", "SCHEMA_OBJECT_OR_BOOLEAN", "SCHEMA_OBJECT_REQUIRED", "SCHEMA_ONE_OF_VALIDATION_FAILED", "SCHEMA_REQUIRED_PROPERTY_MISSING", "SCHEMA_STRING_ARRAY_ENTRY_ERROR", "SCHEMA_STRING_REQUIRED", "SCHEMA_TYPE_ARRAY_ENTRY_ERROR", "SCHEMA_TYPE_TYPE_ERROR", "SCHEMA_VALUE_MUST_BE_MULTIPLE_OF", "SCHEMA_STRING_LENGTH_TOO_SHORT", "SCHEMA_STRING_LENGTH_TOO_LONG", "SCHEMA_VALUE_TYPE_MISMATCH", "SCHEMA_ARRAY_ITEMS_NOT_UNIQUE", "SCHEMA_VALUE_TOO_LARGE", "SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE", "SCHEMA_VALUE_TOO_SMALL", "SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE", "SCHEMA_VALUE_NOT_EQUAL_TO_CONST", "SCHEMA_ARRAY_TOO_LONG", "SCHEMA_ARRAY_TOO_SHORT", "SCHEMA_OBJECT_TOO_MANY_PROPERTIES", "SCHEMA_OBJECT_TOO_FEW_PROPERTIES", "SCHEMA_STRING_PATTERN_MISMATCH", "SCHEMA_MISSING_REQUIRED_DEPENDENCIES", "OBJECT_PROPERTIES_MISALIGNED", "DASH_LIST_ITEMS_MISALIGNED", "OBJECT_DUPLICATE_KEY", "JSON_POINTER_BAD_START", "JSON_POINTER_INVALID_CHARACTER", "JSON_POINTER_INVALID_ESCAPE", "JSON_POINTER_INCOMPLETE_ESCAPE", "SCHEMA_REF_RESOLUTION_FAILED", "create", "Lorg/kson/parser/messages/Message;", "args", "", "", "([Ljava/lang/String;)Lorg/kson/parser/messages/Message;", "expectedArgs", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "MessageImpl", "ParsedErrorArgs", "kson"})
public abstract class MessageType
extends Enum<MessageType> {
    @NotNull
    private final MessageSeverity severity;
    public static final /* enum */ MessageType BLANK_SOURCE = new BLANK_SOURCE("BLANK_SOURCE", 0);
    public static final /* enum */ MessageType EMBED_BLOCK_NO_CLOSE = new EMBED_BLOCK_NO_CLOSE("EMBED_BLOCK_NO_CLOSE", 1);
    public static final /* enum */ MessageType EMBED_BLOCK_NO_NEWLINE = new EMBED_BLOCK_NO_NEWLINE("EMBED_BLOCK_NO_NEWLINE", 2);
    public static final /* enum */ MessageType EOF_NOT_REACHED = new EOF_NOT_REACHED("EOF_NOT_REACHED", 3);
    public static final /* enum */ MessageType ONLY_UNEXPECTED_CONTENT = new ONLY_UNEXPECTED_CONTENT("ONLY_UNEXPECTED_CONTENT", 4);
    public static final /* enum */ MessageType LIST_NO_CLOSE = new LIST_NO_CLOSE("LIST_NO_CLOSE", 5);
    public static final /* enum */ MessageType LIST_NO_OPEN = new LIST_NO_OPEN("LIST_NO_OPEN", 6);
    public static final /* enum */ MessageType LIST_INVALID_ELEM = new LIST_INVALID_ELEM("LIST_INVALID_ELEM", 7);
    public static final /* enum */ MessageType OBJECT_BAD_INTERNALS = new OBJECT_BAD_INTERNALS("OBJECT_BAD_INTERNALS", 8);
    public static final /* enum */ MessageType OBJECT_NO_CLOSE = new OBJECT_NO_CLOSE("OBJECT_NO_CLOSE", 9);
    public static final /* enum */ MessageType OBJECT_NO_OPEN = new OBJECT_NO_OPEN("OBJECT_NO_OPEN", 10);
    public static final /* enum */ MessageType OBJECT_KEY_NO_VALUE = new OBJECT_KEY_NO_VALUE("OBJECT_KEY_NO_VALUE", 11);
    public static final /* enum */ MessageType OBJECT_KEYWORD_RESERVED_WORD = new OBJECT_KEYWORD_RESERVED_WORD("OBJECT_KEYWORD_RESERVED_WORD", 12);
    public static final /* enum */ MessageType IGNORED_OBJECT_END_DOT = new IGNORED_OBJECT_END_DOT("IGNORED_OBJECT_END_DOT", 13);
    public static final /* enum */ MessageType IGNORED_DASH_LIST_END_DASH = new IGNORED_DASH_LIST_END_DASH("IGNORED_DASH_LIST_END_DASH", 14);
    public static final /* enum */ MessageType STRING_NO_CLOSE = new STRING_NO_CLOSE("STRING_NO_CLOSE", 15);
    public static final /* enum */ MessageType STRING_CONTROL_CHARACTER = new STRING_CONTROL_CHARACTER("STRING_CONTROL_CHARACTER", 16);
    public static final /* enum */ MessageType STRING_BAD_UNICODE_ESCAPE = new STRING_BAD_UNICODE_ESCAPE("STRING_BAD_UNICODE_ESCAPE", 17);
    public static final /* enum */ MessageType STRING_BAD_ESCAPE = new STRING_BAD_ESCAPE("STRING_BAD_ESCAPE", 18);
    public static final /* enum */ MessageType INVALID_DIGITS = new INVALID_DIGITS("INVALID_DIGITS", 19);
    public static final /* enum */ MessageType DANGLING_EXP_INDICATOR = new DANGLING_EXP_INDICATOR("DANGLING_EXP_INDICATOR", 20);
    public static final /* enum */ MessageType ILLEGAL_CHARACTERS = new ILLEGAL_CHARACTERS("ILLEGAL_CHARACTERS", 21);
    public static final /* enum */ MessageType ILLEGAL_MINUS_SIGN = new ILLEGAL_MINUS_SIGN("ILLEGAL_MINUS_SIGN", 22);
    public static final /* enum */ MessageType DANGLING_DECIMAL = new DANGLING_DECIMAL("DANGLING_DECIMAL", 23);
    public static final /* enum */ MessageType DANGLING_LIST_DASH = new DANGLING_LIST_DASH("DANGLING_LIST_DASH", 24);
    public static final /* enum */ MessageType EMPTY_COMMAS = new EMPTY_COMMAS("EMPTY_COMMAS", 25);
    public static final /* enum */ MessageType MAX_NESTING_LEVEL_EXCEEDED = new MAX_NESTING_LEVEL_EXCEEDED("MAX_NESTING_LEVEL_EXCEEDED", 26);
    public static final /* enum */ MessageType INTEGER_OVERFLOW = new INTEGER_OVERFLOW("INTEGER_OVERFLOW", 27);
    public static final /* enum */ MessageType SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED = new SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED("SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED", 28);
    public static final /* enum */ MessageType SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED = new SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED("SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED", 29);
    public static final /* enum */ MessageType SCHEMA_ANY_OF_VALIDATION_FAILED = new SCHEMA_ANY_OF_VALIDATION_FAILED("SCHEMA_ANY_OF_VALIDATION_FAILED", 30);
    public static final /* enum */ MessageType SCHEMA_SUB_SCHEMA_ERRORS = new SCHEMA_SUB_SCHEMA_ERRORS("SCHEMA_SUB_SCHEMA_ERRORS", 31);
    public static final /* enum */ MessageType SCHEMA_ARRAY_REQUIRED = new SCHEMA_ARRAY_REQUIRED("SCHEMA_ARRAY_REQUIRED", 32);
    public static final /* enum */ MessageType SCHEMA_BOOLEAN_REQUIRED = new SCHEMA_BOOLEAN_REQUIRED("SCHEMA_BOOLEAN_REQUIRED", 33);
    public static final /* enum */ MessageType SCHEMA_CONTAINS_VALIDATION_FAILED = new SCHEMA_CONTAINS_VALIDATION_FAILED("SCHEMA_CONTAINS_VALIDATION_FAILED", 34);
    public static final /* enum */ MessageType SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED = new SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED("SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED", 35);
    public static final /* enum */ MessageType SCHEMA_EMPTY_SCHEMA = new SCHEMA_EMPTY_SCHEMA("SCHEMA_EMPTY_SCHEMA", 36);
    public static final /* enum */ MessageType SCHEMA_ENUM_VALUE_NOT_ALLOWED = new SCHEMA_ENUM_VALUE_NOT_ALLOWED("SCHEMA_ENUM_VALUE_NOT_ALLOWED", 37);
    public static final /* enum */ MessageType SCHEMA_FALSE_SCHEMA_ERROR = new SCHEMA_FALSE_SCHEMA_ERROR("SCHEMA_FALSE_SCHEMA_ERROR", 38);
    public static final /* enum */ MessageType SCHEMA_INTEGER_REQUIRED = new SCHEMA_INTEGER_REQUIRED("SCHEMA_INTEGER_REQUIRED", 39);
    public static final /* enum */ MessageType SCHEMA_NOT_VALIDATION_FAILED = new SCHEMA_NOT_VALIDATION_FAILED("SCHEMA_NOT_VALIDATION_FAILED", 40);
    public static final /* enum */ MessageType SCHEMA_NUMBER_REQUIRED = new SCHEMA_NUMBER_REQUIRED("SCHEMA_NUMBER_REQUIRED", 41);
    public static final /* enum */ MessageType SCHEMA_OBJECT_OR_BOOLEAN = new SCHEMA_OBJECT_OR_BOOLEAN("SCHEMA_OBJECT_OR_BOOLEAN", 42);
    public static final /* enum */ MessageType SCHEMA_OBJECT_REQUIRED = new SCHEMA_OBJECT_REQUIRED("SCHEMA_OBJECT_REQUIRED", 43);
    public static final /* enum */ MessageType SCHEMA_ONE_OF_VALIDATION_FAILED = new SCHEMA_ONE_OF_VALIDATION_FAILED("SCHEMA_ONE_OF_VALIDATION_FAILED", 44);
    public static final /* enum */ MessageType SCHEMA_REQUIRED_PROPERTY_MISSING = new SCHEMA_REQUIRED_PROPERTY_MISSING("SCHEMA_REQUIRED_PROPERTY_MISSING", 45);
    public static final /* enum */ MessageType SCHEMA_STRING_ARRAY_ENTRY_ERROR = new SCHEMA_STRING_ARRAY_ENTRY_ERROR("SCHEMA_STRING_ARRAY_ENTRY_ERROR", 46);
    public static final /* enum */ MessageType SCHEMA_STRING_REQUIRED = new SCHEMA_STRING_REQUIRED("SCHEMA_STRING_REQUIRED", 47);
    public static final /* enum */ MessageType SCHEMA_TYPE_ARRAY_ENTRY_ERROR = new SCHEMA_TYPE_ARRAY_ENTRY_ERROR("SCHEMA_TYPE_ARRAY_ENTRY_ERROR", 48);
    public static final /* enum */ MessageType SCHEMA_TYPE_TYPE_ERROR = new SCHEMA_TYPE_TYPE_ERROR("SCHEMA_TYPE_TYPE_ERROR", 49);
    public static final /* enum */ MessageType SCHEMA_VALUE_MUST_BE_MULTIPLE_OF = new SCHEMA_VALUE_MUST_BE_MULTIPLE_OF("SCHEMA_VALUE_MUST_BE_MULTIPLE_OF", 50);
    public static final /* enum */ MessageType SCHEMA_STRING_LENGTH_TOO_SHORT = new SCHEMA_STRING_LENGTH_TOO_SHORT("SCHEMA_STRING_LENGTH_TOO_SHORT", 51);
    public static final /* enum */ MessageType SCHEMA_STRING_LENGTH_TOO_LONG = new SCHEMA_STRING_LENGTH_TOO_LONG("SCHEMA_STRING_LENGTH_TOO_LONG", 52);
    public static final /* enum */ MessageType SCHEMA_VALUE_TYPE_MISMATCH = new SCHEMA_VALUE_TYPE_MISMATCH("SCHEMA_VALUE_TYPE_MISMATCH", 53);
    public static final /* enum */ MessageType SCHEMA_ARRAY_ITEMS_NOT_UNIQUE = new SCHEMA_ARRAY_ITEMS_NOT_UNIQUE("SCHEMA_ARRAY_ITEMS_NOT_UNIQUE", 54);
    public static final /* enum */ MessageType SCHEMA_VALUE_TOO_LARGE = new SCHEMA_VALUE_TOO_LARGE("SCHEMA_VALUE_TOO_LARGE", 55);
    public static final /* enum */ MessageType SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE = new SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE("SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE", 56);
    public static final /* enum */ MessageType SCHEMA_VALUE_TOO_SMALL = new SCHEMA_VALUE_TOO_SMALL("SCHEMA_VALUE_TOO_SMALL", 57);
    public static final /* enum */ MessageType SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE = new SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE("SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE", 58);
    public static final /* enum */ MessageType SCHEMA_VALUE_NOT_EQUAL_TO_CONST = new SCHEMA_VALUE_NOT_EQUAL_TO_CONST("SCHEMA_VALUE_NOT_EQUAL_TO_CONST", 59);
    public static final /* enum */ MessageType SCHEMA_ARRAY_TOO_LONG = new SCHEMA_ARRAY_TOO_LONG("SCHEMA_ARRAY_TOO_LONG", 60);
    public static final /* enum */ MessageType SCHEMA_ARRAY_TOO_SHORT = new SCHEMA_ARRAY_TOO_SHORT("SCHEMA_ARRAY_TOO_SHORT", 61);
    public static final /* enum */ MessageType SCHEMA_OBJECT_TOO_MANY_PROPERTIES = new SCHEMA_OBJECT_TOO_MANY_PROPERTIES("SCHEMA_OBJECT_TOO_MANY_PROPERTIES", 62);
    public static final /* enum */ MessageType SCHEMA_OBJECT_TOO_FEW_PROPERTIES = new SCHEMA_OBJECT_TOO_FEW_PROPERTIES("SCHEMA_OBJECT_TOO_FEW_PROPERTIES", 63);
    public static final /* enum */ MessageType SCHEMA_STRING_PATTERN_MISMATCH = new SCHEMA_STRING_PATTERN_MISMATCH("SCHEMA_STRING_PATTERN_MISMATCH", 64);
    public static final /* enum */ MessageType SCHEMA_MISSING_REQUIRED_DEPENDENCIES = new SCHEMA_MISSING_REQUIRED_DEPENDENCIES("SCHEMA_MISSING_REQUIRED_DEPENDENCIES", 65);
    public static final /* enum */ MessageType OBJECT_PROPERTIES_MISALIGNED = new OBJECT_PROPERTIES_MISALIGNED("OBJECT_PROPERTIES_MISALIGNED", 66);
    public static final /* enum */ MessageType DASH_LIST_ITEMS_MISALIGNED = new DASH_LIST_ITEMS_MISALIGNED("DASH_LIST_ITEMS_MISALIGNED", 67);
    public static final /* enum */ MessageType OBJECT_DUPLICATE_KEY = new OBJECT_DUPLICATE_KEY("OBJECT_DUPLICATE_KEY", 68);
    public static final /* enum */ MessageType JSON_POINTER_BAD_START = new JSON_POINTER_BAD_START("JSON_POINTER_BAD_START", 69);
    public static final /* enum */ MessageType JSON_POINTER_INVALID_CHARACTER = new JSON_POINTER_INVALID_CHARACTER("JSON_POINTER_INVALID_CHARACTER", 70);
    public static final /* enum */ MessageType JSON_POINTER_INVALID_ESCAPE = new JSON_POINTER_INVALID_ESCAPE("JSON_POINTER_INVALID_ESCAPE", 71);
    public static final /* enum */ MessageType JSON_POINTER_INCOMPLETE_ESCAPE = new JSON_POINTER_INCOMPLETE_ESCAPE("JSON_POINTER_INCOMPLETE_ESCAPE", 72);
    public static final /* enum */ MessageType SCHEMA_REF_RESOLUTION_FAILED = new SCHEMA_REF_RESOLUTION_FAILED("SCHEMA_REF_RESOLUTION_FAILED", 73);
    private static final /* synthetic */ MessageType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private MessageType(MessageSeverity severity) {
        this.severity = severity;
    }

    /* synthetic */ MessageType(String string, int n, MessageSeverity messageSeverity, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            messageSeverity = MessageSeverity.ERROR;
        }
        this(messageSeverity);
    }

    @NotNull
    public final MessageSeverity getSeverity() {
        return this.severity;
    }

    @NotNull
    public final Message create(String ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ArrayList<String> givenArgs = new ArrayList<String>();
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            String value = args[i];
            if (value == null) {
                throw new IllegalArgumentException("Illegal `null` arg at position " + index + " of the given `args`.  Message arguments must not be `null`.");
            }
            givenArgs.add(value);
        }
        List<String> expectedArgs = this.expectedArgs();
        int numExpectedArgs = expectedArgs.size();
        if (givenArgs.size() != numExpectedArgs) {
            throw new RuntimeException("`" + Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getSimpleName() + ".create` requires " + numExpectedArgs + " arg(s) for: " + MessageKt.access$renderArgList(expectedArgs, "`") + ", but got " + givenArgs.size() + ": " + MessageKt.renderArgList$default(givenArgs, null, 2, null));
        }
        return new MessageImpl(this, this.doFormat(new ParsedErrorArgs(this, (List<String>)givenArgs)));
    }

    @NotNull
    protected abstract List<String> expectedArgs();

    @NotNull
    protected abstract String doFormat(@NotNull ParsedErrorArgs var1);

    public static MessageType[] values() {
        return (MessageType[])$VALUES.clone();
    }

    public static MessageType valueOf(String value) {
        return Enum.valueOf(MessageType.class, value);
    }

    @NotNull
    public static EnumEntries<MessageType> getEntries() {
        return $ENTRIES;
    }

    public /* synthetic */ MessageType(String $enum$name, int $enum$ordinal, MessageSeverity severity, DefaultConstructorMarker $constructor_marker) {
        this(severity);
    }

    static {
        $VALUES = messageTypeArray = new MessageType[]{MessageType.BLANK_SOURCE, MessageType.EMBED_BLOCK_NO_CLOSE, MessageType.EMBED_BLOCK_NO_NEWLINE, MessageType.EOF_NOT_REACHED, MessageType.ONLY_UNEXPECTED_CONTENT, MessageType.LIST_NO_CLOSE, MessageType.LIST_NO_OPEN, MessageType.LIST_INVALID_ELEM, MessageType.OBJECT_BAD_INTERNALS, MessageType.OBJECT_NO_CLOSE, MessageType.OBJECT_NO_OPEN, MessageType.OBJECT_KEY_NO_VALUE, MessageType.OBJECT_KEYWORD_RESERVED_WORD, MessageType.IGNORED_OBJECT_END_DOT, MessageType.IGNORED_DASH_LIST_END_DASH, MessageType.STRING_NO_CLOSE, MessageType.STRING_CONTROL_CHARACTER, MessageType.STRING_BAD_UNICODE_ESCAPE, MessageType.STRING_BAD_ESCAPE, MessageType.INVALID_DIGITS, MessageType.DANGLING_EXP_INDICATOR, MessageType.ILLEGAL_CHARACTERS, MessageType.ILLEGAL_MINUS_SIGN, MessageType.DANGLING_DECIMAL, MessageType.DANGLING_LIST_DASH, MessageType.EMPTY_COMMAS, MessageType.MAX_NESTING_LEVEL_EXCEEDED, MessageType.INTEGER_OVERFLOW, MessageType.SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED, MessageType.SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED, MessageType.SCHEMA_ANY_OF_VALIDATION_FAILED, MessageType.SCHEMA_SUB_SCHEMA_ERRORS, MessageType.SCHEMA_ARRAY_REQUIRED, MessageType.SCHEMA_BOOLEAN_REQUIRED, MessageType.SCHEMA_CONTAINS_VALIDATION_FAILED, MessageType.SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED, MessageType.SCHEMA_EMPTY_SCHEMA, MessageType.SCHEMA_ENUM_VALUE_NOT_ALLOWED, MessageType.SCHEMA_FALSE_SCHEMA_ERROR, MessageType.SCHEMA_INTEGER_REQUIRED, MessageType.SCHEMA_NOT_VALIDATION_FAILED, MessageType.SCHEMA_NUMBER_REQUIRED, MessageType.SCHEMA_OBJECT_OR_BOOLEAN, MessageType.SCHEMA_OBJECT_REQUIRED, MessageType.SCHEMA_ONE_OF_VALIDATION_FAILED, MessageType.SCHEMA_REQUIRED_PROPERTY_MISSING, MessageType.SCHEMA_STRING_ARRAY_ENTRY_ERROR, MessageType.SCHEMA_STRING_REQUIRED, MessageType.SCHEMA_TYPE_ARRAY_ENTRY_ERROR, MessageType.SCHEMA_TYPE_TYPE_ERROR, MessageType.SCHEMA_VALUE_MUST_BE_MULTIPLE_OF, MessageType.SCHEMA_STRING_LENGTH_TOO_SHORT, MessageType.SCHEMA_STRING_LENGTH_TOO_LONG, MessageType.SCHEMA_VALUE_TYPE_MISMATCH, MessageType.SCHEMA_ARRAY_ITEMS_NOT_UNIQUE, MessageType.SCHEMA_VALUE_TOO_LARGE, MessageType.SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE, MessageType.SCHEMA_VALUE_TOO_SMALL, MessageType.SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE, MessageType.SCHEMA_VALUE_NOT_EQUAL_TO_CONST, MessageType.SCHEMA_ARRAY_TOO_LONG, MessageType.SCHEMA_ARRAY_TOO_SHORT, MessageType.SCHEMA_OBJECT_TOO_MANY_PROPERTIES, MessageType.SCHEMA_OBJECT_TOO_FEW_PROPERTIES, MessageType.SCHEMA_STRING_PATTERN_MISMATCH, MessageType.SCHEMA_MISSING_REQUIRED_DEPENDENCIES, MessageType.OBJECT_PROPERTIES_MISALIGNED, MessageType.DASH_LIST_ITEMS_MISALIGNED, MessageType.OBJECT_DUPLICATE_KEY, MessageType.JSON_POINTER_BAD_START, MessageType.JSON_POINTER_INVALID_CHARACTER, MessageType.JSON_POINTER_INVALID_ESCAPE, MessageType.JSON_POINTER_INCOMPLETE_ESCAPE, MessageType.SCHEMA_REF_RESOLUTION_FAILED};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.BLANK_SOURCE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class BLANK_SOURCE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        BLANK_SOURCE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unable to parse a blank file.  A Kson document must describe a value.";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.DANGLING_DECIMAL", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class DANGLING_DECIMAL
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        DANGLING_DECIMAL() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "A decimal must be followed by digits";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.DANGLING_EXP_INDICATOR", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class DANGLING_EXP_INDICATOR
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        DANGLING_EXP_INDICATOR() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Exponent character: E or e");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String exponentCharacter = parsedArgs.getArg("Exponent character: E or e");
            return "Dangling exponent error: `" + exponentCharacter + "` must be followed by an exponent";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.DANGLING_LIST_DASH", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class DANGLING_LIST_DASH
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        DANGLING_LIST_DASH() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "A list dash `- ` must be followed by a value";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.DASH_LIST_ITEMS_MISALIGNED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class DASH_LIST_ITEMS_MISALIGNED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        DASH_LIST_ITEMS_MISALIGNED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Deceptive indentation. This list item's indentation must properly reflect its nesting. Reformat or fix nesting with end-dashes `=` or delimiters `<>`";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.EMBED_BLOCK_NO_CLOSE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class EMBED_BLOCK_NO_CLOSE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        EMBED_BLOCK_NO_CLOSE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Embed delimiter");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String embedDelimiter = parsedArgs.getArg("Embed delimiter");
            return "Unclosed \"" + embedDelimiter + "\"";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.EMBED_BLOCK_NO_NEWLINE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class EMBED_BLOCK_NO_NEWLINE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        EMBED_BLOCK_NO_NEWLINE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            Object[] objectArray = new String[]{"Embed delimiter", "Embed tag"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String embedDelimiter = parsedArgs.getArg("Embed delimiter");
            String embedTag = parsedArgs.getArg("Embed tag");
            return "Embedded content starts on the first line after the \"" + embedDelimiter + "<embed tag>\" construct, so this \"" + embedDelimiter + "\" cannot be on be on the same line as the opening \"" + embedDelimiter + embedTag + "\"";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.EMPTY_COMMAS", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class EMPTY_COMMAS
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        EMPTY_COMMAS() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Redundant comma found. A comma must delimit a value, one comma per value";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.EOF_NOT_REACHED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class EOF_NOT_REACHED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        EOF_NOT_REACHED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unexpected trailing content. The previous content parsed as a complete Kson document.";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.IGNORED_DASH_LIST_END_DASH", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class IGNORED_DASH_LIST_END_DASH
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        IGNORED_DASH_LIST_END_DASH() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "This end-dash is ignored because this list is `<>`-delimited. End-dashes only effect non-delimited dashed lists";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.IGNORED_OBJECT_END_DOT", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class IGNORED_OBJECT_END_DOT
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        IGNORED_OBJECT_END_DOT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "This end-dot is ignored because this object is `{}`-delimited. End-dots only effect non-delimited objects";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.ILLEGAL_CHARACTERS", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class ILLEGAL_CHARACTERS
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        ILLEGAL_CHARACTERS() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"The Illegal Characters");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String illegalCharacter = parsedArgs.getArg("The Illegal Characters");
            return "Kson does not allow \"" + illegalCharacter + "\" here";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.ILLEGAL_MINUS_SIGN", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class ILLEGAL_MINUS_SIGN
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        ILLEGAL_MINUS_SIGN() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "A dash `-` must be followed by a space (to make a list element), or a number (to make a negative number)";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.INTEGER_OVERFLOW", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class INTEGER_OVERFLOW
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        INTEGER_OVERFLOW() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Overflow Number");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String overflowNumber = parsedArgs.getArg("Overflow Number");
            return "The integer \"" + overflowNumber + "\" is too large and cannot be represented.";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.INVALID_DIGITS", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class INVALID_DIGITS
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        INVALID_DIGITS() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Unexpected Character");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String unexpectedCharacter = parsedArgs.getArg("Unexpected Character");
            return "Invalid character `" + unexpectedCharacter + "` found in this number";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.JSON_POINTER_BAD_START", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class JSON_POINTER_BAD_START
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        JSON_POINTER_BAD_START() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Bad Start Character");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String badStartChar = parsedArgs.getArg("Bad Start Character");
            return "JSON Pointer must start with '/' but found '" + badStartChar + "' at position 0";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.JSON_POINTER_INCOMPLETE_ESCAPE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class JSON_POINTER_INCOMPLETE_ESCAPE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        JSON_POINTER_INCOMPLETE_ESCAPE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Incomplete escape sequence '~' at end of token. Must be '~0' or '~1'. ";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.JSON_POINTER_INVALID_CHARACTER", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class JSON_POINTER_INVALID_CHARACTER
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        JSON_POINTER_INVALID_CHARACTER() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Invalid Character");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String invalidChar = parsedArgs.getArg("Invalid Character");
            return "Invalid character in reference token: '" + invalidChar + "'";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.JSON_POINTER_INVALID_ESCAPE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class JSON_POINTER_INVALID_ESCAPE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        JSON_POINTER_INVALID_ESCAPE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Invalid Escape Character");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String invalidEscapeChar = parsedArgs.getArg("Invalid Escape Character");
            return "Invalid escape sequence: '~" + invalidEscapeChar + "'. Valid escape sequences are '~0' for '~' and '~1' for '/'";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.LIST_INVALID_ELEM", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class LIST_INVALID_ELEM
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        LIST_INVALID_ELEM() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unable to parse this list element as a legal Kson value";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.LIST_NO_CLOSE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class LIST_NO_CLOSE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        LIST_NO_CLOSE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unclosed list";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.LIST_NO_OPEN", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class LIST_NO_OPEN
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        LIST_NO_OPEN() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "This must close a list, but this is not a list";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.MAX_NESTING_LEVEL_EXCEEDED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class MAX_NESTING_LEVEL_EXCEEDED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        MAX_NESTING_LEVEL_EXCEEDED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Max Nesting Level");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String maxNestingLevel = parsedArgs.getArg("Max Nesting Level");
            return "The nesting of objects and/or lists in this Kson exceeds the configured maximum supported nesting level of " + maxNestingLevel;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0005H\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kson/parser/messages/MessageType$MessageImpl;", "Lorg/kson/parser/messages/Message;", "type", "Lorg/kson/parser/messages/MessageType;", "renderedMessage", "", "<init>", "(Lorg/kson/parser/messages/MessageType;Ljava/lang/String;)V", "getType", "()Lorg/kson/parser/messages/MessageType;", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "kson"})
    public static final class MessageImpl
    implements Message {
        @NotNull
        private final MessageType type;
        @NotNull
        private final String renderedMessage;

        public MessageImpl(@NotNull MessageType type, @NotNull String renderedMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)renderedMessage, (String)"renderedMessage");
            this.type = type;
            this.renderedMessage = renderedMessage;
        }

        @Override
        @NotNull
        public MessageType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String toString() {
            return this.renderedMessage;
        }

        @NotNull
        public final MessageType component1() {
            return this.type;
        }

        private final String component2() {
            return this.renderedMessage;
        }

        @NotNull
        public final MessageImpl copy(@NotNull MessageType type, @NotNull String renderedMessage) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)renderedMessage, (String)"renderedMessage");
            return new MessageImpl(type, renderedMessage);
        }

        public static /* synthetic */ MessageImpl copy$default(MessageImpl messageImpl, MessageType messageType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                messageType = messageImpl.type;
            }
            if ((n & 2) != 0) {
                string = messageImpl.renderedMessage;
            }
            return messageImpl.copy(messageType, string);
        }

        @Override
        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.renderedMessage.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageImpl)) {
                return false;
            }
            MessageImpl messageImpl = (MessageImpl)other;
            if (this.type != messageImpl.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.renderedMessage, (Object)messageImpl.renderedMessage);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_BAD_INTERNALS", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_BAD_INTERNALS
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_BAD_INTERNALS() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Object properties must be `key: value` pairs";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_DUPLICATE_KEY", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_DUPLICATE_KEY
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_DUPLICATE_KEY() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Key name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String keyName = parsedArgs.getArg("Key name");
            return "Duplicate key \"" + keyName + "\" in object";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_KEYWORD_RESERVED_WORD", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_KEYWORD_RESERVED_WORD
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_KEYWORD_RESERVED_WORD() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Reserved Word");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String reservedWord = parsedArgs.getArg("Reserved Word");
            return "`" + reservedWord + "` cannot be used as an object key";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_KEY_NO_VALUE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_KEY_NO_VALUE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_KEY_NO_VALUE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "This object key must be followed by a value";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_NO_CLOSE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_NO_CLOSE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_NO_CLOSE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unclosed object";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_NO_OPEN", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_NO_OPEN
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_NO_OPEN() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "This must close an object, but this is not an object";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.OBJECT_PROPERTIES_MISALIGNED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class OBJECT_PROPERTIES_MISALIGNED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        OBJECT_PROPERTIES_MISALIGNED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Deceptive indentation. This property's indentation must properly reflect its nesting. Reformat or fix nesting with end-dots `.` or delimiters `{}`";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.ONLY_UNEXPECTED_CONTENT", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class ONLY_UNEXPECTED_CONTENT
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        ONLY_UNEXPECTED_CONTENT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unexpected content. No content can be parsed as a Kson document.";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "", "messageType", "Lorg/kson/parser/messages/MessageType;", "args", "", "", "<init>", "(Lorg/kson/parser/messages/MessageType;Ljava/util/List;)V", "parsedArgs", "", "getArg", "argName", "kson"})
    protected static final class ParsedErrorArgs {
        @NotNull
        private final MessageType messageType;
        @NotNull
        private final Map<String, String> parsedArgs;

        public ParsedErrorArgs(@NotNull MessageType messageType, @NotNull List<String> args) {
            Intrinsics.checkNotNullParameter((Object)((Object)messageType), (String)"messageType");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.messageType = messageType;
            this.parsedArgs = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.messageType.expectedArgs(), (Iterable)args));
        }

        @Nullable
        public final String getArg(@NotNull String argName) {
            Intrinsics.checkNotNullParameter((Object)argName, (String)"argName");
            if (this.parsedArgs.get(argName) != null) {
                return this.parsedArgs.get(argName);
            }
            throw new IllegalArgumentException("Invalid arg name \"" + argName + "\" given for " + Reflection.getOrCreateKotlinClass(((Object)((Object)this.messageType)).getClass()).getSimpleName() + ".  \"" + argName + "\" is not defined in " + "expectedArgs" + ": " + MessageKt.renderArgList$default(this.messageType.expectedArgs(), null, 2, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ADDITIONAL_ITEMS_NOT_ALLOWED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Additional items are not allowed";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ADDITIONAL_PROPERTIES_NOT_ALLOWED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Additional properties are not allowed";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ANY_OF_VALIDATION_FAILED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ANY_OF_VALIDATION_FAILED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ANY_OF_VALIDATION_FAILED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Value must match at least one sub-schema";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ARRAY_ITEMS_NOT_UNIQUE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ARRAY_ITEMS_NOT_UNIQUE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ARRAY_ITEMS_NOT_UNIQUE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Items in this array must be unique";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ARRAY_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ARRAY_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ARRAY_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema property \"" + schemaPropertyName + "\" must be an array";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ARRAY_TOO_LONG", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ARRAY_TOO_LONG
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ARRAY_TOO_LONG() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Maximum Items");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String maxItems = parsedArgs.getArg("Maximum Items");
            return "Array length must be <= " + maxItems;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ARRAY_TOO_SHORT", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ARRAY_TOO_SHORT
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ARRAY_TOO_SHORT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Minimum Items");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String minItems = parsedArgs.getArg("Minimum Items");
            return "Array length must be >= " + minItems;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_BOOLEAN_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_BOOLEAN_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_BOOLEAN_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema property \"" + schemaPropertyName + "\" must be true or false";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_CONTAINS_VALIDATION_FAILED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_CONTAINS_VALIDATION_FAILED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_CONTAINS_VALIDATION_FAILED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Array must contain at least one item that matches the contains schema";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_DEPENDENCIES_ARRAY_STRING_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Property names in a \"dependencies\" list must be strings";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_EMPTY_SCHEMA", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_EMPTY_SCHEMA
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_EMPTY_SCHEMA() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Schema must not be empty";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ENUM_VALUE_NOT_ALLOWED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ENUM_VALUE_NOT_ALLOWED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ENUM_VALUE_NOT_ALLOWED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Value is not one of the allowed enum values";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_FALSE_SCHEMA_ERROR", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_FALSE_SCHEMA_ERROR
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_FALSE_SCHEMA_ERROR() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Schema always fails";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_INTEGER_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_INTEGER_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_INTEGER_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema property \"" + schemaPropertyName + "\" must be an integer";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_MISSING_REQUIRED_DEPENDENCIES", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_MISSING_REQUIRED_DEPENDENCIES
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_MISSING_REQUIRED_DEPENDENCIES() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            Object[] objectArray = new String[]{"Required by", "Missing property"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String requiredBy = parsedArgs.getArg("Required by");
            String missingProperty = parsedArgs.getArg("Missing property");
            return "Property `" + missingProperty + "' is not provided, but it is required by '" + requiredBy + "'";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_NOT_VALIDATION_FAILED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_NOT_VALIDATION_FAILED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_NOT_VALIDATION_FAILED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Value must not match the specified schema";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_NUMBER_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_NUMBER_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_NUMBER_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema property \"" + schemaPropertyName + "\" must be a number";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_OBJECT_OR_BOOLEAN", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_OBJECT_OR_BOOLEAN
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_OBJECT_OR_BOOLEAN() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Schema must be an object or boolean";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_OBJECT_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_OBJECT_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_OBJECT_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema property \"" + schemaPropertyName + "\" must be an object";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_OBJECT_TOO_FEW_PROPERTIES", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_OBJECT_TOO_FEW_PROPERTIES
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_OBJECT_TOO_FEW_PROPERTIES() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Minimum Properties");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String minProperties = parsedArgs.getArg("Minimum Properties");
            return "Object must have >= " + minProperties + " properties";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_OBJECT_TOO_MANY_PROPERTIES", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_OBJECT_TOO_MANY_PROPERTIES
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_OBJECT_TOO_MANY_PROPERTIES() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Maximum Properties");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String maxProperties = parsedArgs.getArg("Maximum Properties");
            return "Object must have <= " + maxProperties + " properties";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_ONE_OF_VALIDATION_FAILED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_ONE_OF_VALIDATION_FAILED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_ONE_OF_VALIDATION_FAILED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Value must match exactly one of the specified schemas";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_REF_RESOLUTION_FAILED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_REF_RESOLUTION_FAILED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_REF_RESOLUTION_FAILED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Reference");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String reference = parsedArgs.getArg("Reference");
            return "Failed to resolve schema reference: " + reference;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_REQUIRED_PROPERTY_MISSING", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_REQUIRED_PROPERTY_MISSING
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_REQUIRED_PROPERTY_MISSING() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Missing Properties");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String missingProperties = parsedArgs.getArg("Missing Properties");
            return "Missing required properties: " + missingProperties;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_STRING_ARRAY_ENTRY_ERROR", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_STRING_ARRAY_ENTRY_ERROR
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_STRING_ARRAY_ENTRY_ERROR() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema \"" + schemaPropertyName + "\" array entries must be a strings";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_STRING_LENGTH_TOO_LONG", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_STRING_LENGTH_TOO_LONG
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_STRING_LENGTH_TOO_LONG() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Maximum Length");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String maxLength = parsedArgs.getArg("Maximum Length");
            return "String length must be <= " + maxLength;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_STRING_LENGTH_TOO_SHORT", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_STRING_LENGTH_TOO_SHORT
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_STRING_LENGTH_TOO_SHORT() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Minimum Length");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String minLength = parsedArgs.getArg("Minimum Length");
            return "String length must be >= " + minLength;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_STRING_PATTERN_MISMATCH", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_STRING_PATTERN_MISMATCH
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_STRING_PATTERN_MISMATCH() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Pattern");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String pattern = parsedArgs.getArg("Pattern");
            return "String must match pattern: " + pattern;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_STRING_REQUIRED", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_STRING_REQUIRED
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_STRING_REQUIRED() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Schema Property Name");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String schemaPropertyName = parsedArgs.getArg("Schema Property Name");
            return "Schema property \"" + schemaPropertyName + "\" must be a string";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_SUB_SCHEMA_ERRORS", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_SUB_SCHEMA_ERRORS
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_SUB_SCHEMA_ERRORS() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Sub-schema error summary");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String subSchemaErrors = parsedArgs.getArg("Sub-schema error summary");
            return "All sub-schemas reported validation errors. " + subSchemaErrors;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_TYPE_ARRAY_ENTRY_ERROR", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_TYPE_ARRAY_ENTRY_ERROR
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_TYPE_ARRAY_ENTRY_ERROR() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Schema \"type\" array entries must be a strings";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_TYPE_TYPE_ERROR", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_TYPE_TYPE_ERROR
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_TYPE_TYPE_ERROR() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Schema \"type\" must be a string or array of strings";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_MUST_BE_MULTIPLE_OF", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_MUST_BE_MULTIPLE_OF
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_MUST_BE_MULTIPLE_OF() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Multiple Of Value");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String multipleOfValue = parsedArgs.getArg("Multiple Of Value");
            return "Value must be multiple of " + multipleOfValue;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_NOT_EQUAL_TO_CONST", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_NOT_EQUAL_TO_CONST
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_NOT_EQUAL_TO_CONST() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Value must be exactly equal to const value";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_TOO_LARGE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_TOO_LARGE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_TOO_LARGE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Maximum Value");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String maximum = parsedArgs.getArg("Maximum Value");
            return "Value must be <= " + maximum;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_TOO_LARGE_EXCLUSIVE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Exclusive Maximum Value");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String exclusiveMaximum = parsedArgs.getArg("Exclusive Maximum Value");
            return "Value must be < " + exclusiveMaximum;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_TOO_SMALL", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_TOO_SMALL
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_TOO_SMALL() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Minimum Value");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String minimum = parsedArgs.getArg("Minimum Value");
            return "Value must be >= " + minimum;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_TOO_SMALL_EXCLUSIVE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Exclusive Minimum Value");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String exclusiveMinimum = parsedArgs.getArg("Exclusive Minimum Value");
            return "Value must be > " + exclusiveMinimum;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.SCHEMA_VALUE_TYPE_MISMATCH", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class SCHEMA_VALUE_TYPE_MISMATCH
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        SCHEMA_VALUE_TYPE_MISMATCH() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            Object[] objectArray = new String[]{"Expected Types", "Actual Type"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String expectedTypes = parsedArgs.getArg("Expected Types");
            String actualType = parsedArgs.getArg("Actual Type");
            return "Expected one of: " + expectedTypes + ", but got: " + actualType;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.STRING_BAD_ESCAPE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class STRING_BAD_ESCAPE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        STRING_BAD_ESCAPE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"\\-prefixed String Escape");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String badStringEscape = parsedArgs.getArg("\\-prefixed String Escape");
            return "Invalid string escape: " + badStringEscape;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.STRING_BAD_UNICODE_ESCAPE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class STRING_BAD_UNICODE_ESCAPE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        STRING_BAD_UNICODE_ESCAPE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Unicode `\\uXXXX` Escape");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String badUnicodeEscape = parsedArgs.getArg("Unicode `\\uXXXX` Escape");
            return "Invalid Unicode code point: " + badUnicodeEscape + ".  Must be a 4 digit hex number";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.STRING_CONTROL_CHARACTER", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class STRING_CONTROL_CHARACTER
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        STRING_CONTROL_CHARACTER() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.listOf((Object)"Control Character");
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            String badControlCharArg;
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            String string = badControlCharArg = parsedArgs.getArg("Control Character");
            if (!(string != null ? string.length() == 1 : false)) {
                throw new IllegalArgumentException("Expected arg to be a single control character");
            }
            char badControlChar = badControlCharArg.charAt(0);
            return "Non-whitespace control characters must not be embedded directly in strings. Please use the Unicode escape for this character instead: \"\\u" + StringsKt.padStart((String)String.valueOf((int)badControlChar), (int)4, (char)'0') + "\"";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"org/kson/parser/messages/MessageType.STRING_NO_CLOSE", "Lorg/kson/parser/messages/MessageType;", "expectedArgs", "", "", "doFormat", "parsedArgs", "Lorg/kson/parser/messages/MessageType$ParsedErrorArgs;", "kson"})
    static final class STRING_NO_CLOSE
    extends MessageType {
        /*
         * WARNING - void declaration
         */
        STRING_NO_CLOSE() {
            void var1_1;
        }

        @Override
        @NotNull
        protected List<String> expectedArgs() {
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        protected String doFormat(@NotNull ParsedErrorArgs parsedArgs) {
            Intrinsics.checkNotNullParameter((Object)parsedArgs, (String)"parsedArgs");
            return "Unclosed string";
        }
    }
}

