/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.KsonNumber;
import org.kson.parser.NumberParser;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"asSchemaInteger", "", "ksonNumber", "Lorg/kson/KsonNumber;", "(Lorg/kson/KsonNumber;)Ljava/lang/Long;", "allZerosDecimalRegex", "Lkotlin/text/Regex;", "kson"})
public final class JsonSchemaKt {
    @NotNull
    private static final Regex allZerosDecimalRegex = new Regex(".*\\.0*");

    @Nullable
    public static final Long asSchemaInteger(@NotNull KsonNumber ksonNumber) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)ksonNumber, (String)"ksonNumber");
        NumberParser.ParsedNumber parsedNumber = ksonNumber.getValue();
        if (parsedNumber instanceof NumberParser.ParsedNumber.Integer) {
            l = ((NumberParser.ParsedNumber.Integer)ksonNumber.getValue()).getValue();
        } else if (parsedNumber instanceof NumberParser.ParsedNumber.Decimal) {
            CharSequence charSequence = ((NumberParser.ParsedNumber.Decimal)ksonNumber.getValue()).getAsString();
            l = allZerosDecimalRegex.matches(charSequence) ? Long.valueOf((long)((NumberParser.ParsedNumber.Decimal)ksonNumber.getValue()).getValue()) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }
}

