/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.kson.KsonList;
import org.kson.KsonObject;
import org.kson.KsonString;
import org.kson.KsonValue;
import org.kson.schema.JsonPointerParser;
import org.kson.schema.ResolvedRef;
import org.kson.schema.SchemaIdLookup;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a(\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a8\u0006\r"}, d2={"decodeUriEncoding", "", "encoded", "resolveJsonPointer", "Lorg/kson/schema/ResolvedRef;", "pointer", "ksonValue", "Lorg/kson/KsonValue;", "currentBaseUri", "navigatePointer", "current", "tokens", "", "kson"})
@SourceDebugExtension(value={"SMAP\nSchemaIdLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaIdLookup.kt\norg/kson/schema/SchemaIdLookupKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,543:1\n1#2:544\n*E\n"})
public final class SchemaIdLookupKt {
    private static final String decodeUriEncoding(String encoded) {
        if (!StringsKt.contains$default((CharSequence)encoded, (char)'%', (boolean)false, (int)2, null)) {
            return encoded;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < encoded.length()) {
            char c = encoded.charAt(i);
            if (c == '%' && i + 2 < encoded.length()) {
                char c2;
                Intrinsics.checkNotNullExpressionValue((Object)encoded.substring(i + 1, i + 3), (String)"substring(...)");
                try {
                    String hex;
                    c2 = (char)Integer.parseInt(hex, CharsKt.checkRadix((int)16));
                }
                catch (NumberFormatException e) {
                    result.append(c);
                    ++i;
                    continue;
                }
                char decoded = c2;
                result.append(decoded);
                i += 3;
                continue;
            }
            result.append(c);
            ++i;
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final ResolvedRef resolveJsonPointer(String pointer, KsonValue ksonValue, String currentBaseUri) {
        ResolvedRef resolvedRef;
        JsonPointerParser.ParseResult parseResult = new JsonPointerParser(pointer).parse();
        if (parseResult instanceof JsonPointerParser.ParseResult.Success) {
            resolvedRef = SchemaIdLookupKt.navigatePointer(ksonValue, ((JsonPointerParser.ParseResult.Success)parseResult).getTokens(), currentBaseUri);
        } else if (parseResult instanceof JsonPointerParser.ParseResult.Error) {
            resolvedRef = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resolvedRef;
    }

    private static final ResolvedRef navigatePointer(KsonValue current, List<String> tokens, String currentBaseUri) {
        ResolvedRef resolvedRef;
        if (tokens.isEmpty()) {
            return new ResolvedRef(current, currentBaseUri);
        }
        KsonValue node = current;
        String updatedBaseUri = null;
        updatedBaseUri = currentBaseUri;
        for (String token : tokens) {
            KsonValue ksonValue;
            KsonValue ksonValue2 = node;
            if (ksonValue2 instanceof KsonObject) {
                if (((KsonObject)node).getPropertyLookup().get("$id") != null) {
                    KsonValue idValue;
                    boolean bl = false;
                    if (idValue instanceof KsonString) {
                        String idString = ((KsonString)idValue).getValue();
                        SchemaIdLookup.Companion.RefUriParts fullyQualifiedId = SchemaIdLookup.Companion.resolveUri(idString, updatedBaseUri);
                        updatedBaseUri = fullyQualifiedId.toString();
                    }
                }
                ksonValue = ((KsonObject)node).getPropertyLookup().get(token);
            } else {
                Integer index;
                ksonValue = ksonValue2 instanceof KsonList ? ((index = StringsKt.toIntOrNull((String)token)) != null && index >= 0 && index < ((KsonList)node).getElements().size() ? ((KsonList)node).getElements().get(index) : null) : null;
            }
            if ((node = ksonValue) != null) continue;
        }
        KsonValue ksonValue = node;
        if (ksonValue != null) {
            KsonValue it = ksonValue;
            boolean bl = false;
            resolvedRef = new ResolvedRef(it, updatedBaseUri);
        } else {
            resolvedRef = null;
        }
        return resolvedRef;
    }

    public static final /* synthetic */ String access$decodeUriEncoding(String encoded) {
        return SchemaIdLookupKt.decodeUriEncoding(encoded);
    }

    public static final /* synthetic */ ResolvedRef access$resolveJsonPointer(String pointer, KsonValue ksonValue, String currentBaseUri) {
        return SchemaIdLookupKt.resolveJsonPointer(pointer, ksonValue, currentBaseUri);
    }
}

