/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.KsonNumber;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;
import org.kson.schema.JsonNumberValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kson/schema/validators/MultipleOfValidator;", "Lorg/kson/schema/JsonNumberValidator;", "multipleOf", "", "<init>", "(D)V", "validateNumber", "", "node", "Lorg/kson/KsonNumber;", "messageSink", "Lorg/kson/parser/MessageSink;", "kson"})
public final class MultipleOfValidator
extends JsonNumberValidator {
    private final double multipleOf;

    public MultipleOfValidator(double multipleOf) {
        this.multipleOf = multipleOf;
    }

    @Override
    public void validateNumber(@NotNull KsonNumber node, @NotNull MessageSink messageSink) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        double number = node.getValue().getAsDouble();
        if (!(this.multipleOf == 0.0)) {
            double remainder = number % this.multipleOf;
            double epsilon = 1.0E-10 * Math.max(Math.abs(number), Math.abs(this.multipleOf));
            if (Math.abs(remainder) > epsilon && Math.abs(remainder - this.multipleOf) > epsilon) {
                String[] stringArray = new String[]{String.valueOf(this.multipleOf)};
                messageSink.error(node.getLocation(), MessageType.SCHEMA_VALUE_MUST_BE_MULTIPLE_OF.create(stringArray));
            }
        }
    }
}

