/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.kson.KsonValue;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;
import org.kson.schema.JsonSchema;
import org.kson.schema.JsonSchemaValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kson/schema/validators/OneOfValidator;", "Lorg/kson/schema/JsonSchemaValidator;", "oneOf", "", "Lorg/kson/schema/JsonSchema;", "<init>", "(Ljava/util/List;)V", "validate", "", "ksonValue", "Lorg/kson/KsonValue;", "messageSink", "Lorg/kson/parser/MessageSink;", "kson"})
@SourceDebugExtension(value={"SMAP\nOneOfValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OneOfValidator.kt\norg/kson/schema/validators/OneOfValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,21:1\n1788#2,4:22\n*S KotlinDebug\n*F\n+ 1 OneOfValidator.kt\norg/kson/schema/validators/OneOfValidator\n*L\n11#1:22,4\n*E\n"})
public final class OneOfValidator
implements JsonSchemaValidator {
    @NotNull
    private final List<JsonSchema> oneOf;

    public OneOfValidator(@NotNull List<? extends JsonSchema> oneOf) {
        Intrinsics.checkNotNullParameter(oneOf, (String)"oneOf");
        this.oneOf = oneOf;
    }

    @Override
    public void validate(@NotNull KsonValue ksonValue, @NotNull MessageSink messageSink) {
        boolean hasExactlyOneOf;
        int n;
        Intrinsics.checkNotNullParameter((Object)ksonValue, (String)"ksonValue");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        Iterable $this$count$iv = this.oneOf;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                JsonSchema it = (JsonSchema)element$iv;
                boolean bl = false;
                MessageSink oneOfMessageSink = new MessageSink();
                if (!it.isValid(ksonValue, oneOfMessageSink) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        boolean bl = hasExactlyOneOf = n == 1;
        if (!hasExactlyOneOf) {
            messageSink.error(ksonValue.getLocation(), MessageType.SCHEMA_ONE_OF_VALIDATION_FAILED.create(new String[0]));
        }
    }
}

