/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.EmbedBlock;
import org.kson.KsonBoolean;
import org.kson.KsonList;
import org.kson.KsonNull;
import org.kson.KsonNumber;
import org.kson.KsonObject;
import org.kson.KsonString;
import org.kson.KsonValue;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;
import org.kson.schema.JsonSchemaKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kson/schema/validators/TypeValidator;", "", "allowedTypes", "", "", "<init>", "(Ljava/util/List;)V", "type", "(Ljava/lang/String;)V", "validate", "", "ksonValue", "Lorg/kson/KsonValue;", "messageSink", "Lorg/kson/parser/MessageSink;", "kson"})
public final class TypeValidator {
    @NotNull
    private final List<String> allowedTypes;

    public TypeValidator(@NotNull List<String> allowedTypes) {
        Intrinsics.checkNotNullParameter(allowedTypes, (String)"allowedTypes");
        this.allowedTypes = allowedTypes;
    }

    public TypeValidator(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(CollectionsKt.listOf((Object)type));
    }

    public final boolean validate(@NotNull KsonValue ksonValue, @NotNull MessageSink messageSink) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ksonValue, (String)"ksonValue");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        String[] stringArray = ksonValue;
        if (stringArray instanceof KsonBoolean) {
            string = "boolean";
        } else if (stringArray instanceof KsonNull) {
            string = "null";
        } else if (stringArray instanceof KsonNumber) {
            string = JsonSchemaKt.asSchemaInteger((KsonNumber)ksonValue) != null ? "integer" : "number";
        } else if (stringArray instanceof KsonString) {
            string = "string";
        } else if (stringArray instanceof KsonList) {
            string = "array";
        } else if (stringArray instanceof KsonObject) {
            string = "object";
        } else if (stringArray instanceof EmbedBlock) {
            string = "object";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String nodeType = string;
        if (!(this.allowedTypes.contains(nodeType) || Intrinsics.areEqual((Object)nodeType, (Object)"integer") && this.allowedTypes.contains("number"))) {
            stringArray = new String[]{CollectionsKt.joinToString$default((Iterable)this.allowedTypes, null, null, null, (int)0, null, null, (int)63, null), nodeType};
            messageSink.error(ksonValue.getLocation(), MessageType.SCHEMA_VALUE_TYPE_MISMATCH.create(stringArray));
            return false;
        }
        return true;
    }
}

