/*
 * Decompiled with CFR 0.152.
 */
package org.kson;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kson.AstParseResult;
import org.kson.CompileTarget;
import org.kson.CoreCompileConfig;
import org.kson.JsonParseResult;
import org.kson.KsonCoreKt;
import org.kson.KsonParseResult;
import org.kson.KsonValue;
import org.kson.KsonValueKt;
import org.kson.SchemaParseResult;
import org.kson.YamlParseResult;
import org.kson.ast.KsonRoot;
import org.kson.parser.KsonBuilder;
import org.kson.parser.Lexer;
import org.kson.parser.LoggedMessage;
import org.kson.parser.MessageSink;
import org.kson.parser.Parser;
import org.kson.parser.Token;
import org.kson.parser.TokenType;
import org.kson.parser.messages.MessageType;
import org.kson.schema.JsonSchema;
import org.kson.schema.SchemaParser;
import org.kson.stdlibx.collections.ImmutableList;
import org.kson.stdlibx.exceptions.FatalParseException;
import org.kson.validation.DuplicateKeyValidator;
import org.kson.validation.IndentValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lorg/kson/KsonCore;", "", "<init>", "()V", "parseToAst", "Lorg/kson/AstParseResult;", "source", "", "coreCompileConfig", "Lorg/kson/CoreCompileConfig;", "parseSchema", "Lorg/kson/SchemaParseResult;", "parseToYaml", "Lorg/kson/YamlParseResult;", "compileConfig", "Lorg/kson/CompileTarget$Yaml;", "parseToJson", "Lorg/kson/JsonParseResult;", "Lorg/kson/CompileTarget$Json;", "parseToKson", "Lorg/kson/KsonParseResult;", "Lorg/kson/CompileTarget$Kson;", "kson"})
public final class KsonCore {
    @NotNull
    public static final KsonCore INSTANCE = new KsonCore();

    private KsonCore() {
    }

    @NotNull
    public final AstParseResult parseToAst(@NotNull String source, @NotNull CoreCompileConfig coreCompileConfig) {
        JsonSchema jsonSchema;
        int initialTokenIndex;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)coreCompileConfig, (String)"coreCompileConfig");
        MessageSink messageSink = new MessageSink();
        ImmutableList<Token> tokens = new Lexer(source, coreCompileConfig.getIgnoreErrors()).tokenize();
        for (initialTokenIndex = 0; initialTokenIndex < tokens.size() && (tokens.get(initialTokenIndex).getTokenType() == TokenType.WHITESPACE || tokens.get(initialTokenIndex).getTokenType() == TokenType.COMMENT); ++initialTokenIndex) {
        }
        if (tokens.get(initialTokenIndex).getTokenType() == TokenType.EOF) {
            messageSink.error(tokens.get(0).getLexeme().getLocation(), MessageType.BLANK_SOURCE.create(new String[0]));
            return new AstParseResult(null, (List<Token>)tokens, messageSink);
        }
        KsonBuilder builder = new KsonBuilder((List<Token>)tokens, coreCompileConfig.getIgnoreErrors());
        KsonRoot ast = null;
        try {
            new Parser(builder, coreCompileConfig.getMaxNestingLevel()).parse();
            ast = builder.buildTree(messageSink);
        }
        catch (FatalParseException ex) {
            System.out.println((Object)("Fatal parsing error: " + ex.getMessage()));
            return new AstParseResult(null, (List<Token>)tokens, messageSink);
        }
        if (!coreCompileConfig.getIgnoreErrors()) {
            new IndentValidator().validate(ast, messageSink);
            new DuplicateKeyValidator().validate(ast, messageSink);
        }
        if (!(Intrinsics.areEqual((Object)(jsonSchema = coreCompileConfig.getSchemaJson()), (Object)KsonCoreKt.access$getNO_SCHEMA$p()) || coreCompileConfig.getIgnoreErrors() || messageSink.hasErrors())) {
            jsonSchema.validate(KsonValueKt.toKsonValue(ast), messageSink);
        }
        return new AstParseResult(ast, (List<Token>)tokens, messageSink);
    }

    public static /* synthetic */ AstParseResult parseToAst$default(KsonCore ksonCore, String string, CoreCompileConfig coreCompileConfig, int n, Object object) {
        if ((n & 2) != 0) {
            coreCompileConfig = new CoreCompileConfig(null, false, 0, 7, null);
        }
        return ksonCore.parseToAst(string, coreCompileConfig);
    }

    @NotNull
    public final SchemaParseResult parseSchema(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        AstParseResult astParseResult = KsonCore.parseToAst$default(this, source, null, 2, null);
        Token firstToken = astParseResult.getLexedTokens().get(0);
        if (firstToken.getTokenType() == TokenType.EOF) {
            return new SchemaParseResult(null, CollectionsKt.listOf((Object)new LoggedMessage(firstToken.getLexeme().getLocation(), MessageType.SCHEMA_EMPTY_SCHEMA.create(new String[0]))));
        }
        KsonValue ksonValue = astParseResult.getKsonValue();
        if (ksonValue == null || astParseResult.hasErrors()) {
            return new SchemaParseResult(null, astParseResult.getMessages());
        }
        MessageSink messageSink = new MessageSink();
        JsonSchema jsonSchema = SchemaParser.INSTANCE.parseSchemaRoot(ksonValue, messageSink);
        return new SchemaParseResult(jsonSchema, messageSink.loggedMessages());
    }

    @NotNull
    public final YamlParseResult parseToYaml(@NotNull String source, @NotNull CompileTarget.Yaml compileConfig) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)compileConfig, (String)"compileConfig");
        return new YamlParseResult(this.parseToAst(source, compileConfig.getCoreConfig()), compileConfig);
    }

    public static /* synthetic */ YamlParseResult parseToYaml$default(KsonCore ksonCore, String string, CompileTarget.Yaml yaml, int n, Object object) {
        if ((n & 2) != 0) {
            yaml = new CompileTarget.Yaml(false, false, null, 7, null);
        }
        return ksonCore.parseToYaml(string, yaml);
    }

    @NotNull
    public final JsonParseResult parseToJson(@NotNull String source, @NotNull CompileTarget.Json compileConfig) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)compileConfig, (String)"compileConfig");
        return new JsonParseResult(this.parseToAst(source, compileConfig.getCoreConfig()), compileConfig);
    }

    public static /* synthetic */ JsonParseResult parseToJson$default(KsonCore ksonCore, String string, CompileTarget.Json json, int n, Object object) {
        if ((n & 2) != 0) {
            json = new CompileTarget.Json(false, null, 3, null);
        }
        return ksonCore.parseToJson(string, json);
    }

    @NotNull
    public final KsonParseResult parseToKson(@NotNull String source, @NotNull CompileTarget.Kson compileConfig) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)compileConfig, (String)"compileConfig");
        return new KsonParseResult(this.parseToAst(source, compileConfig.getCoreConfig()), compileConfig);
    }

    public static /* synthetic */ KsonParseResult parseToKson$default(KsonCore ksonCore, String string, CompileTarget.Kson kson, int n, Object object) {
        if ((n & 2) != 0) {
            kson = new CompileTarget.Kson(false, null, null, 7, null);
        }
        return ksonCore.parseToKson(string, kson);
    }
}

