/*
 * Decompiled with CFR 0.152.
 */
package org.kson.ast;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0019\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u00a8\u0006\u0013"}, d2={"renderForJsonString", "", "content", "escapeRawWhitespace", "ksonEscapedString", "appendUnicodeEscape", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "codePoint", "", "appendSurrogatePair", "unescapeStringContent", "stringContent", "handleUnicodeEscape", "Lkotlin/Pair;", "", "input", "kson"})
public final class EscapingKt {
    @NotNull
    public static final String renderForJsonString(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringBuilder sb = new StringBuilder(content.length() + 2);
        for (int i = 0; i < content.length(); ++i) {
            StringBuilder stringBuilder;
            char c = content.charAt(i);
            if (c == '\"') {
                stringBuilder = sb.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuilder = sb.append("\\\\");
                continue;
            }
            if (c == '/') {
                stringBuilder = sb.append("\\/");
                continue;
            }
            if (c == '\b') {
                stringBuilder = sb.append("\\b");
                continue;
            }
            if (c == '\f') {
                stringBuilder = sb.append("\\f");
                continue;
            }
            if (c == '\n') {
                stringBuilder = sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder = sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder = sb.append("\\t");
                continue;
            }
            if (Character.isHighSurrogate(c) && i + 1 < content.length() && Character.isLowSurrogate(content.charAt(i + 1))) {
                char high = c;
                char low = content.charAt(++i);
                int codePoint = 65536 + (high - 55296 << 10) + (low - 56320);
                EscapingKt.appendSurrogatePair(sb, codePoint);
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (c < ' ') {
                EscapingKt.appendUnicodeEscape(sb, c);
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            if (c == '\u2028' || c == '\u2029') {
                EscapingKt.appendUnicodeEscape(sb, c);
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            stringBuilder = sb.append(c);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String escapeRawWhitespace(@NotNull String ksonEscapedString) {
        Intrinsics.checkNotNullParameter((Object)ksonEscapedString, (String)"ksonEscapedString");
        StringBuilder sb = new StringBuilder(ksonEscapedString.length() + 2);
        block5: for (int i = 0; i < ksonEscapedString.length(); ++i) {
            char c = ksonEscapedString.charAt(i);
            switch (c) {
                case '\n': {
                    StringBuilder stringBuilder = sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    StringBuilder stringBuilder = sb.append("\\r");
                    continue block5;
                }
                case '\t': {
                    StringBuilder stringBuilder = sb.append("\\t");
                    continue block5;
                }
                default: {
                    StringBuilder stringBuilder = sb.append(c);
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void appendUnicodeEscape(StringBuilder sb, int codePoint) {
        sb.append("\\u");
        String string = Integer.toString(codePoint, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        sb.append(StringsKt.padStart((String)string2, (int)4, (char)'0'));
    }

    private static final void appendSurrogatePair(StringBuilder sb, int codePoint) {
        int high = 0xD800 | codePoint - 65536 >> 10;
        int low = 0xDC00 | codePoint - 65536 & 0x3FF;
        EscapingKt.appendUnicodeEscape(sb, high);
        EscapingKt.appendUnicodeEscape(sb, low);
    }

    @NotNull
    public static final String unescapeStringContent(@NotNull String stringContent) {
        Intrinsics.checkNotNullParameter((Object)stringContent, (String)"stringContent");
        StringBuilder sb = new StringBuilder(stringContent.length());
        int i = 0;
        block9: while (i < stringContent.length()) {
            char c = stringContent.charAt(i);
            if (c == '\\' && i + 1 < stringContent.length()) {
                char escaped = stringContent.charAt(i + 1);
                switch (escaped) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append(escaped);
                        i += 2;
                        continue block9;
                    }
                    case 'b': {
                        sb.append('\b');
                        i += 2;
                        continue block9;
                    }
                    case 'f': {
                        sb.append('\f');
                        i += 2;
                        continue block9;
                    }
                    case 'n': {
                        sb.append('\n');
                        i += 2;
                        continue block9;
                    }
                    case 'r': {
                        sb.append('\r');
                        i += 2;
                        continue block9;
                    }
                    case 't': {
                        sb.append('\t');
                        i += 2;
                        continue block9;
                    }
                    case 'u': {
                        String string = stringContent.substring(i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        Pair<char[], Integer> pair = EscapingKt.handleUnicodeEscape(string);
                        char[] chars = (char[])pair.component1();
                        int consumed = ((Number)pair.component2()).intValue();
                        for (char c2 : chars) {
                            sb.append(c2);
                        }
                        i += consumed;
                        continue block9;
                    }
                }
                sb.append(c);
                ++i;
                continue;
            }
            sb.append(c);
            ++i;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Pair<char[], Integer> handleUnicodeEscape(String input) {
        if (input.length() < 6) {
            char[] cArray = new char[]{'\\'};
            return new Pair((Object)cArray, (Object)1);
        }
        if (input.charAt(0) != '\\' || input.charAt(1) != 'u') {
            char[] cArray = new char[]{'\\'};
            return new Pair((Object)cArray, (Object)1);
        }
        String string = input.substring(2, 6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String hexStr = string;
        Integer n = StringsKt.toIntOrNull((String)hexStr, (int)16);
        if (n == null) {
            boolean bl = false;
            char[] cArray = new char[]{'\\'};
            return new Pair((Object)cArray, (Object)1);
        }
        int codePoint = n;
        if (Character.isHighSurrogate((char)codePoint) && input.length() >= 12 && input.charAt(6) == '\\' && input.charAt(7) == 'u') {
            String string2 = input.substring(8, 12);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String lowHexStr = string2;
            Integer lowCodePoint = StringsKt.toIntOrNull((String)lowHexStr, (int)16);
            if (lowCodePoint != null && Character.isLowSurrogate((char)lowCodePoint.intValue())) {
                char[] cArray = new char[]{(char)codePoint, (char)lowCodePoint.intValue()};
                return new Pair((Object)cArray, (Object)12);
            }
        }
        char[] cArray = new char[]{(char)codePoint};
        return new Pair((Object)cArray, (Object)6);
    }
}

