/*
 * Decompiled with CFR 0.152.
 */
package org.kson.ast;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.CompileTarget;
import org.kson.ast.AstNode;
import org.kson.ast.AstNodeImpl;
import org.kson.ast.Documented;
import org.kson.ast.KsonRoot;
import org.kson.ast.KsonValueNode;
import org.kson.parser.Location;
import org.kson.tools.FormattingStyle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\"\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kson/ast/KsonRootImpl;", "Lorg/kson/ast/KsonRoot;", "Lorg/kson/ast/AstNodeImpl;", "Lorg/kson/ast/Documented;", "rootNode", "Lorg/kson/ast/KsonValueNode;", "trailingContent", "", "comments", "", "documentEndComments", "location", "Lorg/kson/parser/Location;", "<init>", "(Lorg/kson/ast/KsonValueNode;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lorg/kson/parser/Location;)V", "getRootNode", "()Lorg/kson/ast/KsonValueNode;", "getComments", "()Ljava/util/List;", "toSourceInternal", "indent", "Lorg/kson/ast/AstNode$Indent;", "nextNode", "Lorg/kson/ast/AstNode;", "compileTarget", "Lorg/kson/CompileTarget;", "kson"})
@SourceDebugExtension(value={"SMAP\nAst.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Ast.kt\norg/kson/ast/KsonRootImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,825:1\n1869#2,2:826\n*S KotlinDebug\n*F\n+ 1 Ast.kt\norg/kson/ast/KsonRootImpl\n*L\n179#1:826,2\n*E\n"})
public final class KsonRootImpl
extends AstNodeImpl
implements KsonRoot,
Documented {
    @NotNull
    private final KsonValueNode rootNode;
    @NotNull
    private final List<KsonValueNode> trailingContent;
    @NotNull
    private final List<String> comments;
    @NotNull
    private final List<String> documentEndComments;

    public KsonRootImpl(@NotNull KsonValueNode rootNode, @NotNull List<? extends KsonValueNode> trailingContent, @NotNull List<String> comments, @NotNull List<String> documentEndComments, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter(trailingContent, (String)"trailingContent");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter(documentEndComments, (String)"documentEndComments");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location, null);
        this.rootNode = rootNode;
        this.trailingContent = trailingContent;
        this.comments = comments;
        this.documentEndComments = documentEndComments;
    }

    @NotNull
    public final KsonValueNode getRootNode() {
        return this.rootNode;
    }

    @Override
    @NotNull
    public List<String> getComments() {
        return this.comments;
    }

    @Override
    @NotNull
    protected String toSourceInternal(@NotNull AstNode.Indent indent, @Nullable AstNode nextNode, @NotNull CompileTarget compileTarget) {
        Object ksonDocument;
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
        CompileTarget compileTarget2 = compileTarget;
        if (compileTarget2 instanceof CompileTarget.Kson || compileTarget2 instanceof CompileTarget.Yaml || compileTarget2 instanceof CompileTarget.Json) {
            ksonDocument = null;
            ksonDocument = this.rootNode.toSourceWithNext(indent, null, compileTarget);
            Iterable $this$forEach$iv = this.trailingContent;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KsonValueNode it = (KsonValueNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)StringsKt.takeLast((String)ksonDocument, (int)2), (Object)"\n\n")) {
                    ksonDocument = ksonDocument + "\n\n";
                }
                ksonDocument = ksonDocument + it.toSourceWithNext(indent, null, compileTarget);
            }
            while (StringsKt.endsWith$default((String)ksonDocument, (String)"\n", (boolean)false, (int)2, null)) {
                ksonDocument = StringsKt.removeSuffix((String)ksonDocument, (CharSequence)"\n");
            }
            if (compileTarget.getPreserveComments() && !((Collection)this.documentEndComments).isEmpty()) {
                String endComments = CollectionsKt.joinToString$default((Iterable)this.documentEndComments, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                ksonDocument = ksonDocument + (String)(StringsKt.endsWith$default((String)ksonDocument, (String)endComments, (boolean)false, (int)2, null) ? "" : (compileTarget instanceof CompileTarget.Kson && ((CompileTarget.Kson)compileTarget).getFormatConfig().getFormattingStyle() == FormattingStyle.COMPACT ? "\n" + endComments : "\n\n" + endComments));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ksonDocument;
    }
}

