/*
 * Decompiled with CFR 0.152.
 */
package org.kson.ast;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.CompileTarget;
import org.kson.ast.AstNode;
import org.kson.ast.FalseNode;
import org.kson.ast.KsonValueNode;
import org.kson.ast.KsonValueNodeImpl;
import org.kson.ast.NullNode;
import org.kson.ast.NumberNode;
import org.kson.ast.ObjectPropertyNode;
import org.kson.ast.ObjectPropertyNodeImpl;
import org.kson.ast.QuotedStringNode;
import org.kson.ast.TrueNode;
import org.kson.ast.UnquotedStringNode;
import org.kson.parser.Location;
import org.kson.parser.behavior.StringUnquoted;
import org.kson.tools.FormattingStyle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/kson/ast/ObjectNode;", "Lorg/kson/ast/KsonValueNodeImpl;", "properties", "", "Lorg/kson/ast/ObjectPropertyNode;", "location", "Lorg/kson/parser/Location;", "<init>", "(Ljava/util/List;Lorg/kson/parser/Location;)V", "getProperties", "()Ljava/util/List;", "toSourceInternal", "", "indent", "Lorg/kson/ast/AstNode$Indent;", "nextNode", "Lorg/kson/ast/AstNode;", "compileTarget", "Lorg/kson/CompileTarget;", "formatDelimitedObject", "formatCompactObject", "formatUndelimitedObject", "kson"})
public final class ObjectNode
extends KsonValueNodeImpl {
    @NotNull
    private final List<ObjectPropertyNode> properties;

    public ObjectNode(@NotNull List<? extends ObjectPropertyNode> properties, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location);
        this.properties = properties;
    }

    @NotNull
    public final List<ObjectPropertyNode> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    protected String toSourceInternal(@NotNull AstNode.Indent indent, @Nullable AstNode nextNode, @NotNull CompileTarget compileTarget) {
        String string;
        block11: {
            CompileTarget compileTarget2;
            block10: {
                Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
                if (this.properties.isEmpty()) {
                    return indent.firstLineIndent() + "{}";
                }
                compileTarget2 = compileTarget;
                if (!(compileTarget2 instanceof CompileTarget.Kson)) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[((CompileTarget.Kson)compileTarget).getFormatConfig().getFormattingStyle().ordinal()]) {
                    case 1: {
                        string = this.formatDelimitedObject(indent, nextNode, compileTarget);
                        break block11;
                    }
                    case 2: {
                        string = this.formatUndelimitedObject(indent, nextNode, compileTarget);
                        break block11;
                    }
                    case 3: {
                        string = this.formatCompactObject(indent, nextNode, compileTarget);
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (compileTarget2 instanceof CompileTarget.Yaml) {
                string = this.formatUndelimitedObject(indent, nextNode, compileTarget);
            } else if (compileTarget2 instanceof CompileTarget.Json) {
                string = this.formatDelimitedObject(indent, nextNode, compileTarget);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String formatDelimitedObject(AstNode.Indent indent, AstNode nextNode, CompileTarget compileTarget) {
        String string;
        CompileTarget compileTarget2 = compileTarget;
        if (compileTarget2 instanceof CompileTarget.Kson) {
            string = "\n";
        } else if (compileTarget2 instanceof CompileTarget.Json) {
            string = ",\n";
        } else {
            if (compileTarget2 instanceof CompileTarget.Yaml) {
                throw new UnsupportedOperationException("We never format YAML objects as delimited");
            }
            throw new NoWhenBranchMatchedException();
        }
        String seperator = string;
        return StringsKt.trimMargin$default((String)("\n            |" + indent.firstLineIndent() + "{\n            |" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)this.properties), (CharSequence)seperator, null, null, (int)0, null, arg_0 -> ObjectNode.formatDelimitedObject$lambda$0(this, nextNode, indent, compileTarget, arg_0), (int)30, null) + "\n            |" + indent.bodyLinesIndent() + "}\n            "), null, (int)1, null);
    }

    private final String formatCompactObject(AstNode.Indent indent, AstNode nextNode, CompileTarget compileTarget) {
        Object object;
        String outputObject = CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)this.properties), (CharSequence)"", null, null, (int)0, null, arg_0 -> ObjectNode.formatCompactObject$lambda$1(this, nextNode, indent, compileTarget, arg_0), (int)30, null);
        if (nextNode instanceof ObjectPropertyNode) {
            Object object2 = CollectionsKt.last(this.properties);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.kson.ast.ObjectPropertyNodeImpl");
            boolean needsSpace = ((ObjectPropertyNodeImpl)object2).getValue() instanceof NumberNode;
            object = outputObject + (needsSpace ? " ." : ".");
        } else {
            object = outputObject;
        }
        return object;
    }

    private final String formatUndelimitedObject(AstNode.Indent indent, AstNode nextNode, CompileTarget compileTarget) {
        String outputObject = CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)this.properties), (CharSequence)"\n", null, null, (int)0, null, arg_0 -> ObjectNode.formatUndelimitedObject$lambda$2(this, nextNode, indent, compileTarget, arg_0), (int)30, null);
        return compileTarget instanceof CompileTarget.Kson && nextNode instanceof ObjectPropertyNode ? outputObject + "\n" + indent.bodyLinesIndent() + "." : outputObject + (this.properties.size() > 1 ? "\n" : "");
    }

    private static final CharSequence formatDelimitedObject$lambda$0(ObjectNode this$0, AstNode $nextNode, AstNode.Indent $indent, CompileTarget $compileTarget, IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        ObjectPropertyNode property = (ObjectPropertyNode)indexedValue.component2();
        ObjectPropertyNode objectPropertyNode = (ObjectPropertyNode)CollectionsKt.getOrNull(this$0.properties, (int)(index + 1));
        AstNode nodeAfterThisChild = objectPropertyNode != null ? (AstNode)objectPropertyNode : $nextNode;
        return property.toSourceWithNext($indent.next(false), nodeAfterThisChild, $compileTarget);
    }

    private static final CharSequence formatCompactObject$lambda$1(ObjectNode this$0, AstNode $nextNode, AstNode.Indent $indent, CompileTarget $compileTarget, IndexedValue indexedValue) {
        KsonValueNode ksonValueNode;
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        ObjectPropertyNode property = (ObjectPropertyNode)indexedValue.component2();
        ObjectPropertyNode objectPropertyNode = (ObjectPropertyNode)CollectionsKt.getOrNull(this$0.properties, (int)(index + 1));
        AstNode nodeAfterThisChild = objectPropertyNode != null ? (AstNode)objectPropertyNode : $nextNode;
        String result = property.toSourceWithNext($indent, nodeAfterThisChild, $compileTarget);
        boolean needsSpace = index < this$0.properties.size() - 1 && property instanceof ObjectPropertyNodeImpl && StringsKt.last((CharSequence)result) != '\n' && ((ksonValueNode = ((ObjectPropertyNodeImpl)property).getValue()) instanceof QuotedStringNode ? StringUnquoted.INSTANCE.isUnquotable(((QuotedStringNode)((ObjectPropertyNodeImpl)property).getValue()).getStringContent()) : ksonValueNode instanceof UnquotedStringNode || ksonValueNode instanceof NumberNode || ksonValueNode instanceof TrueNode || ksonValueNode instanceof FalseNode || ksonValueNode instanceof NullNode);
        return needsSpace ? (CharSequence)(result + " ") : (CharSequence)result;
    }

    private static final CharSequence formatUndelimitedObject$lambda$2(ObjectNode this$0, AstNode $nextNode, AstNode.Indent $indent, CompileTarget $compileTarget, IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        ObjectPropertyNode property = (ObjectPropertyNode)indexedValue.component2();
        ObjectPropertyNode objectPropertyNode = (ObjectPropertyNode)CollectionsKt.getOrNull(this$0.properties, (int)(index + 1));
        AstNode nodeAfterThisChild = objectPropertyNode != null ? (AstNode)objectPropertyNode : $nextNode;
        return index == 0 ? (CharSequence)property.toSourceWithNext($indent, nodeAfterThisChild, $compileTarget) : (CharSequence)property.toSourceWithNext($indent.clone(false), nodeAfterThisChild, $compileTarget);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormattingStyle.values().length];
            try {
                nArray[FormattingStyle.DELIMITED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormattingStyle.PLAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormattingStyle.COMPACT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

