/*
 * Decompiled with CFR 0.152.
 */
package org.kson.ast;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.CompileTarget;
import org.kson.ast.AstNode;
import org.kson.ast.EscapingKt;
import org.kson.ast.StringNodeImpl;
import org.kson.parser.Location;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/kson/ast/UnquotedStringNode;", "Lorg/kson/ast/StringNodeImpl;", "stringContent", "", "location", "Lorg/kson/parser/Location;", "<init>", "(Ljava/lang/String;Lorg/kson/parser/Location;)V", "getStringContent", "()Ljava/lang/String;", "toSourceInternal", "indent", "Lorg/kson/ast/AstNode$Indent;", "nextNode", "Lorg/kson/ast/AstNode;", "compileTarget", "Lorg/kson/CompileTarget;", "kson"})
public final class UnquotedStringNode
extends StringNodeImpl {
    @NotNull
    private final String stringContent;

    public UnquotedStringNode(@NotNull String stringContent, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)stringContent, (String)"stringContent");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(location);
        this.stringContent = stringContent;
    }

    @Override
    @NotNull
    public String getStringContent() {
        return this.stringContent;
    }

    @Override
    @NotNull
    protected String toSourceInternal(@NotNull AstNode.Indent indent, @Nullable AstNode nextNode, @NotNull CompileTarget compileTarget) {
        String string;
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)compileTarget, (String)"compileTarget");
        CompileTarget compileTarget2 = compileTarget;
        if (compileTarget2 instanceof CompileTarget.Kson || compileTarget2 instanceof CompileTarget.Yaml) {
            string = indent.firstLineIndent() + this.getStringContent();
        } else if (compileTarget2 instanceof CompileTarget.Json) {
            string = indent.firstLineIndent() + "\"" + EscapingKt.renderForJsonString(this.getStringContent()) + "\"";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

