/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.AstMarker;
import org.kson.parser.ElementType;
import org.kson.parser.Location;
import org.kson.parser.MarkerBuilderContext;
import org.kson.parser.MarkerCreator;
import org.kson.parser.ParsedElementType;
import org.kson.parser.messages.CoreParseMessage;
import org.kson.parser.messages.Message;
import org.kson.stdlibx.exceptions.ShouldNotHappenException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\"H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\b\b\u0002\u0010+\u001a\u00020\"J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010-\u001a\u00020\u0000H\u0016J\u0006\u00100\u001a\u00020\u0000J\u0010\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u0017H\u0016J\b\u00103\u001a\u00020/H\u0016J\b\u00104\u001a\u00020/H\u0016J\b\u00105\u001a\u00020$H\u0016J\u0010\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR!\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u001dj\b\u0012\u0004\u0012\u00020\u0000`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00068"}, d2={"Lorg/kson/parser/KsonMarker;", "Lorg/kson/parser/AstMarker;", "Lorg/kson/parser/MarkerCreator;", "context", "Lorg/kson/parser/MarkerBuilderContext;", "creator", "<init>", "(Lorg/kson/parser/MarkerBuilderContext;Lorg/kson/parser/MarkerCreator;)V", "firstTokenIndex", "", "getFirstTokenIndex", "()I", "lastTokenIndex", "getLastTokenIndex", "setLastTokenIndex", "(I)V", "markedError", "Lorg/kson/parser/messages/Message;", "getMarkedError", "()Lorg/kson/parser/messages/Message;", "setMarkedError", "(Lorg/kson/parser/messages/Message;)V", "element", "Lorg/kson/parser/ElementType;", "getElement", "()Lorg/kson/parser/ElementType;", "setElement", "(Lorg/kson/parser/ElementType;)V", "childMarkers", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildMarkers", "()Ljava/util/ArrayList;", "isDone", "", "getRawText", "", "getValue", "getLocation", "Lorg/kson/parser/Location;", "commentable", "getComments", "", "claimed", "forgetMe", "me", "dropMe", "", "addMark", "done", "elementType", "drop", "rollbackTo", "toString", "error", "message", "kson"})
final class KsonMarker
implements AstMarker,
MarkerCreator {
    @NotNull
    private final MarkerBuilderContext context;
    @NotNull
    private final MarkerCreator creator;
    private final int firstTokenIndex;
    private int lastTokenIndex;
    @Nullable
    private Message markedError;
    @NotNull
    private ElementType element;
    @NotNull
    private final ArrayList<KsonMarker> childMarkers;

    public KsonMarker(@NotNull MarkerBuilderContext context, @NotNull MarkerCreator creator) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        this.context = context;
        this.creator = creator;
        this.lastTokenIndex = this.firstTokenIndex = this.context.getTokenIndex();
        this.element = ParsedElementType.INCOMPLETE;
        this.childMarkers = new ArrayList();
    }

    public final int getFirstTokenIndex() {
        return this.firstTokenIndex;
    }

    public final int getLastTokenIndex() {
        return this.lastTokenIndex;
    }

    public final void setLastTokenIndex(int n) {
        this.lastTokenIndex = n;
    }

    @Nullable
    public final Message getMarkedError() {
        return this.markedError;
    }

    public final void setMarkedError(@Nullable Message message) {
        this.markedError = message;
    }

    @NotNull
    public final ElementType getElement() {
        return this.element;
    }

    public final void setElement(@NotNull ElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"<set-?>");
        this.element = elementType;
    }

    @NotNull
    public final ArrayList<KsonMarker> getChildMarkers() {
        return this.childMarkers;
    }

    public final boolean isDone() {
        return this.element != ParsedElementType.INCOMPLETE;
    }

    @NotNull
    public final String getRawText() {
        return this.context.getRawText(this.firstTokenIndex, this.lastTokenIndex);
    }

    @NotNull
    public final String getValue() {
        return this.context.getValue(this.firstTokenIndex, this.lastTokenIndex);
    }

    @NotNull
    public final Location getLocation() {
        return this.context.getLocation(this.firstTokenIndex, this.lastTokenIndex);
    }

    private final boolean commentable() {
        ElementType elementType = this.element;
        return elementType == ParsedElementType.ROOT || elementType == ParsedElementType.OBJECT_PROPERTY || elementType == ParsedElementType.LIST_ELEMENT;
    }

    @NotNull
    public final List<String> getComments(boolean claimed) {
        if (claimed != this.commentable()) {
            return CollectionsKt.emptyList();
        }
        ArrayList comments = new ArrayList();
        int tokenIndex = this.firstTokenIndex;
        int childMarkerIndex = 0;
        while (tokenIndex <= this.lastTokenIndex) {
            while (childMarkerIndex < this.childMarkers.size()) {
                while (tokenIndex < this.childMarkers.get((int)childMarkerIndex).firstTokenIndex) {
                    comments.addAll(this.context.getComments(tokenIndex));
                    ++tokenIndex;
                }
                comments.addAll(this.childMarkers.get(childMarkerIndex).getComments(false));
                tokenIndex = this.childMarkers.get((int)childMarkerIndex).lastTokenIndex + 1;
                ++childMarkerIndex;
            }
            if (tokenIndex > this.lastTokenIndex) continue;
            comments.addAll(this.context.getComments(tokenIndex));
            ++tokenIndex;
        }
        return comments;
    }

    public static /* synthetic */ List getComments$default(KsonMarker ksonMarker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return ksonMarker.getComments(bl);
    }

    @Override
    @NotNull
    public KsonMarker forgetMe(@NotNull KsonMarker me) {
        Intrinsics.checkNotNullParameter((Object)me, (String)"me");
        KsonMarker lastChild = (KsonMarker)CollectionsKt.removeLast((List)this.childMarkers);
        if (!Intrinsics.areEqual((Object)lastChild, (Object)me)) {
            throw new ShouldNotHappenException("Bug: This should be an impossible `forgetMe` call since the order of resolving markers should ensure that calls to `forgetMe` are always on the last added marker");
        }
        return lastChild;
    }

    @Override
    public void dropMe(@NotNull KsonMarker me) {
        Intrinsics.checkNotNullParameter((Object)me, (String)"me");
        KsonMarker droppedChild = this.forgetMe(me);
        this.childMarkers.addAll((Collection<KsonMarker>)droppedChild.childMarkers);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KsonMarker addMark() {
        KsonMarker ksonMarker;
        if (!((Collection)this.childMarkers).isEmpty() && !((KsonMarker)CollectionsKt.last((List)this.childMarkers)).isDone()) {
            ksonMarker = ((KsonMarker)CollectionsKt.last((List)this.childMarkers)).addMark();
        } else {
            void var1_1;
            KsonMarker newMarker = new KsonMarker(this.context, this);
            this.childMarkers.add(newMarker);
            ksonMarker = var1_1;
        }
        return ksonMarker;
    }

    @Override
    public void done(@NotNull ElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        this.lastTokenIndex = this.context.getTokenIndex() - 1;
        if (this.lastTokenIndex < this.firstTokenIndex) {
            throw new ShouldNotHappenException("Must not create empty elements.");
        }
        this.element = elementType;
    }

    @Override
    public void drop() {
        this.creator.dropMe(this);
    }

    @Override
    public void rollbackTo() {
        this.context.setTokenIndex(this.firstTokenIndex);
        this.creator.forgetMe(this);
    }

    @NotNull
    public String toString() {
        return this.element.toString();
    }

    @Override
    public void error(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.markedError = new CoreParseMessage(message);
        this.done(ParsedElementType.ERROR);
    }
}

