/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.Coordinates;
import org.kson.stdlibx.exceptions.ShouldNotHappenException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0000J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/kson/parser/Location;", "", "start", "Lorg/kson/parser/Coordinates;", "end", "startOffset", "", "endOffset", "<init>", "(Lorg/kson/parser/Coordinates;Lorg/kson/parser/Coordinates;II)V", "getStart", "()Lorg/kson/parser/Coordinates;", "getEnd", "getStartOffset", "()I", "getEndOffset", "trimToFirstLine", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "kson"})
public final class Location {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinates start;
    @NotNull
    private final Coordinates end;
    private final int startOffset;
    private final int endOffset;

    public Location(@NotNull Coordinates start, @NotNull Coordinates end, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.start = start;
        this.end = end;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @NotNull
    public final Coordinates getStart() {
        return this.start;
    }

    @NotNull
    public final Coordinates getEnd() {
        return this.end;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @NotNull
    public final Location trimToFirstLine() {
        int maxLength = this.endOffset - this.startOffset;
        int trimmedLength = RangesKt.coerceAtMost((int)5, (int)maxLength);
        Coordinates trimmedStart = new Coordinates(this.start.getLine(), this.start.getColumn());
        Coordinates trimmedEnd = new Coordinates(this.start.getLine(), this.start.getColumn() + trimmedLength);
        return new Location(trimmedStart, trimmedEnd, this.startOffset, this.startOffset + trimmedLength);
    }

    @NotNull
    public final Coordinates component1() {
        return this.start;
    }

    @NotNull
    public final Coordinates component2() {
        return this.end;
    }

    public final int component3() {
        return this.startOffset;
    }

    public final int component4() {
        return this.endOffset;
    }

    @NotNull
    public final Location copy(@NotNull Coordinates start, @NotNull Coordinates end, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return new Location(start, end, startOffset, endOffset);
    }

    public static /* synthetic */ Location copy$default(Location location, Coordinates coordinates, Coordinates coordinates2, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            coordinates = location.start;
        }
        if ((n3 & 2) != 0) {
            coordinates2 = location.end;
        }
        if ((n3 & 4) != 0) {
            n = location.startOffset;
        }
        if ((n3 & 8) != 0) {
            n2 = location.endOffset;
        }
        return location.copy(coordinates, coordinates2, n, n2);
    }

    @NotNull
    public String toString() {
        return "Location(start=" + this.start + ", end=" + this.end + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
    }

    public int hashCode() {
        int result = this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + Integer.hashCode(this.startOffset);
        result = result * 31 + Integer.hashCode(this.endOffset);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Location)) {
            return false;
        }
        Location location = (Location)other;
        if (!Intrinsics.areEqual((Object)this.start, (Object)location.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)location.end)) {
            return false;
        }
        if (this.startOffset != location.startOffset) {
            return false;
        }
        return this.endOffset == location.endOffset;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0010"}, d2={"Lorg/kson/parser/Location$Companion;", "", "<init>", "()V", "create", "Lorg/kson/parser/Location;", "firstLine", "", "firstColumn", "lastLine", "lastColumn", "startOffset", "endOffset", "merge", "startLocation", "endLocation", "kson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Location create(int firstLine, int firstColumn, int lastLine, int lastColumn, int startOffset, int endOffset) {
            return new Location(new Coordinates(firstLine, firstColumn), new Coordinates(lastLine, lastColumn), startOffset, endOffset);
        }

        @NotNull
        public final Location merge(@NotNull Location startLocation, @NotNull Location endLocation) {
            Intrinsics.checkNotNullParameter((Object)startLocation, (String)"startLocation");
            Intrinsics.checkNotNullParameter((Object)endLocation, (String)"endLocation");
            if (startLocation.getStartOffset() > endLocation.getEndOffset()) {
                throw new ShouldNotHappenException("`startLocation` must be before `endLocation`");
            }
            return new Location(startLocation.getStart(), endLocation.getEnd(), startLocation.getStartOffset(), endLocation.getEndOffset());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

