/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser;

import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.IntegerOverflowException;
import org.kson.parser.NumberParserKt;
import org.kson.parser.messages.Message;
import org.kson.parser.messages.MessageType;
import org.kson.stdlibx.exceptions.ShouldNotHappenException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kson/parser/NumberParser;", "", "numberCandidate", "", "<init>", "(Ljava/lang/String;)V", "scanner", "Lorg/kson/parser/NumberParser$Scanner;", "error", "Lorg/kson/parser/messages/Message;", "hasDecimalPoint", "", "hasExponent", "parse", "Lorg/kson/parser/NumberParser$NumberParseResult;", "number", "integer", "digits", "digit", "zeroToNine", "", "", "fraction", "exponent", "sign", "ParsedNumber", "NumberParseResult", "Scanner", "kson"})
public final class NumberParser {
    @NotNull
    private final String numberCandidate;
    @NotNull
    private final Scanner scanner;
    @Nullable
    private Message error;
    private boolean hasDecimalPoint;
    private boolean hasExponent;
    @NotNull
    private final Set<Character> zeroToNine;

    public NumberParser(@NotNull String numberCandidate) {
        Intrinsics.checkNotNullParameter((Object)numberCandidate, (String)"numberCandidate");
        this.numberCandidate = numberCandidate;
        this.scanner = new Scanner(this.numberCandidate);
        Object[] objectArray = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        this.zeroToNine = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final NumberParseResult parse() {
        NumberParseResult numberParseResult;
        if (this.number()) {
            ParsedNumber parsedNumber;
            if (!this.hasDecimalPoint && !this.hasExponent) {
                ParsedNumber.Integer integer;
                try {
                    integer = new ParsedNumber.Integer(this.numberCandidate);
                }
                catch (IntegerOverflowException e) {
                    String[] stringArray = new String[]{this.numberCandidate};
                    return new NumberParseResult(null, MessageType.INTEGER_OVERFLOW.create(stringArray));
                }
                parsedNumber = integer;
            } else {
                parsedNumber = new ParsedNumber.Decimal(this.numberCandidate);
            }
            ParsedNumber result = parsedNumber;
            numberParseResult = new NumberParseResult(result, null);
        } else {
            if (this.error == null) {
                throw new ShouldNotHappenException("must always set `error` message for a failed parse");
            }
            numberParseResult = new NumberParseResult(null, this.error);
        }
        return numberParseResult;
    }

    private final boolean number() {
        if (this.integer() && this.fraction() && this.exponent()) {
            if (!this.scanner.eof()) {
                String[] stringArray = new String[]{String.valueOf(this.scanner.peek())};
                this.error = MessageType.INVALID_DIGITS.create(stringArray);
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean integer() {
        if (this.digits()) {
            return true;
        }
        Character c = this.scanner.peek();
        char c2 = '-';
        if (c != null && c.charValue() == c2) {
            boolean bl;
            this.scanner.advanceScanner();
            if (this.digits()) {
                bl = true;
            } else {
                this.error = MessageType.ILLEGAL_MINUS_SIGN.create(new String[0]);
                bl = false;
            }
            return bl;
        }
        String[] stringArray = new String[]{String.valueOf(this.scanner.peek())};
        this.error = MessageType.INVALID_DIGITS.create(stringArray);
        return false;
    }

    private final boolean digits() {
        boolean digitsFound = false;
        while (this.digit()) {
            this.scanner.advanceScanner();
            digitsFound = true;
        }
        return digitsFound;
    }

    private final boolean digit() {
        return CollectionsKt.contains((Iterable)this.zeroToNine, (Object)this.scanner.peek());
    }

    private final boolean fraction() {
        Character c = this.scanner.peek();
        char c2 = '.';
        if (c != null && c.charValue() == c2) {
            boolean bl;
            this.hasDecimalPoint = true;
            this.scanner.advanceScanner();
            if (this.digits()) {
                bl = true;
            } else {
                this.error = MessageType.DANGLING_DECIMAL.create(new String[0]);
                bl = false;
            }
            return bl;
        }
        return true;
    }

    private final boolean exponent() {
        block6: {
            Character exponentChar;
            block5: {
                Character c = exponentChar = this.scanner.peek();
                char c2 = 'E';
                if (c != null && c.charValue() == c2) break block5;
                Character c3 = exponentChar;
                c2 = 'e';
                if (c3 == null || c3.charValue() != c2) break block6;
            }
            this.hasExponent = true;
            this.scanner.advanceScanner();
            this.sign();
            if (this.scanner.eof()) {
                String[] stringArray = new String[]{exponentChar.toString()};
                this.error = MessageType.DANGLING_EXP_INDICATOR.create(stringArray);
                return false;
            }
            if (!this.digits()) {
                String[] stringArray = new String[]{String.valueOf(this.scanner.peek())};
                this.error = MessageType.INVALID_DIGITS.create(stringArray);
                return false;
            }
        }
        return true;
    }

    private final boolean sign() {
        block3: {
            block2: {
                Character c = this.scanner.peek();
                char c2 = '+';
                if (c != null && c.charValue() == c2) break block2;
                Character c3 = this.scanner.peek();
                c2 = '-';
                if (c3 == null || c3.charValue() != c2) break block3;
            }
            this.scanner.advanceScanner();
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/kson/parser/NumberParser$NumberParseResult;", "", "number", "Lorg/kson/parser/NumberParser$ParsedNumber;", "error", "Lorg/kson/parser/messages/Message;", "<init>", "(Lorg/kson/parser/NumberParser$ParsedNumber;Lorg/kson/parser/messages/Message;)V", "getNumber", "()Lorg/kson/parser/NumberParser$ParsedNumber;", "getError", "()Lorg/kson/parser/messages/Message;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kson"})
    public static final class NumberParseResult {
        @Nullable
        private final ParsedNumber number;
        @Nullable
        private final Message error;

        public NumberParseResult(@Nullable ParsedNumber number, @Nullable Message error) {
            this.number = number;
            this.error = error;
        }

        @Nullable
        public final ParsedNumber getNumber() {
            return this.number;
        }

        @Nullable
        public final Message getError() {
            return this.error;
        }

        @Nullable
        public final ParsedNumber component1() {
            return this.number;
        }

        @Nullable
        public final Message component2() {
            return this.error;
        }

        @NotNull
        public final NumberParseResult copy(@Nullable ParsedNumber number, @Nullable Message error) {
            return new NumberParseResult(number, error);
        }

        public static /* synthetic */ NumberParseResult copy$default(NumberParseResult numberParseResult, ParsedNumber parsedNumber, Message message, int n, Object object) {
            if ((n & 1) != 0) {
                parsedNumber = numberParseResult.number;
            }
            if ((n & 2) != 0) {
                message = numberParseResult.error;
            }
            return numberParseResult.copy(parsedNumber, message);
        }

        @NotNull
        public String toString() {
            return "NumberParseResult(number=" + this.number + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = this.number == null ? 0 : this.number.hashCode();
            result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NumberParseResult)) {
                return false;
            }
            NumberParseResult numberParseResult = (NumberParseResult)other;
            if (!Intrinsics.areEqual((Object)this.number, (Object)numberParseResult.number)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)numberParseResult.error);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/kson/parser/NumberParser$ParsedNumber;", "", "<init>", "()V", "asString", "", "getAsString", "()Ljava/lang/String;", "asDouble", "", "getAsDouble", "()D", "asDouble$delegate", "Lkotlin/Lazy;", "Integer", "Decimal", "Lorg/kson/parser/NumberParser$ParsedNumber$Decimal;", "Lorg/kson/parser/NumberParser$ParsedNumber$Integer;", "kson"})
    public static abstract class ParsedNumber {
        @NotNull
        private final Lazy asDouble$delegate = LazyKt.lazy(() -> ParsedNumber.asDouble_delegate$lambda$0(this));

        private ParsedNumber() {
        }

        @NotNull
        public abstract String getAsString();

        public final double getAsDouble() {
            Lazy lazy = this.asDouble$delegate;
            return ((Number)lazy.getValue()).doubleValue();
        }

        private static final double asDouble_delegate$lambda$0(ParsedNumber this$0) {
            double d;
            ParsedNumber parsedNumber = this$0;
            if (parsedNumber instanceof Decimal) {
                d = ((Decimal)this$0).getValue();
            } else if (parsedNumber instanceof Integer) {
                d = ((Integer)this$0).getValue();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return d;
        }

        public /* synthetic */ ParsedNumber(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/kson/parser/NumberParser$ParsedNumber$Decimal;", "Lorg/kson/parser/NumberParser$ParsedNumber;", "rawString", "", "<init>", "(Ljava/lang/String;)V", "asString", "getAsString", "()Ljava/lang/String;", "value", "", "getValue", "()D", "value$delegate", "Lkotlin/Lazy;", "trimLeadingZeros", "input", "kson"})
        @SourceDebugExtension(value={"SMAP\nNumberParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberParser.kt\norg/kson/parser/NumberParser$ParsedNumber$Decimal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
        public static final class Decimal
        extends ParsedNumber {
            @NotNull
            private final String asString;
            @NotNull
            private final Lazy value$delegate;

            public Decimal(@NotNull String rawString) {
                Intrinsics.checkNotNullParameter((Object)rawString, (String)"rawString");
                super(null);
                this.asString = this.trimLeadingZeros(rawString);
                this.value$delegate = LazyKt.lazy(() -> Decimal.value_delegate$lambda$0(this));
            }

            @Override
            @NotNull
            public String getAsString() {
                return this.asString;
            }

            public final double getValue() {
                Lazy lazy = this.value$delegate;
                return ((Number)lazy.getValue()).doubleValue();
            }

            @NotNull
            public final String trimLeadingZeros(@NotNull String input) {
                Object object;
                Object object2;
                String exponentPart;
                String string;
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                boolean isNegative = StringsKt.startsWith$default((String)input, (String)"-", (boolean)false, (int)2, null);
                if (isNegative) {
                    String string2 = input.substring(1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = input;
                }
                String unsigned = string;
                char[] cArray = new char[]{'E', 'e'};
                List parts = StringsKt.split$default((CharSequence)unsigned, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String mainPart = (String)parts.get(0);
                String string3 = exponentPart = parts.size() > 1 ? "e" + parts.get(1) : "";
                if (StringsKt.contains$default((CharSequence)mainPart, (char)'.', (boolean)false, (int)2, null)) {
                    Object object3;
                    char[] cArray2 = new char[]{'.'};
                    object2 = StringsKt.split$default((CharSequence)mainPart, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
                    String intPart = (String)object2.get(0);
                    String fracPart = (String)object2.get(1);
                    Object object4 = new char[]{'0'};
                    if ((object4 = (Object)StringsKt.trimStart((String)intPart, (char[])object4)).length() == 0) {
                        boolean bl = false;
                        object3 = "0";
                    } else {
                        object3 = object4;
                    }
                    String trimmedIntPart = (String)object3;
                    object = ((CharSequence)fracPart).length() == 0 ? trimmedIntPart : trimmedIntPart + "." + fracPart;
                } else {
                    Object object5;
                    object2 = new char[]{'0'};
                    if ((object2 = (Object)StringsKt.trimStart((String)mainPart, (char[])object2)).length() == 0) {
                        boolean bl = false;
                        object5 = "0";
                    } else {
                        object5 = object2;
                    }
                    object = (String)object5;
                }
                String mainTrimmedPart = object;
                char[] $this$trimLeadingZeros_u24lambda_u243 = object2 = new StringBuilder();
                boolean bl = false;
                if (isNegative) {
                    $this$trimLeadingZeros_u24lambda_u243.append("-");
                }
                $this$trimLeadingZeros_u24lambda_u243.append(mainTrimmedPart);
                if (((CharSequence)exponentPart).length() > 0) {
                    $this$trimLeadingZeros_u24lambda_u243.append(exponentPart);
                }
                return object2.toString();
            }

            private static final double value_delegate$lambda$0(Decimal this$0) {
                return Double.parseDouble(this$0.getAsString());
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/kson/parser/NumberParser$ParsedNumber$Integer;", "Lorg/kson/parser/NumberParser$ParsedNumber;", "rawString", "", "<init>", "(Ljava/lang/String;)V", "asString", "getAsString", "()Ljava/lang/String;", "value", "", "getValue", "()J", "trimLeadingZeros", "input", "kson"})
        @SourceDebugExtension(value={"SMAP\nNumberParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberParser.kt\norg/kson/parser/NumberParser$ParsedNumber$Integer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1#2:308\n*E\n"})
        public static final class Integer
        extends ParsedNumber {
            @NotNull
            private final String asString;
            private final long value;

            public Integer(@NotNull String rawString) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)rawString, (String)"rawString");
                super(null);
                this.asString = this.trimLeadingZeros(rawString);
                Integer integer = this;
                Object object2 = new char[]{'0'};
                object2 = StringsKt.trimStart((String)rawString, (char[])object2);
                if (object2.length() == 0) {
                    Integer integer2 = integer;
                    boolean bl = false;
                    object = "0";
                    integer = integer2;
                } else {
                    object = object2;
                }
                integer.value = NumberParserKt.access$convertToLong((String)object);
            }

            @Override
            @NotNull
            public String getAsString() {
                return this.asString;
            }

            public final long getValue() {
                return this.value;
            }

            @NotNull
            public final String trimLeadingZeros(@NotNull String input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                if (StringsKt.startsWith$default((String)input, (String)"-", (boolean)false, (int)2, null)) {
                    Object object;
                    String string = input.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    Object object2 = new char[]{'0'};
                    String trimmed = StringsKt.trimStart((String)string, (char[])object2);
                    object2 = trimmed;
                    if (object2.length() == 0) {
                        boolean bl = false;
                        object = "0";
                    } else {
                        object = object2;
                    }
                    return "-" + object;
                }
                char[] cArray = new char[]{'0'};
                String trimmed = StringsKt.trimStart((String)input, (char[])cArray);
                return ((CharSequence)trimmed).length() == 0 ? "0" : trimmed;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kson/parser/NumberParser$Scanner;", "", "source", "", "<init>", "(Ljava/lang/String;)V", "currentSourceIndex", "", "peek", "", "()Ljava/lang/Character;", "advanceScanner", "", "eof", "", "kson"})
    private static final class Scanner {
        @NotNull
        private final String source;
        private int currentSourceIndex;

        public Scanner(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        @Nullable
        public final Character peek() {
            if (this.eof()) {
                return null;
            }
            return Character.valueOf(this.source.charAt(this.currentSourceIndex));
        }

        public final void advanceScanner() {
            int n = this.currentSourceIndex;
            this.currentSourceIndex = n + 1;
        }

        public final boolean eof() {
            return this.currentSourceIndex >= this.source.length();
        }
    }
}

