/*
 * Decompiled with CFR 0.152.
 */
package org.kson.parser;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.Coordinates;
import org.kson.parser.Lexeme;
import org.kson.parser.Location;
import org.kson.stdlibx.exceptions.ShouldNotHappenException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\r\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\r\u0010\u0014\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kson/parser/SourceScanner;", "", "source", "", "<init>", "(Ljava/lang/String;)V", "selectionStartOffset", "", "selectionEndOffset", "selectionFirstLine", "selectionFirstColumn", "selectionEndLine", "selectionEndColumn", "eof", "", "eofIn", "numCharsToEof", "peek", "", "()Ljava/lang/Character;", "peekNext", "advance", "extractLexeme", "Lorg/kson/parser/Lexeme;", "startNextSelection", "", "currentLocation", "Lorg/kson/parser/Location;", "kson"})
final class SourceScanner {
    @NotNull
    private final String source;
    private int selectionStartOffset;
    private int selectionEndOffset;
    private int selectionFirstLine;
    private int selectionFirstColumn;
    private int selectionEndLine;
    private int selectionEndColumn;

    public SourceScanner(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
    }

    public final boolean eof() {
        return this.eofIn(0);
    }

    private final boolean eofIn(int numCharsToEof) {
        return this.selectionEndOffset + numCharsToEof >= this.source.length();
    }

    @Nullable
    public final Character peek() {
        if (this.eof()) {
            return null;
        }
        return Character.valueOf(this.source.charAt(this.selectionEndOffset));
    }

    @Nullable
    public final Character peekNext() {
        if (this.eofIn(1)) {
            return null;
        }
        return Character.valueOf(this.source.charAt(this.selectionEndOffset + 1));
    }

    public final char advance() {
        int n = this.selectionEndOffset;
        this.selectionEndOffset = n + 1;
        char currentChar = this.source.charAt(n);
        n = this.selectionEndColumn;
        this.selectionEndColumn = n + 1;
        if (currentChar == '\n') {
            n = this.selectionEndLine;
            this.selectionEndLine = n + 1;
            this.selectionEndColumn = 0;
        }
        return currentChar;
    }

    @NotNull
    public final Lexeme extractLexeme() {
        if (this.selectionEndOffset > this.source.length()) {
            throw new ShouldNotHappenException("Scanner has been advanced past end of source---missing some needed calls to peek()?");
        }
        String string = this.source.substring(this.selectionStartOffset, this.selectionEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Lexeme lexeme = new Lexeme(string, this.currentLocation());
        this.startNextSelection();
        return lexeme;
    }

    private final void startNextSelection() {
        this.selectionStartOffset = this.selectionEndOffset;
        this.selectionFirstLine = this.selectionEndLine;
        this.selectionFirstColumn = this.selectionEndColumn;
    }

    @NotNull
    public final Location currentLocation() {
        return new Location(new Coordinates(this.selectionFirstLine, this.selectionFirstColumn), new Coordinates(this.selectionEndLine, this.selectionEndColumn), this.selectionStartOffset, this.selectionEndOffset);
    }
}

