/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.parser.messages.Message;
import org.kson.parser.messages.MessageType;
import org.kson.stdlibx.exceptions.ShouldNotHappenException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kson/schema/JsonPointerParser;", "", "pointerString", "", "<init>", "(Ljava/lang/String;)V", "scanner", "Lorg/kson/schema/JsonPointerParser$Scanner;", "error", "Lorg/kson/parser/messages/Message;", "tokens", "", "parse", "Lorg/kson/schema/JsonPointerParser$ParseResult;", "jsonPointer", "", "referenceToken", "isUnescaped", "char", "", "escaped", "()Ljava/lang/Character;", "Companion", "ParseResult", "Scanner", "kson"})
public final class JsonPointerParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pointerString;
    @NotNull
    private final Scanner scanner;
    @Nullable
    private Message error;
    @NotNull
    private final List<String> tokens;
    private static final char PATH_SEPARATOR = '/';
    private static final char ESCAPE_CHAR = '~';
    private static final char TILDE_ESCAPE = '0';
    private static final char SLASH_ESCAPE = '1';

    public JsonPointerParser(@NotNull String pointerString) {
        Intrinsics.checkNotNullParameter((Object)pointerString, (String)"pointerString");
        this.pointerString = pointerString;
        this.scanner = new Scanner(this.pointerString);
        this.tokens = new ArrayList();
    }

    @NotNull
    public final ParseResult parse() {
        if (!this.jsonPointer()) {
            Message message = this.error;
            if (message == null) {
                throw new RuntimeException("must always set `errorMessage` for a failed parse");
            }
            return new ParseResult.Error(message);
        }
        if (!this.scanner.eof()) {
            Character c = this.scanner.peek();
            if (this.tokens.isEmpty()) {
                Character c2 = c;
                char c3 = '/';
                if (c2 == null || c2.charValue() != c3) {
                    String[] stringArray = new String[]{String.valueOf(c)};
                    return new ParseResult.Error(MessageType.JSON_POINTER_BAD_START.create(stringArray));
                }
            }
            throw new ShouldNotHappenException("All unicode characters after the initial slash are allowed an consumed by the parser");
        }
        return new ParseResult.Success(CollectionsKt.toList((Iterable)this.tokens));
    }

    private final boolean jsonPointer() {
        block1: {
            do {
                Character c = this.scanner.peek();
                char c2 = '/';
                if (c == null || c.charValue() != c2) break block1;
                this.scanner.advance();
            } while (this.referenceToken());
            return false;
        }
        return true;
    }

    private final boolean referenceToken() {
        StringBuilder tokenBuilder = new StringBuilder();
        while (!this.scanner.eof()) {
            Character c = this.scanner.peek();
            char c2 = '/';
            if (c != null && c.charValue() == c2) break;
            Character c3 = this.scanner.peek();
            Intrinsics.checkNotNull((Object)c3);
            char c4 = c3.charValue();
            if (c4 == '~') {
                Character c5 = this.escaped();
                if (c5 == null) {
                    return false;
                }
                char escapedChar = c5.charValue();
                tokenBuilder.append(escapedChar);
                continue;
            }
            if (this.isUnescaped(c4)) {
                tokenBuilder.append(c4);
                this.scanner.advance();
                continue;
            }
            String[] stringArray = new String[]{String.valueOf(c4)};
            this.error = MessageType.JSON_POINTER_INVALID_CHARACTER.create(stringArray);
            return false;
        }
        String string = tokenBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.tokens.add(string);
        return true;
    }

    private final boolean isUnescaped(char c) {
        char code = c;
        return code != '/' && code != '~';
    }

    private final Character escaped() {
        Character c;
        Character nextChar;
        Character c2 = this.scanner.peek();
        char c3 = '~';
        if (c2 == null || c2.charValue() != c3) {
            return null;
        }
        this.scanner.advance();
        if (this.scanner.eof()) {
            this.error = MessageType.JSON_POINTER_INCOMPLETE_ESCAPE.create(new String[0]);
            return null;
        }
        Character c4 = nextChar = this.scanner.peek();
        char c5 = '0';
        if (c4 != null && c4.charValue() == c5) {
            this.scanner.advance();
            c = Character.valueOf('~');
        } else {
            Character c6 = nextChar;
            c5 = '1';
            if (c6 != null && c6.charValue() == c5) {
                this.scanner.advance();
                c = Character.valueOf('/');
            } else {
                String[] stringArray = new String[]{String.valueOf(nextChar)};
                this.error = MessageType.JSON_POINTER_INVALID_ESCAPE.create(stringArray);
                c = null;
            }
        }
        return c;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kson/schema/JsonPointerParser$Companion;", "", "<init>", "()V", "PATH_SEPARATOR", "", "ESCAPE_CHAR", "TILDE_ESCAPE", "SLASH_ESCAPE", "kson"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/kson/schema/JsonPointerParser$ParseResult;", "", "<init>", "()V", "Success", "Error", "Lorg/kson/schema/JsonPointerParser$ParseResult$Error;", "Lorg/kson/schema/JsonPointerParser$ParseResult$Success;", "kson"})
    public static abstract class ParseResult {
        private ParseResult() {
        }

        public /* synthetic */ ParseResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/kson/schema/JsonPointerParser$ParseResult$Error;", "Lorg/kson/schema/JsonPointerParser$ParseResult;", "message", "Lorg/kson/parser/messages/Message;", "<init>", "(Lorg/kson/parser/messages/Message;)V", "getMessage", "()Lorg/kson/parser/messages/Message;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kson"})
        public static final class Error
        extends ParseResult {
            @NotNull
            private final Message message;

            public Error(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                super(null);
                this.message = message;
            }

            @NotNull
            public final Message getMessage() {
                return this.message;
            }

            @NotNull
            public final Message component1() {
                return this.message;
            }

            @NotNull
            public final Error copy(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return new Error(message);
            }

            public static /* synthetic */ Error copy$default(Error error, Message message, int n, Object object) {
                if ((n & 1) != 0) {
                    message = error.message;
                }
                return error.copy(message);
            }

            @NotNull
            public String toString() {
                return "Error(message=" + this.message + ")";
            }

            public int hashCode() {
                return this.message.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                return Intrinsics.areEqual((Object)this.message, (Object)error.message);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/kson/schema/JsonPointerParser$ParseResult$Success;", "Lorg/kson/schema/JsonPointerParser$ParseResult;", "tokens", "", "", "<init>", "(Ljava/util/List;)V", "getTokens", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kson"})
        public static final class Success
        extends ParseResult {
            @NotNull
            private final List<String> tokens;

            public Success(@NotNull List<String> tokens) {
                Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
                super(null);
                this.tokens = tokens;
            }

            @NotNull
            public final List<String> getTokens() {
                return this.tokens;
            }

            @NotNull
            public final List<String> component1() {
                return this.tokens;
            }

            @NotNull
            public final Success copy(@NotNull List<String> tokens) {
                Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
                return new Success(tokens);
            }

            public static /* synthetic */ Success copy$default(Success success, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = success.tokens;
                }
                return success.copy(list);
            }

            @NotNull
            public String toString() {
                return "Success(tokens=" + this.tokens + ")";
            }

            public int hashCode() {
                return ((Object)this.tokens).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual(this.tokens, success.tokens);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/kson/schema/JsonPointerParser$Scanner;", "", "source", "", "<init>", "(Ljava/lang/String;)V", "value", "", "currentIndex", "getCurrentIndex", "()I", "peek", "", "()Ljava/lang/Character;", "advance", "", "eof", "", "kson"})
    private static final class Scanner {
        @NotNull
        private final String source;
        private int currentIndex;

        public Scanner(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        @Nullable
        public final Character peek() {
            return this.eof() ? null : Character.valueOf(this.source.charAt(this.currentIndex));
        }

        public final void advance() {
            if (!this.eof()) {
                int n = this.currentIndex;
                this.currentIndex = n + 1;
            }
        }

        public final boolean eof() {
            return this.currentIndex >= this.source.length();
        }
    }
}

