/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.KsonList;
import org.kson.KsonObject;
import org.kson.KsonObjectProperty;
import org.kson.KsonString;
import org.kson.KsonValue;
import org.kson.schema.Draft7MetaSchema;
import org.kson.schema.ResolvedRef;
import org.kson.schema.SchemaIdLookupKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kson/schema/SchemaIdLookup;", "", "schemaRootValue", "Lorg/kson/KsonValue;", "<init>", "(Lorg/kson/KsonValue;)V", "idMap", "", "", "resolveRef", "Lorg/kson/schema/ResolvedRef;", "ref", "currentBaseUri", "Companion", "kson"})
@SourceDebugExtension(value={"SMAP\nSchemaIdLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaIdLookup.kt\norg/kson/schema/SchemaIdLookup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,543:1\n1#2:544\n*E\n"})
public final class SchemaIdLookup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, KsonValue> idMap;

    public SchemaIdLookup(@NotNull KsonValue schemaRootValue) {
        block3: {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)schemaRootValue, (String)"schemaRootValue");
                    this.idMap = new LinkedHashMap();
                    this.idMap.put("http://json-schema.org/draft-07/schema", Draft7MetaSchema.INSTANCE.getSchemaValue());
                    if (!(schemaRootValue instanceof KsonObject)) break block3;
                    object = ((KsonObject)schemaRootValue).getPropertyLookup().get("$id");
                    if (object == null) break block4;
                    KsonValue idValue = object;
                    boolean bl = false;
                    String string = idValue instanceof KsonString ? ((KsonString)idValue).getValue() : null;
                    object = string;
                    if (string != null) break block5;
                }
                object = "";
            }
            Object rootBaseUri = object;
            this.idMap.put((String)rootBaseUri, schemaRootValue);
            SchemaIdLookup.Companion.walkSchemaForIds(schemaRootValue, this.idMap, (String)rootBaseUri);
        }
    }

    @Nullable
    public final ResolvedRef resolveRef(@NotNull String ref, @NotNull String currentBaseUri) {
        ResolvedRef resolvedRef;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)currentBaseUri, (String)"currentBaseUri");
        Companion.RefUriParts resolvedRefUri = Companion.resolveUri(ref, currentBaseUri);
        KsonValue ksonValue = this.idMap.get(resolvedRefUri.toString());
        if (ksonValue != null) {
            KsonValue it = ksonValue;
            boolean bl = false;
            return new ResolvedRef(it, currentBaseUri);
        }
        if (StringsKt.startsWith$default((String)resolvedRefUri.getFragment(), (String)"#/", (boolean)false, (int)2, null)) {
            String string = resolvedRefUri.getFragment().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String decodedPointer = SchemaIdLookupKt.access$decodeUriEncoding(string);
            if (!StringsKt.isBlank((CharSequence)resolvedRefUri.getOrigin())) {
                KsonValue ksonValue2 = this.idMap.get(StringsKt.substringBefore$default((String)resolvedRefUri.toString(), (String)"#", null, (int)2, null));
                if (ksonValue2 != null) {
                    KsonValue it = ksonValue2;
                    boolean bl = false;
                    resolvedRef = SchemaIdLookupKt.access$resolveJsonPointer(decodedPointer, it, resolvedRefUri.toString());
                } else {
                    resolvedRef = null;
                }
            } else {
                KsonValue ksonValue3 = this.idMap.get(currentBaseUri);
                if (ksonValue3 != null) {
                    KsonValue it = ksonValue3;
                    boolean bl = false;
                    resolvedRef = SchemaIdLookupKt.access$resolveJsonPointer(decodedPointer, it, currentBaseUri);
                } else {
                    resolvedRef = null;
                }
            }
        } else {
            ksonValue = this.idMap.get(StringsKt.substringBefore$default((String)resolvedRefUri.toString(), (String)"#", null, (int)2, null) + StringsKt.removePrefix((String)resolvedRefUri.getFragment(), (CharSequence)"#"));
            if (ksonValue != null) {
                KsonValue it = ksonValue;
                boolean bl = false;
                resolvedRef = new ResolvedRef(it, currentBaseUri);
            } else {
                resolvedRef = null;
            }
        }
        return resolvedRef;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lorg/kson/schema/SchemaIdLookup$Companion;", "", "<init>", "()V", "walkSchemaForIds", "", "schemaValue", "Lorg/kson/KsonValue;", "idMap", "", "", "currentBaseUri", "parseUri", "Lorg/kson/schema/SchemaIdLookup$Companion$RefUriParts;", "uri", "resolveUri", "baseUri", "RefUriParts", "kson"})
    @SourceDebugExtension(value={"SMAP\nSchemaIdLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaIdLookup.kt\norg/kson/schema/SchemaIdLookup$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,543:1\n1869#2,2:544\n1869#2,2:546\n1#3:548\n*S KotlinDebug\n*F\n+ 1 SchemaIdLookup.kt\norg/kson/schema/SchemaIdLookup$Companion\n*L\n101#1:544,2\n108#1:546,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void walkSchemaForIds(KsonValue schemaValue, Map<String, KsonValue> idMap, String currentBaseUri) {
            block5: {
                KsonValue ksonValue;
                block4: {
                    ksonValue = schemaValue;
                    if (!(ksonValue instanceof KsonObject)) break block4;
                    String contextBaseUri = null;
                    contextBaseUri = currentBaseUri;
                    KsonValue ksonValue2 = ((KsonObject)schemaValue).getPropertyLookup().get("$id");
                    if (ksonValue2 != null) {
                        KsonValue idValue = ksonValue2;
                        boolean bl = false;
                        if (idValue instanceof KsonString) {
                            String idString = ((KsonString)idValue).getValue();
                            RefUriParts fullyQualifiedId = Companion.resolveUri(idString, currentBaseUri);
                            contextBaseUri = fullyQualifiedId.toString();
                            idMap.put(contextBaseUri, schemaValue);
                        }
                    }
                    Iterable $this$forEach$iv = ((KsonObject)schemaValue).getPropertyMap().values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        KsonObjectProperty propertyValue = (KsonObjectProperty)element$iv;
                        boolean bl = false;
                        Companion.walkSchemaForIds(propertyValue.getPropValue(), idMap, contextBaseUri);
                    }
                    break block5;
                }
                if (!(ksonValue instanceof KsonList)) break block5;
                Iterable $this$forEach$iv = ((KsonList)schemaValue).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KsonValue element = (KsonValue)element$iv;
                    boolean bl = false;
                    Companion.walkSchemaForIds(element, idMap, currentBaseUri);
                }
            }
        }

        private final RefUriParts parseUri(String uri) {
            Object object;
            if (StringsKt.contains$default((CharSequence)uri, (CharSequence)"://", (boolean)false, (int)2, null)) {
                String scheme = StringsKt.substringBefore$default((String)uri, (String)"://", null, (int)2, null);
                String authority = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)uri, (String)"://", null, (int)2, null), (char)'/', null, (int)2, null), (char)'#', null, (int)2, null);
                object = scheme + "://" + authority;
            } else {
                object = StringsKt.contains$default((CharSequence)StringsKt.substringBefore$default((String)uri, (String)"/", null, (int)2, null), (CharSequence)":", (boolean)false, (int)2, null) ? StringsKt.substringBefore$default((String)uri, (String)"#", null, (int)2, null) : "";
            }
            String origin = object;
            String afterOrigin = StringsKt.substringAfter$default((String)uri, (String)origin, null, (int)2, null);
            String path = StringsKt.isBlank((CharSequence)origin) ? StringsKt.substringBeforeLast$default((String)afterOrigin, (char)'#', null, (int)2, null) : (!StringsKt.isBlank((CharSequence)afterOrigin) && !StringsKt.startsWith$default((String)afterOrigin, (String)"#", (boolean)false, (int)2, null) ? "/" + StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)afterOrigin, (CharSequence)"/"), (char)'#', null, (int)2, null) : "");
            String fragment = StringsKt.contains$default((CharSequence)uri, (char)'#', (boolean)false, (int)2, null) ? "#" + StringsKt.substringAfter$default((String)uri, (char)'#', null, (int)2, null) : "";
            return new RefUriParts(origin, path, fragment);
        }

        @NotNull
        public final RefUriParts resolveUri(@NotNull String uri, @NotNull String baseUri) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
            RefUriParts uriParts = this.parseUri(uri);
            RefUriParts baseUriParts = this.parseUri(baseUri);
            CharSequence charSequence2 = uriParts.getOrigin();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = baseUriParts.getOrigin();
            } else {
                charSequence = charSequence2;
            }
            String origin = (String)charSequence;
            String path = StringsKt.startsWith$default((CharSequence)uriParts.getPath(), (char)'/', (boolean)false, (int)2, null) ? uriParts.getPath() : (!StringsKt.isBlank((CharSequence)uriParts.getPath()) ? StringsKt.substringBeforeLast$default((String)baseUriParts.getPath(), (String)"/", null, (int)2, null) + "/" + StringsKt.removePrefix((String)uriParts.getPath(), (CharSequence)"/") : baseUriParts.getPath());
            return new RefUriParts(origin, path, uriParts.getFragment());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/kson/schema/SchemaIdLookup$Companion$RefUriParts;", "", "origin", "", "path", "fragment", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOrigin", "()Ljava/lang/String;", "getPath", "getFragment", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "kson"})
        public static final class RefUriParts {
            @NotNull
            private final String origin;
            @NotNull
            private final String path;
            @NotNull
            private final String fragment;

            public RefUriParts(@NotNull String origin, @NotNull String path, @NotNull String fragment) {
                Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                this.origin = origin;
                this.path = path;
                this.fragment = fragment;
            }

            @NotNull
            public final String getOrigin() {
                return this.origin;
            }

            @NotNull
            public final String getPath() {
                return this.path;
            }

            @NotNull
            public final String getFragment() {
                return this.fragment;
            }

            @NotNull
            public String toString() {
                return this.origin + this.path + this.fragment;
            }

            @NotNull
            public final String component1() {
                return this.origin;
            }

            @NotNull
            public final String component2() {
                return this.path;
            }

            @NotNull
            public final String component3() {
                return this.fragment;
            }

            @NotNull
            public final RefUriParts copy(@NotNull String origin, @NotNull String path, @NotNull String fragment) {
                Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
                return new RefUriParts(origin, path, fragment);
            }

            public static /* synthetic */ RefUriParts copy$default(RefUriParts refUriParts, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = refUriParts.origin;
                }
                if ((n & 2) != 0) {
                    string2 = refUriParts.path;
                }
                if ((n & 4) != 0) {
                    string3 = refUriParts.fragment;
                }
                return refUriParts.copy(string, string2, string3);
            }

            public int hashCode() {
                int result = this.origin.hashCode();
                result = result * 31 + this.path.hashCode();
                result = result * 31 + this.fragment.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RefUriParts)) {
                    return false;
                }
                RefUriParts refUriParts = (RefUriParts)other;
                if (!Intrinsics.areEqual((Object)this.origin, (Object)refUriParts.origin)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.path, (Object)refUriParts.path)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.fragment, (Object)refUriParts.fragment);
            }
        }
    }
}

