/*
 * Decompiled with CFR 0.152.
 */
package org.kson.schema.validators;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kson.KsonObject;
import org.kson.KsonObjectProperty;
import org.kson.KsonString;
import org.kson.parser.MessageSink;
import org.kson.parser.messages.MessageType;
import org.kson.schema.validators.DependencyValidator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/kson/schema/validators/DependencyValidatorArray;", "Lorg/kson/schema/validators/DependencyValidator;", "dependency", "", "Lorg/kson/KsonString;", "<init>", "(Ljava/util/Set;)V", "getDependency", "()Ljava/util/Set;", "validate", "", "ksonObject", "Lorg/kson/KsonObject;", "requiredBy", "Lorg/kson/KsonObjectProperty;", "messageSink", "Lorg/kson/parser/MessageSink;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kson"})
@SourceDebugExtension(value={"SMAP\nDependenciesValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependenciesValidator.kt\norg/kson/schema/validators/DependencyValidatorArray\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1869#2,2:59\n*S KotlinDebug\n*F\n+ 1 DependenciesValidator.kt\norg/kson/schema/validators/DependencyValidatorArray\n*L\n34#1:59,2\n*E\n"})
public final class DependencyValidatorArray
implements DependencyValidator {
    @NotNull
    private final Set<KsonString> dependency;

    public DependencyValidatorArray(@NotNull Set<KsonString> dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        this.dependency = dependency;
    }

    @NotNull
    public final Set<KsonString> getDependency() {
        return this.dependency;
    }

    @Override
    public boolean validate(@NotNull KsonObject ksonObject, @NotNull KsonObjectProperty requiredBy, @NotNull MessageSink messageSink) {
        Intrinsics.checkNotNullParameter((Object)ksonObject, (String)"ksonObject");
        Intrinsics.checkNotNullParameter((Object)requiredBy, (String)"requiredBy");
        Intrinsics.checkNotNullParameter((Object)messageSink, (String)"messageSink");
        Set<String> propertyNames = ksonObject.getPropertyMap().keySet();
        boolean dependenciesMissing = false;
        Iterable $this$forEach$iv = this.dependency;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KsonString it = (KsonString)element$iv;
            boolean bl = false;
            String requiredPropertyName = it.getValue();
            if (propertyNames.contains(requiredPropertyName)) continue;
            dependenciesMissing = true;
            KsonString requiredByName = requiredBy.getPropName();
            String[] stringArray = new String[]{requiredByName.getValue(), requiredPropertyName};
            messageSink.error(requiredByName.getLocation(), MessageType.SCHEMA_MISSING_REQUIRED_DEPENDENCIES.create(stringArray));
        }
        return dependenciesMissing;
    }

    @NotNull
    public final Set<KsonString> component1() {
        return this.dependency;
    }

    @NotNull
    public final DependencyValidatorArray copy(@NotNull Set<KsonString> dependency) {
        Intrinsics.checkNotNullParameter(dependency, (String)"dependency");
        return new DependencyValidatorArray(dependency);
    }

    public static /* synthetic */ DependencyValidatorArray copy$default(DependencyValidatorArray dependencyValidatorArray, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = dependencyValidatorArray.dependency;
        }
        return dependencyValidatorArray.copy(set);
    }

    @NotNull
    public String toString() {
        return "DependencyValidatorArray(dependency=" + this.dependency + ")";
    }

    public int hashCode() {
        return ((Object)this.dependency).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DependencyValidatorArray)) {
            return false;
        }
        DependencyValidatorArray dependencyValidatorArray = (DependencyValidatorArray)other;
        return Intrinsics.areEqual(this.dependency, dependencyValidatorArray.dependency);
    }
}

